/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private Map<KeyBinding, BiConsumer<KeyBinding, Integer>> keyFunctions;
    private Set<Object> packets = Sets.newHashSet();
    private Minecraft minecraft;
    private ClientPlayerEntity player;
    private LocalPlayerPatch playerpatch;
    private KeyBindingMap keyHash;
    private int mouseLeftPressCounter = 0;
    private int sneakPressCounter = 0;
    private int reservedKey;
    private int reserveCounter;
    private int lastHotbarLockedTime;
    private boolean sneakPressToggle = false;
    private boolean mouseLeftPressToggle = false;
    private boolean hotbarLocked;
    private boolean lightPress;
    public GameSettings options;

    public ControllEngine() {
        Events.controllEngine = this;
        this.minecraft = Minecraft.func_71410_x();
        this.options = this.minecraft.field_71474_y;
        this.keyFunctions = Maps.newHashMap();
        this.keyFunctions.put(this.options.field_74312_F, this::attackKeyPressed);
        this.keyFunctions.put(this.options.field_186718_X, this::swapHandKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.SWITCH_MODE, this::switchModeKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.DODGE, this::dodgeKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.SPECIAL_SKILL, this::specialSkillKeyPressed);
        try {
            this.keyHash = (KeyBindingMap)ObfuscationReflectionHelper.findField(KeyBinding.class, (String)"field_74514_b").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setPlayerPatch(LocalPlayerPatch playerpatch) {
        this.mouseLeftPressCounter = 0;
        this.mouseLeftPressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.lightPress = false;
        this.player = (ClientPlayerEntity)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.func_110317_t();
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.func_110317_t();
    }

    private void attackKeyPressed(KeyBinding key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode()) {
            this.setKeyBind(key, false);
            while (key.func_151468_f()) {
            }
            UseAction useAnim = this.playerpatch.getHoldingItemCapability(((ClientPlayerEntity)this.playerpatch.getOriginal()).func_184600_cs()).getUseAnimation(this.playerpatch);
            if (!(this.player.func_184605_cv() != 0 && useAnim != UseAction.BLOCK || this.mouseLeftPressToggle)) {
                this.mouseLeftPressToggle = true;
            }
        }
    }

    private void dodgeKeyPressed(KeyBinding key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode()) {
            if (key.getKey().func_197937_c() == this.options.field_228046_af_.getKey().func_197937_c()) {
                if (this.player.func_184187_bx() == null && !this.sneakPressToggle) {
                    this.sneakPressToggle = true;
                }
            } else {
                SkillCategories skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillCategories.KNOCKDOWN_WAKEUP : SkillCategories.DODGE;
                SkillContainer skill = this.playerpatch.getSkill(skillCategory);
                if (skill.canExecute(this.playerpatch) && skill.getSkill().isExecutableState(this.playerpatch)) {
                    skill.sendExecuteRequest(this.playerpatch, this.packets);
                }
            }
        }
    }

    private void swapHandKeyPressed(KeyBinding key, int action) {
        if (this.playerpatch.getEntityState().inaction() || !this.playerpatch.getHoldingItemCapability(Hand.MAIN_HAND).canBePlacedOffhand()) {
            while (key.func_151468_f()) {
            }
            this.setKeyBind(key, false);
        }
    }

    private void switchModeKeyPressed(KeyBinding key, int action) {
        if (action == 1) {
            this.playerpatch.toggleMode();
        }
    }

    private void specialSkillKeyPressed(KeyBinding key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode()) {
            if (key.getKey().func_197937_c() != 0) {
                if (!this.playerpatch.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).sendExecuteRequest(this.playerpatch, this.packets)) {
                    if (!this.player.func_175149_v()) {
                        this.reserveKey(SkillCategories.WEAPON_SPECIAL_ATTACK);
                    }
                } else {
                    this.lockHotkeys();
                }
            } else if (this.options.field_74312_F.equals(EpicFightKeyMappings.SPECIAL_SKILL)) {
                KeyBinding.func_197981_a((InputMappings.Input)this.options.field_74312_F.getKey());
            }
        }
    }

    public void tick() {
        if (this.playerpatch == null) {
            return;
        }
        if (this.player.field_70173_aa - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.mouseLeftPressToggle) {
            if (!this.isKeyDown(this.options.field_74312_F)) {
                this.lightPress = true;
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
            } else if (EpicFightKeyMappings.SPECIAL_SKILL.getKey().equals((Object)this.options.field_74312_F.getKey())) {
                if (this.mouseLeftPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                    if (!this.playerpatch.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).sendExecuteRequest(this.playerpatch, this.packets)) {
                        if (!this.player.func_175149_v()) {
                            this.reserveKey(SkillCategories.WEAPON_SPECIAL_ATTACK);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.mouseLeftPressToggle = false;
                    this.mouseLeftPressCounter = 0;
                } else {
                    this.setKeyBind(this.options.field_74312_F, false);
                    ++this.mouseLeftPressCounter;
                }
            }
        }
        if (this.lightPress) {
            SkillCategories slot;
            SkillCategories skillCategories = slot = !this.player.func_233570_aj_() && !this.player.func_70090_H() && this.player.func_213322_ci().field_72448_b > -0.05 ? SkillCategories.AIR_ATTACK : SkillCategories.BASIC_ATTACK;
            if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this.packets)) {
                this.player.func_184821_cY();
                this.lightPress = false;
                this.resetReservedKey();
                this.lockHotkeys();
            } else if (!this.player.func_175149_v() && slot != SkillCategories.AIR_ATTACK) {
                this.reserveKey(slot);
            }
            this.lightPress = false;
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!this.isKeyDown(this.options.field_228046_af_)) {
                SkillCategories skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillCategories.KNOCKDOWN_WAKEUP : SkillCategories.DODGE;
                SkillContainer skill = this.playerpatch.getSkill(skillCategory);
                if (!skill.sendExecuteRequest(this.playerpatch, this.packets)) {
                    this.reserveKey(SkillCategories.DODGE);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.reservedKey >= 0) {
            if (this.reserveCounter > 0) {
                SkillContainer skill = this.playerpatch.getSkill(this.reservedKey);
                --this.reserveCounter;
                if (skill.getSkill() != null) {
                    if (skill.sendExecuteRequest(this.playerpatch, this.packets)) {
                        this.resetReservedKey();
                    } else {
                        this.lockHotkeys();
                    }
                }
            } else {
                this.resetReservedKey();
            }
        }
        if (this.playerpatch.getEntityState().inaction() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.field_151456_ac[i].func_151468_f()) {
                }
            }
        }
        if (EpicFightKeyMappings.SKILL_EDIT.func_151468_f() && this.playerpatch.getSkillCapability() != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new SkillEditScreen(this.playerpatch.getSkillCapability()));
        }
        if (this.minecraft.func_147113_T()) {
            this.minecraft.field_71417_B.func_198029_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i());
        }
    }

    private void reserveKey(SkillCategory slot) {
        this.reservedKey = slot.universalOrdinal();
        this.reserveCounter = 8;
    }

    private void resetReservedKey() {
        this.reservedKey = -1;
        this.reserveCounter = -1;
    }

    public boolean isKeyDown(KeyBinding key) {
        if (key.getKey().func_197938_b() == InputMappings.Type.KEYSYM) {
            return GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key.getKey().func_197937_c()) > 0;
        }
        if (key.getKey().func_197938_b() == InputMappings.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key.getKey().func_197937_c()) > 0;
        }
        return false;
    }

    public void setKeyBind(KeyBinding key, boolean setter) {
        KeyBinding.func_197980_a((InputMappings.Input)key.getKey(), (boolean)setter);
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.field_70173_aa;
        for (int i = 0; i < 9; ++i) {
            while (this.options.field_151456_ac[i].func_151468_f()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseEvent(InputEvent.MouseInputEvent event) {
            if (((ControllEngine)Events.controllEngine).minecraft.field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(event.getButton());
                for (KeyBinding keybinding : controllEngine.keyHash.lookupAll(input)) {
                    if (!controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    ((BiConsumer)controllEngine.keyFunctions.get(keybinding)).accept(keybinding, event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollEvent event) {
            if (((ControllEngine)Events.controllEngine).minecraft.field_71439_g != null && controllEngine.playerpatch != null && controllEngine.playerpatch.getEntityState().inaction() && ((ControllEngine)Events.controllEngine).minecraft.field_71462_r == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void keyboardEvent(InputEvent.KeyInputEvent event) {
            if (((ControllEngine)Events.controllEngine).minecraft.field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                InputMappings.Input input = InputMappings.Type.KEYSYM.func_197944_a(event.getKey());
                for (KeyBinding keybinding : controllEngine.keyHash.lookupAll(input)) {
                    if (!controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    ((BiConsumer)controllEngine.keyFunctions.get(keybinding)).accept(keybinding, event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(InputUpdateEvent event) {
            if (controllEngine.playerpatch == null) {
                return;
            }
            EntityState playerState = controllEngine.playerpatch.getEntityState();
            if (!controllEngine.canPlayerMove(playerState)) {
                event.getMovementInput().field_192832_b = 0.0f;
                event.getMovementInput().field_78902_a = 0.0f;
                event.getMovementInput().field_187255_c = false;
                event.getMovementInput().field_187256_d = false;
                event.getMovementInput().field_187257_e = false;
                event.getMovementInput().field_187258_f = false;
                event.getMovementInput().field_78901_c = false;
                event.getMovementInput().field_228350_h_ = false;
                ClientPlayerEntity clientPlayer = (ClientPlayerEntity)event.getPlayer();
                clientPlayer.func_70031_b(false);
                clientPlayer.field_71156_d = -1;
                controllEngine.setKeyBind(Events.controllEngine.options.field_151444_V, false);
            }
            if (event.getPlayer().func_70089_S()) {
                controllEngine.playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(controllEngine.playerpatch, event.getMovementInput()));
            }
        }

        @SubscribeEvent
        public static void preProcessKeyBindings(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                if (((ControllEngine)Events.controllEngine).minecraft.field_71439_g != null) {
                    controllEngine.tick();
                }
            } else {
                for (Object packet : controllEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                controllEngine.packets.clear();
            }
        }
    }
}

