/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.TridentItem;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.forgeevent.RenderEnderDragonEvent;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.gui.screen.overlay.OverlayManager;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.renderer.AimHelperRenderer;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCreeperRenderer;
import yesman.epicfight.client.renderer.patched.entity.PDrownedRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEnderDragonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEndermanRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHoglinRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIllagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIronGolemRenderer;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PRavagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PSpiderRenderer;
import yesman.epicfight.client.renderer.patched.entity.PStrayRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVexRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVindicatorRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitchRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.entity.PZombieVillagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.WitherGhostCloneRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderBow;
import yesman.epicfight.client.renderer.patched.item.RenderCrossbow;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.item.RenderKatana;
import yesman.epicfight.client.renderer.patched.item.RenderShield;
import yesman.epicfight.client.renderer.patched.item.RenderTrident;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.gamerule.EpicFightGamerules;
import yesman.epicfight.world.item.EpicFightItems;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine {
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    public AimHelperRenderer aimHelper;
    private BattleModeGui guiSkillBar = new BattleModeGui(Minecraft.func_71410_x());
    private Minecraft minecraft;
    private Map<EntityType<?>, Supplier<PatchedEntityRenderer>> entityRendererProvider;
    private Map<EntityType<?>, PatchedEntityRenderer> entityRendererCache;
    private Map<Item, RenderItemBase> itemRendererMapByInstance;
    private Map<Class<? extends Item>, RenderItemBase> itemRendererMapByClass;
    private FirstPersonRenderer firstPersonRenderer;
    private OverlayManager overlayManager;
    private boolean aiming;
    private int zoomOutTimer = 0;
    private int zoomCount;
    private int zoomMaxCount = 20;
    private float cameraXRot;
    private float cameraYRot;
    private float cameraXRotO;
    private float cameraYRotO;
    private boolean isPlayerRotationLocked;

    public RenderEngine() {
        Events.renderEngine = this;
        RenderItemBase.renderEngine = this;
        EntityIndicator.init();
        this.minecraft = Minecraft.func_71410_x();
        this.entityRendererProvider = Maps.newHashMap();
        this.entityRendererCache = Maps.newHashMap();
        this.itemRendererMapByInstance = Maps.newHashMap();
        this.itemRendererMapByClass = Maps.newHashMap();
        this.firstPersonRenderer = new FirstPersonRenderer();
        this.overlayManager = new OverlayManager();
        this.minecraft.func_228019_au_().field_228480_b_.put(EpicFightRenderTypes.enchantedAnimatedArmor(), new BufferBuilder(EpicFightRenderTypes.enchantedAnimatedArmor().func_228662_o_()));
    }

    public void registerRenderer() {
        this.entityRendererProvider.put(EntityType.field_200797_k, PCreeperRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200803_q, PEndermanRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200725_aD, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200727_aF, PZombieVillagerRenderer::new);
        this.entityRendererProvider.put(EntityType.field_233592_ba_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200763_C, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200741_ag, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200722_aA, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200750_ap, PStrayRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200729_aH, PPlayerRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200748_an, PSpiderRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200794_h, PSpiderRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200757_aw, PIronGolemRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200758_ax, PVindicatorRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200806_t, PIllagerRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200759_ay, PWitchRenderer::new);
        this.entityRendererProvider.put(EntityType.field_204724_o, PDrownedRenderer::new);
        this.entityRendererProvider.put(EntityType.field_220350_aJ, PIllagerRenderer::new);
        this.entityRendererProvider.put(EntityType.field_220352_aU, PRavagerRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200755_au, PVexRenderer::new);
        this.entityRendererProvider.put(EntityType.field_233591_ai_, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_242287_aj, PHumanoidRenderer::new);
        this.entityRendererProvider.put(EntityType.field_233588_G_, PHoglinRenderer::new);
        this.entityRendererProvider.put(EntityType.field_233590_aW_, PHoglinRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200802_p, PEnderDragonRenderer::new);
        this.entityRendererProvider.put(EntityType.field_200760_az, PWitherRenderer::new);
        this.entityRendererProvider.put((EntityType<?>)EpicFightEntities.WITHER_SKELETON_MINION.get(), () -> new PWitherSkeletonMinionRenderer().setOverridingTexture("epicfight:textures/entity/wither_skeleton_minion.png"));
        this.entityRendererProvider.put((EntityType<?>)EpicFightEntities.WITHER_GHOST_CLONE.get(), WitherGhostCloneRenderer::new);
        RenderBow bowRenderer = new RenderBow();
        RenderCrossbow crossbowRenderer = new RenderCrossbow();
        RenderShield shieldRenderer = new RenderShield();
        RenderTrident tridentRenderer = new RenderTrident();
        this.itemRendererMapByInstance.clear();
        this.itemRendererMapByInstance.put(Items.field_190931_a, new RenderItemBase());
        this.itemRendererMapByInstance.put(Items.field_151031_f, bowRenderer);
        this.itemRendererMapByInstance.put(Items.field_185159_cQ, shieldRenderer);
        this.itemRendererMapByInstance.put(Items.field_222114_py, crossbowRenderer);
        this.itemRendererMapByInstance.put(Items.field_203184_eO, tridentRenderer);
        this.itemRendererMapByInstance.put((Item)EpicFightItems.KATANA.get(), new RenderKatana());
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.aimHelper = new AimHelperRenderer();
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Add(this.entityRendererProvider, this.itemRendererMapByInstance));
        for (Map.Entry<EntityType<?>, Supplier<PatchedEntityRenderer>> entry : this.entityRendererProvider.entrySet()) {
            this.entityRendererCache.put(entry.getKey(), entry.getValue().get());
        }
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Modify(this.entityRendererCache));
    }

    public void registerCustomEntityRenderer(EntityType<?> entityType, String renderer) {
        if (renderer == "") {
            return;
        }
        EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(renderer));
        if (this.entityRendererProvider.containsKey(presetEntityType)) {
            this.entityRendererCache.put(entityType, this.entityRendererProvider.get(presetEntityType).get());
            return;
        }
        throw new IllegalArgumentException("Datapack Mob Patch Crash: Invalid Renderer type " + renderer);
    }

    public RenderItemBase getItemRenderer(Item item) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(item);
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(item.getClass());
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.field_190931_a);
            }
            this.itemRendererMapByInstance.put(item, renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.getOrDefault(clazz, null);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingEntityPatch<?> entitypatch, LivingRenderer<? extends Entity, ?> renderer, IRenderTypeBuffer buffer, MatrixStack matStack, int packedLightIn, float partialTicks) {
        this.getEntityRenderer((Entity)livingEntity).render(livingEntity, entitypatch, renderer, buffer, matStack, packedLightIn, partialTicks);
    }

    public PatchedEntityRenderer getEntityRenderer(Entity entity) {
        return this.entityRendererCache.get(entity.func_200600_R());
    }

    public boolean hasRendererFor(Entity entity) {
        return this.entityRendererCache.computeIfAbsent(entity.func_200600_R(), key -> this.entityRendererProvider.containsKey(key) ? this.entityRendererProvider.get(entity.func_200600_R()).get() : null) != null;
    }

    public void clearCustomEntityRenerer() {
        this.entityRendererCache.clear();
    }

    public void zoomIn() {
        this.aiming = true;
        this.zoomCount = this.zoomCount == 0 ? 1 : this.zoomCount;
        this.zoomOutTimer = 0;
    }

    public void zoomOut(int timer) {
        this.aiming = false;
        this.zoomOutTimer = timer;
    }

    private void setRangedWeaponThirdPerson(EntityViewRenderEvent.CameraSetup event, PointOfView pov, double partialTicks) {
        if (ClientEngine.instance.getPlayerPatch() == null) {
            return;
        }
        ActiveRenderInfo camera = event.getInfo();
        Entity entity = this.minecraft.func_175606_aa();
        Vector3d vector = camera.func_216785_c();
        double totalX = vector.func_82615_a();
        double totalY = vector.func_82617_b();
        double totalZ = vector.func_82616_c();
        if (pov == PointOfView.THIRD_PERSON_BACK && this.zoomCount > 0) {
            double d3;
            double posX = vector.func_82615_a();
            double posY = vector.func_82617_b();
            double posZ = vector.func_82616_c();
            double entityPosX = entity.field_70142_S + (entity.func_226277_ct_() - entity.field_70142_S) * partialTicks;
            double entityPosY = entity.field_70137_T + (entity.func_226278_cu_() - entity.field_70137_T) * partialTicks + (double)entity.func_70047_e();
            double entityPosZ = entity.field_70136_U + (entity.func_226281_cx_() - entity.field_70136_U) * partialTicks;
            float intpol = pov == PointOfView.THIRD_PERSON_BACK ? (float)this.zoomCount / (float)this.zoomMaxCount : 0.0f;
            Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * intpol, RenderEngine.AIMING_CORRECTION.y * intpol, RenderEngine.AIMING_CORRECTION.z * intpol);
            OpenMatrix4f rotationMatrix = ClientEngine.instance.getPlayerPatch().getMatrix((float)partialTicks);
            Vec3f rotateVec = OpenMatrix4f.transform3v(rotationMatrix, interpolatedCorrection, null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                double d7;
                BlockRayTraceResult raytraceresult;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = this.minecraft.field_71441_e.func_217299_a(new RayTraceContext(new Vector3d(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vector3d(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity))) == null || !((d7 = raytraceresult.func_216347_e().func_72438_d(new Vector3d(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        camera.func_216775_b(totalX, totalY, totalZ);
    }

    public void setCameraRotation(float x, float y) {
        float f = x * 0.15f;
        float f1 = y * 0.15f;
        if (!this.isPlayerRotationLocked) {
            this.cameraXRot = this.minecraft.field_71439_g.field_70125_A;
            this.cameraYRot = this.minecraft.field_71439_g.field_70177_z;
            this.cameraXRotO = this.minecraft.field_71439_g.field_70127_C;
            this.cameraYRotO = this.minecraft.field_71439_g.field_70126_B;
        }
        this.cameraXRot += f;
        this.cameraYRot += f1;
        this.cameraXRot = MathHelper.func_76131_a((float)this.cameraXRot, (float)-90.0f, (float)90.0f);
        this.cameraXRotO += f;
        this.cameraYRotO += f1;
        this.cameraXRotO = MathHelper.func_76131_a((float)this.cameraXRotO, (float)-90.0f, (float)90.0f);
        this.isPlayerRotationLocked = true;
    }

    public boolean isPlayerRotationLocked() {
        return this.isPlayerRotationLocked;
    }

    public void unlockRotation(Entity cameraEntity) {
        if (this.isPlayerRotationLocked) {
            cameraEntity.field_70125_A = this.cameraXRot;
            cameraEntity.field_70177_z = this.cameraYRot;
        }
        this.isPlayerRotationLocked = false;
    }

    public void correctCamera(EntityViewRenderEvent.CameraSetup event, float partialTicks) {
        if (this.isPlayerRotationLocked) {
            ActiveRenderInfo camera = event.getInfo();
            PointOfView cameraType = this.minecraft.field_71474_y.func_243230_g();
            float xRot = this.cameraXRotO + (this.cameraXRot - this.cameraXRotO) * partialTicks;
            float yRot = this.cameraYRotO + (this.cameraYRot - this.cameraYRotO) * partialTicks;
            if (cameraType.func_243193_b()) {
                yRot += 180.0f;
                xRot *= -1.0f;
            }
            camera.func_216776_a(yRot, xRot);
            event.setPitch(xRot);
            event.setYaw(yRot);
            if (!cameraType.func_243192_a()) {
                Entity cameraEntity = this.minecraft.field_175622_Z;
                camera.func_216775_b(MathHelper.func_219803_d((double)partialTicks, (double)cameraEntity.field_70169_q, (double)cameraEntity.func_226277_ct_()), MathHelper.func_219803_d((double)partialTicks, (double)cameraEntity.field_70167_r, (double)cameraEntity.func_226278_cu_()) + (double)MathHelper.func_219799_g((float)partialTicks, (float)camera.field_216802_n, (float)camera.field_216801_m), MathHelper.func_219803_d((double)partialTicks, (double)cameraEntity.field_70166_s, (double)cameraEntity.func_226281_cx_()));
                camera.func_216782_a(-camera.func_216779_a(4.0), 0.0, 0.0);
            }
        }
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public FirstPersonRenderer getFirstPersonRenderer() {
        return this.firstPersonRenderer;
    }

    public void upSlideSkillUI() {
        this.guiSkillBar.slideUp();
    }

    public void downSlideSkillUI() {
        this.guiSkillBar.slideDown();
    }

    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;
        private static final ResourceLocation GUI_BARS_LOCATION;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
            LivingEntity livingentity = event.getEntity();
            if (renderEngine.hasRendererFor((Entity)livingentity)) {
                if (livingentity instanceof ClientPlayerEntity && event.getPartialRenderTick() == 1.0f) {
                    return;
                }
                LivingEntityPatch entitypatch = (LivingEntityPatch)livingentity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                if (entitypatch != null && !entitypatch.shouldSkipRender()) {
                    event.setCanceled(true);
                    renderEngine.renderEntityArmatureModel(livingentity, entitypatch, event.getRenderer(), event.getBuffers(), event.getMatrixStack(), event.getLight(), event.getPartialRenderTick());
                }
            }
            if (!((RenderEngine)Events.renderEngine).minecraft.field_71474_y.field_74319_N && !livingentity.field_70170_p.func_82736_K().func_223586_b(EpicFightGamerules.DISABLE_ENTITY_UI)) {
                for (EntityIndicator entityIndicator : EntityIndicator.ENTITY_INDICATOR_RENDERERS) {
                    if (!entityIndicator.shouldDraw(((RenderEngine)Events.renderEngine).minecraft.field_71439_g, event.getEntity())) continue;
                    entityIndicator.drawIndicator(event.getEntity(), event.getMatrixStack(), event.getBuffers(), event.getPartialRenderTick());
                }
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            block9: {
                LocalPlayerPatch playerpatch;
                CapabilityItem cap;
                block10: {
                    if (event.getPlayer() == null) break block9;
                    cap = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
                    playerpatch = (LocalPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (cap == null || playerpatch == null) break block9;
                    if (!ClientEngine.instance.inputController.isKeyDown(EpicFightKeyMappings.SPECIAL_SKILL_TOOLTIP)) break block10;
                    if (cap.getSpecialAttack(playerpatch) == null) break block9;
                    event.getToolTip().clear();
                    List<ITextComponent> skilltooltip = cap.getSpecialAttack(playerpatch).getTooltipOnItem(event.getItemStack(), cap, playerpatch);
                    for (ITextComponent s : skilltooltip) {
                        event.getToolTip().add(s);
                    }
                    break block9;
                }
                List tooltip = event.getToolTip();
                cap.modifyItemTooltip(event.getItemStack(), event.getToolTip(), playerpatch);
                for (int i = 0; i < tooltip.size(); ++i) {
                    TranslationTextComponent translationComponent;
                    ITextComponent sibling;
                    ITextComponent textComp = (ITextComponent)tooltip.get(i);
                    if (textComp.func_150253_a().size() <= 0 || !((sibling = (ITextComponent)textComp.func_150253_a().get(0)) instanceof TranslationTextComponent) || (translationComponent = (TranslationTextComponent)sibling).func_150271_j().length <= 1 || !(translationComponent.func_150271_j()[1] instanceof TranslationTextComponent)) continue;
                    CapabilityItem itemCapability = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
                    if (((TranslationTextComponent)translationComponent.func_150271_j()[1]).func_150268_i().equals(Attributes.field_233825_h_.func_233754_c_())) {
                        float weaponSpeed = (float)((ClientPlayerEntity)playerpatch.getOriginal()).func_110148_a(Attributes.field_233825_h_).func_111125_b();
                        for (AttributeModifier modifier : event.getItemStack().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
                            weaponSpeed = (float)((double)weaponSpeed + modifier.func_111164_d());
                        }
                        if (itemCapability != null) {
                            for (AttributeModifier modifier : itemCapability.getAttributeModifiers(EquipmentSlotType.MAINHAND, playerpatch).get((Object)Attributes.field_233825_h_)) {
                                weaponSpeed = (float)((double)weaponSpeed + modifier.func_111164_d());
                            }
                        }
                        tooltip.remove(i);
                        tooltip.add(i, new StringTextComponent(String.format(" %.2f ", Float.valueOf(playerpatch.getAttackSpeed(cap, weaponSpeed)))).func_230529_a_((ITextComponent)new TranslationTextComponent(Attributes.field_233825_h_.func_233754_c_())));
                        continue;
                    }
                    if (!((TranslationTextComponent)translationComponent.func_150271_j()[1]).func_150268_i().equals(Attributes.field_233823_f_.func_233754_c_())) continue;
                    float weaponDamage = (float)((ClientPlayerEntity)playerpatch.getOriginal()).func_110148_a(Attributes.field_233823_f_).func_111125_b();
                    weaponDamage += EnchantmentHelper.func_152377_a((ItemStack)event.getItemStack(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
                    for (AttributeModifier modifier : event.getItemStack().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_)) {
                        weaponDamage = (float)((double)weaponDamage + modifier.func_111164_d());
                    }
                    if (itemCapability != null) {
                        for (AttributeModifier modifier : itemCapability.getAttributeModifiers(EquipmentSlotType.MAINHAND, playerpatch).get((Object)Attributes.field_233823_f_)) {
                            weaponDamage = (float)((double)weaponDamage + modifier.func_111164_d());
                        }
                    }
                    tooltip.remove(i);
                    tooltip.add(i, new StringTextComponent(String.format(" %.0f ", Float.valueOf(playerpatch.getDamageToEntity(null, null, weaponDamage)))).func_230529_a_((ITextComponent)new TranslationTextComponent(Attributes.field_233823_f_.func_233754_c_())).func_240699_a_(TextFormatting.DARK_GREEN));
                }
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
            Events.renderEngine.setRangedWeaponThirdPerson(event, ((RenderEngine)Events.renderEngine).minecraft.field_71474_y.func_243230_g(), event.getRenderPartialTicks());
            if (renderEngine.zoomCount > 0) {
                if (renderEngine.zoomOutTimer > 0) {
                    renderEngine.zoomOutTimer--;
                } else {
                    renderEngine.zoomCount = renderEngine.aiming ? renderEngine.zoomCount + 1 : renderEngine.zoomCount - 1;
                }
                renderEngine.zoomCount = Math.min(renderEngine.zoomMaxCount, renderEngine.zoomCount);
            }
            renderEngine.correctCamera(event, (float)event.getRenderPartialTicks());
        }

        @SubscribeEvent
        public static void fogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        }

        @SubscribeEvent
        public static void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                MainWindow window = Minecraft.func_71410_x().func_228018_at_();
                LocalPlayerPatch playerpatch = ClientEngine.instance.getPlayerPatch();
                if (playerpatch != null) {
                    for (SkillContainer skillContainer : playerpatch.getSkillCapability().skillContainers) {
                        if (skillContainer.getSkill() == null) continue;
                        skillContainer.getSkill().onScreen(playerpatch, window.func_198107_o(), window.func_198087_p());
                    }
                    renderEngine.overlayManager.renderTick(window.func_198107_o(), window.func_198087_p());
                    if (Minecraft.func_71382_s()) {
                        renderEngine.guiSkillBar.renderGui(playerpatch, event.getPartialTicks());
                    }
                }
            }
        }

        @SubscribeEvent
        public static void renderGameOverlayPost(RenderGameOverlayEvent.BossInfo event) {
            EnderDragonPatch dragonpatch;
            float stunShield;
            if (event.getBossInfo().func_186744_e().getString().equals("Ender Dragon") && EnderDragonPatch.INSTANCE_CLIENT != null && (stunShield = (dragonpatch = EnderDragonPatch.INSTANCE_CLIENT).getStunShield()) > 0.0f) {
                float progression = stunShield / dragonpatch.getMaxStunShield();
                int x = event.getX();
                int y = event.getY();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ((RenderEngine)Events.renderEngine).minecraft.field_71446_o.func_110577_a(GUI_BARS_LOCATION);
                AbstractGui.func_238466_a_((MatrixStack)event.getMatrixStack(), (int)x, (int)(y + 6), (int)183, (int)2, (float)0.0f, (float)45.0f, (int)182, (int)6, (int)255, (int)255);
                AbstractGui.func_238466_a_((MatrixStack)event.getMatrixStack(), (int)(x + (int)(183.0f * progression)), (int)(y + 6), (int)((int)(183.0f * (1.0f - progression))), (int)2, (float)0.0f, (float)39.0f, (int)182, (int)6, (int)255, (int)255);
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderHandEvent event) {
            boolean isBattleMode;
            LocalPlayerPatch playerpatch = ClientEngine.instance.getPlayerPatch();
            if (playerpatch != null && ((isBattleMode = playerpatch.isBattleMode()) || !EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue().booleanValue())) {
                if (event.getHand() == Hand.MAIN_HAND) {
                    renderEngine.firstPersonRenderer.render((ClientPlayerEntity)playerpatch.getOriginal(), playerpatch, (LivingRenderer<ClientPlayerEntity, PlayerModel<ClientPlayerEntity>>)((LivingRenderer)renderEngine.minecraft.func_175598_ae().func_78713_a(playerpatch.getOriginal())), event.getBuffers(), event.getMatrixStack(), event.getLight(), event.getPartialTicks());
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderWorldLastEvent event) {
            if (renderEngine.zoomCount > 0 && ((RenderEngine)Events.renderEngine).minecraft.field_71474_y.func_243230_g() == PointOfView.THIRD_PERSON_BACK) {
                Events.renderEngine.aimHelper.doRender(event.getMatrixStack(), event.getPartialTicks());
            }
        }

        @SubscribeEvent
        public static void renderEnderDragonEvent(RenderEnderDragonEvent event) {
            EnderDragonPatch entitypatch;
            EnderDragonEntity livingentity = event.getEntity();
            if (renderEngine.hasRendererFor((Entity)livingentity) && (entitypatch = (EnderDragonPatch)livingentity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                event.setCanceled(true);
                renderEngine.getEntityRenderer((Entity)livingentity).render(livingentity, entitypatch, event.getRenderer(), event.getBuffers(), event.getPoseStack(), event.getLight(), event.getPartialRenderTick());
            }
        }

        static {
            GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
        }
    }
}

