/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.screen.EditSwitchingItemScreen;

@OnlyIn(value=Dist.CLIENT)
public class EditItemListScreen
extends Screen {
    private final Screen parentScreen;
    private final EditSwitchingItemScreen.RegisteredItemList targetList;
    private final EditSwitchingItemScreen.RegisteredItemList opponentList;
    private final List<Item> registered;
    private final List<Item> opponentRegistered;
    private ButtonList itemButtonList;
    private ButtonList selectedItemList;

    protected EditItemListScreen(Screen parentScreen, EditSwitchingItemScreen.RegisteredItemList targetList, EditSwitchingItemScreen.RegisteredItemList opponentList) {
        super(StringTextComponent.field_240750_d_);
        this.parentScreen = parentScreen;
        this.targetList = targetList;
        this.opponentList = opponentList;
        this.registered = targetList.toList();
        this.opponentRegistered = opponentList.toList();
    }

    protected void func_231160_c_() {
        ArrayList itemList = Lists.newArrayList((Iterable)ForgeRegistries.ITEMS.getValues());
        ArrayList selectedItemList = this.selectedItemList == null ? Lists.newArrayList() : this.selectedItemList.toList();
        this.itemButtonList = new ButtonList(this.field_230706_i_, this.field_230708_k_ - 50, this.field_230709_l_, 24, this.field_230709_l_ - 120, itemList, Type.LIST);
        this.selectedItemList = new ButtonList(this.field_230706_i_, this.field_230708_k_ - 50, this.field_230709_l_, this.field_230709_l_ - 100, this.field_230709_l_ - 30, selectedItemList, Type.SELECTED);
        this.itemButtonList.func_230959_g_(25);
        this.selectedItemList.func_230959_g_(25);
        this.field_230705_e_.add(this.itemButtonList);
        this.field_230705_e_.add(this.selectedItemList);
        this.field_230705_e_.add(new Button(this.field_230708_k_ / 2 + 125, this.field_230709_l_ - 26, 60, 20, DialogTexts.field_240632_c_, button -> {
            for (Item item : this.selectedItemList.toList()) {
                this.targetList.addEntry(item);
                this.opponentList.removeIfPresent(item);
            }
            this.func_231175_as__();
        }));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        this.itemButtonList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.selectedItemList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        EditItemListScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Item List").func_240699_a_(TextFormatting.UNDERLINE), (int)28, (int)10, (int)0xFFFFFF);
        EditItemListScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Seleted Items").func_240699_a_(TextFormatting.UNDERLINE), (int)28, (int)(this.field_230709_l_ - 114), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressableExtended {
        public void onPress(EditItemListScreen var1, ItemButton var2, int var3, int var4);
    }

    class ItemButton
    extends Button {
        private final Item item;
        private final IPressableExtended pressedAction;

        public ItemButton(int x, int y, int width, int height, IPressableExtended pressedAction, Button.ITooltip onTooltip, EditItemListScreen screen, Item item) {
            super(x, y, width, height, StringTextComponent.field_240750_d_, button -> {}, onTooltip);
            this.item = item;
            this.pressedAction = pressedAction;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.func_231047_b_(mouseX, mouseY)) {
                Tessellator tessellator = Tessellator.func_178181_a();
                GlStateManager.func_227621_I_();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_225582_a_((double)this.field_230690_l_, (double)this.field_230691_m_ + (double)this.field_230689_k_, 0.0).func_225586_a_(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)this.field_230690_l_ + (double)this.field_230688_j_, (double)this.field_230691_m_ + (double)this.field_230689_k_, 0.0).func_225586_a_(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)this.field_230690_l_ + (double)this.field_230688_j_, (double)this.field_230691_m_, 0.0).func_225586_a_(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 0.0).func_225586_a_(255, 255, 255, 255).func_181675_d();
                tessellator.func_78381_a();
                this.field_238487_u_.onTooltip((Button)this, matrixStack, mouseX, mouseY);
            }
            try {
                EditItemListScreen.this.field_230707_j_.func_175042_a(new ItemStack((IItemProvider)this.item), this.field_230690_l_, this.field_230691_m_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ButtonList
    extends ExtendedList<ButtonEntry> {
        private final Type type;
        private final int itemsInColumn;

        public ButtonList(Minecraft mcIn, int width, int height, int top, int bottom, List<Item> items, Type type) {
            super(mcIn, width, height, top, bottom, 18);
            this.itemsInColumn = width / 17;
            this.type = type;
            this.func_230513_b_((AbstractList.AbstractListEntry)new ButtonEntry());
            for (Item item : items) {
                if (this.type == Type.LIST && EditItemListScreen.this.registered.contains(item)) continue;
                this.addItem(item);
            }
        }

        public boolean has(Item item) {
            for (ButtonEntry entry : this.func_231039_at__()) {
                for (ItemButton button : entry.buttonList) {
                    if (!button.item.equals(item)) continue;
                    return true;
                }
            }
            return false;
        }

        public void addItem(Item item) {
            ButtonEntry entry = (ButtonEntry)this.func_230953_d_(this.func_231039_at__().size() - 1);
            if (entry.buttonList.size() > this.itemsInColumn) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new ButtonEntry());
                entry = (ButtonEntry)this.func_230953_d_(this.func_231039_at__().size() - 1);
            }
            IPressableExtended pressAction = null;
            Button.ITooltip onTooltip = null;
            if (this.type == Type.LIST) {
                pressAction = (screen, button, x, y) -> {
                    if (!screen.selectedItemList.has(item)) {
                        screen.selectedItemList.addItem(button.item);
                    }
                };
            } else if (this.type == Type.SELECTED) {
                pressAction = (screen, button, x, y) -> screen.selectedItemList.removeAndRearrange(x, y);
            }
            onTooltip = EditItemListScreen.this.opponentRegistered.contains(item) ? (button, matrixStack, mouseX, mouseY) -> {
                ITextComponent displayName = ((ItemButton)button).item.func_200295_i(ItemStack.field_190927_a);
                EditItemListScreen.this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("epicfight.gui.warn_already_registered", new Object[]{displayName.equals(StringTextComponent.field_240750_d_) ? new StringTextComponent(((ItemButton)button).item.getRegistryName().toString()) : displayName}), mouseX, mouseY);
            } : (button, matrixStack, mouseX, mouseY) -> {
                ITextComponent displayName = ((ItemButton)button).item.func_200295_i(ItemStack.field_190927_a);
                EditItemListScreen.this.func_238652_a_(matrixStack, (ITextComponent)(displayName.equals(StringTextComponent.field_240750_d_) ? new StringTextComponent(((ItemButton)button).item.getRegistryName().toString()) : displayName), mouseX, mouseY);
            };
            entry.buttonList.add(new ItemButton(0, 0, 16, 16, pressAction, onTooltip, EditItemListScreen.this, item));
        }

        public void removeAndRearrange(int x, int y) {
            ((ButtonEntry)this.func_230953_d_(y)).buttonList.remove(x);
        }

        public List<Item> toList() {
            ArrayList result = Lists.newArrayList();
            for (ButtonEntry entry : this.func_231039_at__()) {
                for (ItemButton button : entry.buttonList) {
                    result.add(button.item);
                }
            }
            return result;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            ButtonEntry listener = this.getEntry(mouseX, mouseY);
            if (listener != null) {
                return listener.func_231044_a_(mouseX, mouseY, button);
            }
            return false;
        }

        public ButtonEntry getEntry(double mouseX, double mouseY) {
            if (mouseX < (double)(this.field_230675_l_ + 2) || mouseX > (double)(this.field_230674_k_ - 8) || mouseY < (double)(this.field_230672_i_ + 2) || mouseY > (double)(this.field_230673_j_ - 2)) {
                return null;
            }
            int column = (int)((this.func_230966_l_() + mouseY - (double)this.field_230672_i_ - 4.0) / (double)this.field_230669_c_);
            if (this.func_231039_at__().size() > column) {
                return (ButtonEntry)this.func_230953_d_(column);
            }
            return null;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.func_230433_a_(matrixStack);
            int i = this.func_230952_d_();
            int j = i + 6;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            this.field_230668_b_.func_110434_K().func_110577_a(AbstractGui.field_230663_f_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_((float)this.field_230675_l_ / 32.0f, (float)(this.field_230673_j_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_((float)this.field_230674_k_ / 32.0f, (float)(this.field_230673_j_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_((float)this.field_230674_k_ / 32.0f, (float)(this.field_230672_i_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_((float)this.field_230675_l_ / 32.0f, (float)(this.field_230672_i_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
            int j1 = this.func_230968_n_();
            int k = this.field_230672_i_ + 4 - (int)this.func_230966_l_();
            this.func_230448_a_(matrixStack, j1, k, tessellator);
            this.func_238478_a_(matrixStack, j1, k, mouseX, mouseY, partialTicks);
            this.field_230668_b_.func_110434_K().func_110577_a(AbstractGui.field_230663_f_);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, -100.0).func_225583_a_(0.0f, (float)this.field_230672_i_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230672_i_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230672_i_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230672_i_ - 16.0, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)(this.field_230672_i_ - 16) / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_ - 16.0, -100.0).func_225583_a_(0.0f, (float)(this.field_230672_i_ - 16) / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230671_e_, -100.0).func_225583_a_(0.0f, (float)this.field_230671_e_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230671_e_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230671_e_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230673_j_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230673_j_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, -100.0).func_225583_a_(0.0f, (float)this.field_230673_j_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int k1 = this.func_230955_e_();
            if (k1 > 0) {
                RenderSystem.disableTexture();
                int l1 = (int)((float)((this.field_230673_j_ - this.field_230672_i_) * (this.field_230673_j_ - this.field_230672_i_)) / (float)this.func_230945_b_());
                l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.field_230673_j_ - this.field_230672_i_ - 8));
                int i2 = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - l1) / k1 + this.field_230672_i_;
                if (i2 < this.field_230672_i_) {
                    i2 = this.field_230672_i_;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)(i2 + l1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)(i2 + l1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)i2, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)i2, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)(i2 + l1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)(i2 + l1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)i2, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)i2, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.func_230447_a_(matrixStack, mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }

        public int func_230968_n_() {
            return this.field_230675_l_ + 2;
        }

        protected int func_230952_d_() {
            return this.field_230674_k_ - 6;
        }

        @OnlyIn(value=Dist.CLIENT)
        class ButtonEntry
        extends ExtendedList.AbstractListEntry<ButtonEntry> {
            private final List<ItemButton> buttonList = Lists.newArrayList();

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                int x = 0;
                for (ItemButton button : this.buttonList) {
                    button.field_230690_l_ = left + x;
                    button.field_230691_m_ = top;
                    button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                    x += 16;
                }
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    int row = (int)((mouseX - (double)ButtonList.this.field_230675_l_ - 2.0) / 16.0);
                    int column = (int)((ButtonList.this.func_230966_l_() + mouseY - (double)ButtonList.this.field_230672_i_ - 4.0) / (double)ButtonList.this.field_230669_c_);
                    ItemButton itembutton = this.getButton(row);
                    if (itembutton != null) {
                        ItemButton itemButton = itembutton = itembutton.func_231047_b_(mouseX, mouseY) ? itembutton : null;
                        if (itembutton != null) {
                            itembutton.pressedAction.onPress(EditItemListScreen.this, itembutton, row, column);
                            itembutton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                        }
                    }
                }
                return false;
            }

            public ItemButton getButton(int index) {
                return this.buttonList.size() > index ? this.buttonList.get(index) : null;
            }
        }
    }

    private static enum Type {
        LIST,
        SELECTED;

    }
}

