/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

@OnlyIn(value=Dist.CLIENT)
public class SkillEditScreen
extends Screen {
    private static final ResourceLocation SKILL_EDIT_UI = new ResourceLocation("epicfight", "textures/gui/screen/skill_edit.png");
    private static final TranslationTextComponent NO_SKILLS = new TranslationTextComponent("gui.epicfight.no_skills");
    private CapabilitySkill skills;
    private List<CategoryButton> categoryButtons = Lists.newArrayList();
    private List<LearnSkillButton> learnedSkillButtons = Lists.newArrayList();

    public SkillEditScreen(CapabilitySkill skills) {
        super((ITextComponent)new TranslationTextComponent("gui.epicfight.skill_edit"));
        this.skills = skills;
    }

    public void func_231160_c_() {
        int i = this.field_230708_k_ / 2 - 80;
        int j = this.field_230709_l_ / 2 - 82;
        this.categoryButtons.clear();
        this.learnedSkillButtons.clear();
        for (SkillCategory skillCategory : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!this.skills.hasCategory(skillCategory) || !skillCategory.learnable()) continue;
            CategoryButton categoryButton = new CategoryButton(i, j, 18, 18, this.skills.skillContainers[skillCategory.universalOrdinal()].getSkill(), button -> {
                for (Button button2 : this.learnedSkillButtons) {
                    this.func_231039_at__().remove(button2);
                }
                this.learnedSkillButtons.clear();
                int k = this.field_230708_k_ / 2 - 53;
                int n = this.field_230709_l_ / 2 - 78;
                for (Skill skill : this.skills.getLearnedSkills(skillCategory)) {
                    void var4_7;
                    this.learnedSkillButtons.add(new LearnSkillButton(k, (int)var4_7, 117, 24, skill, (ITextComponent)new TranslationTextComponent(skill.getTranslatableText()), pressedButton -> {
                        if (this.field_230706_i_.field_71439_g.field_71068_ca >= learnedSkill.getRequiredXp() || this.field_230706_i_.field_71439_g.func_184812_l_()) {
                            this.skills.skillContainers[learnedSkill.getCategory().universalOrdinal()].setSkill(learnedSkill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(learnedSkill.getCategory().universalOrdinal(), -1, learnedSkill.toString(), !this.field_230706_i_.field_71439_g.func_184812_l_()));
                            this.func_231175_as__();
                        }
                    }).setActive(!skill.equals(this.skills.skillContainers[skillCategory.universalOrdinal()].getSkill())));
                    var4_7 += 26;
                }
                for (Button button3 : this.learnedSkillButtons) {
                    this.func_230481_d_((IGuiEventListener)button3);
                }
            }, (button, PoseStack, x, y) -> this.func_238654_b_(PoseStack, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(skillCategory.toString()), Math.max(this.field_230708_k_ / 2 - 43, 170)), x, y));
            this.categoryButtons.add(categoryButton);
            this.func_230481_d_((IGuiEventListener)categoryButton);
            j += 18;
        }
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.func_230446_a_(poseStack);
        for (i = 0; i < this.learnedSkillButtons.size(); ++i) {
            this.learnedSkillButtons.get(i).func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        }
        for (i = 0; i < this.categoryButtons.size(); ++i) {
            this.categoryButtons.get(i).func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.categoryButtons.isEmpty()) {
            int lineHeight = 0;
            for (IReorderingProcessor s : this.field_230712_o_.func_238425_b_((ITextProperties)NO_SKILLS, 110)) {
                this.field_230712_o_.func_238422_b_(poseStack, s, (float)(this.field_230708_k_ / 2 - 50), (float)(this.field_230709_l_ / 2 - 72 + lineHeight), 0x303030);
                lineHeight += 10;
            }
        }
    }

    public void func_230446_a_(MatrixStack PoseStack) {
        super.func_230446_a_(PoseStack);
        this.field_230706_i_.func_110434_K().func_110577_a(SKILL_EDIT_UI);
        this.func_238474_b_(PoseStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 100, 0, 0, 177, 200);
    }

    class LearnSkillButton
    extends Button {
        private Skill skill;

        public LearnSkillButton(int x, int y, int width, int height, Skill skill, ITextComponent title, Button.IPressable pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.field_238486_s_);
            this.skill = skill;
        }

        public void func_230430_a_(MatrixStack PoseStack, int mouseX, int mouseY, float partialTicks) {
            SkillEditScreen.this.field_230706_i_.func_110434_K().func_110577_a(SKILL_EDIT_UI);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            int y = this.field_230692_n_ || !this.field_230693_o_ ? 224 : 200;
            this.func_238474_b_(PoseStack, this.field_230690_l_, this.field_230691_m_, 0, y, this.field_230688_j_, this.field_230689_k_);
            RenderSystem.enableBlend();
            SkillEditScreen.this.field_230706_i_.func_110434_K().func_110577_a(this.skill.getSkillTexture());
            AbstractGui.func_238466_a_((MatrixStack)PoseStack, (int)(this.field_230690_l_ + 5), (int)(this.field_230691_m_ + 4), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
            LearnSkillButton.func_238475_b_((MatrixStack)PoseStack, (FontRenderer)SkillEditScreen.this.field_230712_o_, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + 26), (int)(this.field_230691_m_ + 2), (int)-1);
            if (this.field_230693_o_) {
                int color = ((SkillEditScreen)SkillEditScreen.this).field_230706_i_.field_71439_g.field_71068_ca >= this.skill.getRequiredXp() || ((SkillEditScreen)SkillEditScreen.this).field_230706_i_.field_71439_g.func_184812_l_() ? 8453920 : 0xFF6060;
                LearnSkillButton.func_238475_b_((MatrixStack)PoseStack, (FontRenderer)SkillEditScreen.this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.epicfight.changing_cost", new Object[]{this.skill.getRequiredXp()}), (int)(this.field_230690_l_ + 70), (int)(this.field_230691_m_ + 12), (int)color);
            }
        }

        public LearnSkillButton setActive(boolean active) {
            this.field_230693_o_ = active;
            return this;
        }
    }

    class CategoryButton
    extends Button {
        private Skill skill;

        public CategoryButton(int x, int y, int width, int height, Skill skill, Button.IPressable pressedAction, Button.ITooltip onTooltip) {
            super(x, y, width, height, StringTextComponent.field_240750_d_, pressedAction, onTooltip);
            this.skill = skill;
        }

        public void func_230430_a_(MatrixStack PoseStack, int mouseX, int mouseY, float partialTicks) {
            SkillEditScreen.this.field_230706_i_.func_110434_K().func_110577_a(SKILL_EDIT_UI);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            int y = this.field_230692_n_ ? 35 : 17;
            this.func_238474_b_(PoseStack, this.field_230690_l_, this.field_230691_m_, 237, y, this.field_230688_j_, this.field_230689_k_);
            if (this.skill != null) {
                RenderSystem.enableBlend();
                SkillEditScreen.this.field_230706_i_.func_110434_K().func_110577_a(this.skill.getSkillTexture());
                AbstractGui.func_238466_a_((MatrixStack)PoseStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
            }
            if (this.func_230449_g_()) {
                this.func_230443_a_(PoseStack, mouseX, mouseY);
            }
        }
    }
}

