/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.MetaParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.particle.EpicFightParticles;

@OnlyIn(value=Dist.CLIENT)
public class DustParticle
extends SpriteTexturedParticle {
    private PhysicsType physicsType;

    public DustParticle(ClientWorld level, double x, double y, double z, double xd, double yd, double zd, PhysicsType physicsType) {
        super(level, x, y, z);
        float angle;
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70544_f = physicsType == PhysicsType.NORMAL ? this.field_187136_p.nextFloat() * 0.01f + 0.01f : this.field_187136_p.nextFloat() * 0.02f + 0.02f;
        this.field_70547_e = (physicsType == PhysicsType.NORMAL ? 12 : 2) + this.field_187136_p.nextInt(6);
        this.field_190017_n = physicsType == PhysicsType.NORMAL;
        this.field_70545_g = physicsType == PhysicsType.NORMAL ? 0.68f : 0.0f;
        this.field_190014_F = angle = this.field_187136_p.nextFloat() * 360.0f;
        this.field_190015_G = angle;
        Vector3d deltaMovement = physicsType.function.getDeltaMovement(xd, yd, zd);
        this.field_187129_i = deltaMovement.field_72450_a;
        this.field_187130_j = deltaMovement.field_72448_b;
        this.field_187131_k = deltaMovement.field_72449_c;
        this.physicsType = physicsType;
    }

    public IParticleRenderType func_217558_b() {
        return EpicFightParticleRenderTypes.BLEND_LIGHTMAP_PARTICLE;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.physicsType == PhysicsType.EXPANSIVE) {
            this.field_187129_i *= 0.48;
            this.field_187130_j *= 0.48;
            this.field_187131_k *= 0.48;
        } else if (this.physicsType == PhysicsType.CONTRACTIVE) {
            this.field_187129_i *= 1.35;
            this.field_187130_j *= 1.35;
            this.field_187131_k *= 1.35;
        }
    }

    private static enum PhysicsType {
        EXPANSIVE((dx, dy, dz) -> new Vector3d(dx, dy, dz)),
        CONTRACTIVE((dx, dy, dz) -> new Vector3d(dx * 0.02, dy * 0.02, dz * 0.02)),
        NORMAL((dx, dy, dz) -> new Vector3d(dx, dy, dz));

        DeltaMovementFunction function;

        private PhysicsType(DeltaMovementFunction function) {
            this.function = function;
        }
    }

    @FunctionalInterface
    static interface DeltaMovementFunction {
        public Vector3d getDeltaMovement(double var1, double var3, double var5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NormalDustProvider
    implements IParticleFactory<BasicParticleType> {
        protected IAnimatedSprite sprite;

        public NormalDustProvider(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.NORMAL);
            dustParticle.func_217568_a(this.sprite);
            return dustParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContractiveDustProvider
    implements IParticleFactory<BasicParticleType> {
        protected IAnimatedSprite sprite;

        public ContractiveDustProvider(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.CONTRACTIVE);
            dustParticle.func_217568_a(this.sprite);
            return dustParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ExpansiveDustProvider
    implements IParticleFactory<BasicParticleType> {
        protected IAnimatedSprite sprite;

        public ExpansiveDustProvider(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.EXPANSIVE);
            dustParticle.func_217568_a(this.sprite);
            return dustParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContractiveMetaParticle
    extends MetaParticle {
        private double radius;
        private int density;

        public ContractiveMetaParticle(ClientWorld level, double x, double y, double z, double radius, int lifetime, int density) {
            super(level, x, y, z);
            this.radius = radius;
            this.field_70547_e = lifetime;
            this.density = density;
        }

        public void func_189213_a() {
            super.func_189213_a();
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        for (int i = 0; i < this.density; ++i) {
                            Vector3d rand = new Vector3d(Math.random() * (double)x, Math.random() * (double)y, Math.random() * (double)z).func_72432_b().func_186678_a(this.radius);
                            this.field_187122_b.func_195594_a((IParticleData)EpicFightParticles.DUST_CONTRACTIVE.get(), this.field_187126_f + rand.field_72450_a, this.field_187127_g + rand.field_72448_b, this.field_187128_h + rand.field_72449_c, -rand.field_72450_a, -rand.field_72448_b, -rand.field_72449_c);
                        }
                    }
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class Provider
        implements IParticleFactory<BasicParticleType> {
            public Particle createParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ContractiveMetaParticle particle = new ContractiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed), (int)Double.doubleToLongBits(zSpeed));
                return particle;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ExpansiveMetaParticle
    extends MetaParticle {
        public ExpansiveMetaParticle(ClientWorld level, double x, double y, double z, double radius, int density) {
            super(level, x, y, z);
            for (int vx = -1; vx <= 1; vx += 2) {
                for (int vz = -1; vz <= 1; vz += 2) {
                    for (int i = 0; i < density; ++i) {
                        Vector3d rand = new Vector3d(Math.random() * (double)vx, Math.random(), Math.random() * (double)vz).func_72432_b().func_186678_a(radius);
                        level.func_195594_a((IParticleData)EpicFightParticles.DUST_EXPANSIVE.get(), x, y, z, rand.field_72450_a, rand.field_72448_b, rand.field_72449_c);
                    }
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class Provider
        implements IParticleFactory<BasicParticleType> {
            public Particle createParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ExpansiveMetaParticle particle = new ExpansiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed));
                return particle;
            }
        }
    }
}

