/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class EntityAfterImageParticle
extends CustomModelParticle {
    private OpenMatrix4f[] poseMatrices;
    private Matrix4f modelMatrix;
    private float alphaO;

    public EntityAfterImageParticle(ClientWorld level, double x, double y, double z, double xd, double yd, double zd, ClientModel particleMesh, OpenMatrix4f[] matrices, Matrix4f modelMatrix) {
        super(level, x, y, z, xd, yd, zd, particleMesh);
        this.poseMatrices = matrices;
        this.modelMatrix = modelMatrix;
        this.field_70547_e = 20;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.alphaO = 0.3f;
        this.field_82339_as = 0.3f;
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.alphaO = this.field_82339_as;
        this.field_82339_as = (float)(this.field_70547_e - this.field_70546_d) / (float)this.field_70547_e * 0.8f;
    }

    @Override
    public void func_225606_a_(IVertexBuilder vertexConsumer, ActiveRenderInfo camera, float partialTicks) {
        MatrixStack poseStack = new MatrixStack();
        this.setupMatrixStack(poseStack, camera, partialTicks);
        poseStack.func_227866_c_().func_227870_a_().func_226595_a_(this.modelMatrix);
        float alpha = this.alphaO + (this.field_82339_as - this.alphaO) * partialTicks;
        this.particleMesh.drawAnimatedModelNoTexture(poseStack, vertexConsumer, this.func_189214_a(partialTicks), this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, OverlayTexture.field_229196_a_, this.poseMatrices);
    }

    public IParticleRenderType func_217558_b() {
        return EpicFightParticleRenderTypes.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements IParticleFactory<BasicParticleType> {
        public Particle createParticle(BasicParticleType typeIn, ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LivingEntityPatch entitypatch = (LivingEntityPatch)level.func_73045_a((int)Double.doubleToLongBits(xSpeed)).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (entitypatch != null && ClientEngine.instance.renderEngine.hasRendererFor((Entity)entitypatch.getOriginal())) {
                PatchedEntityRenderer renderer = ClientEngine.instance.renderEngine.getEntityRenderer((Entity)entitypatch.getOriginal());
                Armature armature = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature();
                MatrixStack poseStack = new MatrixStack();
                OpenMatrix4f[] matrices = renderer.getPoseMatrices(entitypatch, armature, 1.0f);
                renderer.mulPoseStack(poseStack, armature, (LivingEntity)entitypatch.getOriginal(), entitypatch, 1.0f);
                EntityAfterImageParticle particle = new EntityAfterImageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT), matrices, poseStack.func_227866_c_().func_227870_a_());
                return particle;
            }
            return null;
        }
    }
}

