/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.particle.TexturedCustomModelParticle;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class ForceFieldParticle
extends TexturedCustomModelParticle {
    private LivingEntityPatch<?> caster;

    public ForceFieldParticle(ClientWorld level, double x, double y, double z, double xd, double yd, double zd, ClientModel particleMesh, ResourceLocation texture) {
        super(level, x, y, z, xd, yd, zd, particleMesh, texture);
        this.field_70547_e = 158;
        this.field_190017_n = false;
        this.field_190014_F = (float)xd;
        this.pitch = (float)zd;
        Entity entity = level.func_73045_a((int)Double.doubleToLongBits(yd));
        if (entity != null) {
            this.caster = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        }
    }

    public IParticleRenderType func_217558_b() {
        return EpicFightParticleRenderTypes.PARTICLE_MODELED;
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.yaw += 36.0f;
        this.scale += (float)Math.max(30 - this.field_70546_d, 0) / 140.0f;
        if (this.caster != null && this.caster.getStunShield() <= 0.0f) {
            this.func_187112_i();
        }
        for (int x = -1; x <= 1; x += 2) {
            for (int z = -1; z <= 1; z += 2) {
                Vector3d rand = new Vector3d(Math.random() * (double)x, Math.random(), Math.random() * (double)z).func_72432_b().func_186678_a(10.0);
                this.field_187122_b.func_195594_a((IParticleData)EpicFightParticles.DUST_CONTRACTIVE.get(), this.field_187126_f + rand.field_72450_a, this.field_187127_g + rand.field_72448_b - 1.0, this.field_187128_h + rand.field_72449_c, -rand.field_72450_a, -rand.field_72448_b, -rand.field_72449_c);
            }
        }
    }

    @Override
    protected void setupMatrixStack(MatrixStack poseStack, ActiveRenderInfo camera, float partialTicks) {
        float yaw = MathHelper.func_219799_g((float)partialTicks, (float)this.yawO, (float)this.yaw);
        Vector3d vec3 = camera.func_216785_c();
        float x = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3.func_82615_a());
        float y = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3.func_82617_b());
        float z = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3.func_82616_c());
        float scale = (float)MathHelper.func_219803_d((double)partialTicks, (double)this.scaleO, (double)this.scale);
        poseStack.func_227861_a_((double)x, (double)y, (double)z);
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.pitch));
        poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.field_190014_F));
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
        poseStack.func_227862_a_(scale, scale, scale);
    }

    public int func_189214_a(float p_107086_) {
        int i = super.func_189214_a(p_107086_);
        int k = i >> 16 & 0xFF;
        return 0xF0 | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements IParticleFactory<BasicParticleType> {
        public Particle createParticle(BasicParticleType typeIn, ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ForceFieldParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, ClientModels.LOGICAL_CLIENT.forceField, EnderDragonRenderer.field_110843_g);
        }
    }
}

