/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EpicFightRenderTypes
extends RenderType {
    private static final Function<ResourceLocation, RenderType> ANIMATED_MODEL = textureLocation -> {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:animated_model", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    };
    private static final Function<ResourceLocation, RenderType> ANIMATED_ITEM_ENTITY_TRANSLUCENT_CULL = textureLocation -> {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228726_a_(field_228515_g_).func_228721_a_(field_241712_U_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228727_a_(field_228495_E_).func_228728_a_(true);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:animated_item_entity_translucent_cull", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)true, (RenderType.State)state);
    };
    private static final Function<ResourceLocation, RenderType> ANIMATED_ARMOR_CUTOUT_NO_CULL = p_173206_ -> {
        RenderType.State rendertype$compositestate = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_173206_, false, false)).func_228726_a_(field_228510_b_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228716_a_(field_228532_x_).func_228722_a_(field_228530_v_).func_228718_a_(field_239235_M_).func_228713_a_(field_228517_i_).func_228728_a_(true);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:armor_cutout_no_cull", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$compositestate);
    };
    private static final Function<ResourceLocation, RenderType> ANIMATED_ARMOR_TRANSLUCENT_CUTOUT_NO_CULL = p_173206_ -> {
        RenderType.State rendertype$compositestate = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_173206_, false, false)).func_228726_a_(field_228515_g_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228718_a_(field_239235_M_).func_228728_a_(true);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:armor_cutout_no_cull", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)true, (RenderType.State)rendertype$compositestate);
    };
    private static final RenderType ANIMATED_ARMOR_GLINT = EpicFightRenderTypes.func_228633_a_((String)"epicfight:animated_armor_glint", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ItemRenderer.field_110798_h, true, false)).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228493_C_).func_228726_a_(field_228513_e_).func_228725_a_(field_228527_s_).func_228718_a_(field_239235_M_).func_228728_a_(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_INDICATOR = textureLocation -> {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228726_a_(field_228510_b_).func_228719_a_(field_228529_u_).func_228722_a_(field_228531_w_).func_228728_a_(true);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:entity_indicator", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    };
    private static final Function<ResourceLocation, RenderType> ENTITY_DECAL_GL_TRIANGLES = p_173194_ -> {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_173194_, false, false)).func_228715_a_(field_228493_C_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(false);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:entity_decal_triangles", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)state);
    };
    private static final Function<ResourceLocation, RenderType> DRAGON_EXPLOSION_ALPHA_GL_TRIANGLES = textureLocation -> {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228714_a_(field_228491_A_).func_228728_a_(true);
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:dragon_explosion_triangles", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)state);
    };
    private static final RenderType DEBUG_COLLIDER = EpicFightRenderTypes.func_228633_a_((String)"epicfight:debug_collider", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)3, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.empty())).func_228718_a_(field_239235_M_).func_228726_a_(field_228510_b_).func_228727_a_(field_228495_E_).func_228714_a_(field_228491_A_).func_228728_a_(false));
    private static final RenderType DEBUG_QUADS = EpicFightRenderTypes.func_228633_a_((String)"epicfight:debug_quad", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228718_a_(field_239235_M_).func_228726_a_(field_228510_b_).func_228727_a_(field_228495_E_).func_228714_a_(field_228491_A_).func_228728_a_(false));

    private EpicFightRenderTypes(String p_173178_, VertexFormat p_173179_, int drawingMode, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
        super(p_173178_, p_173179_, drawingMode, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
    }

    public static RenderType animatedModel(ResourceLocation locationIn) {
        return ANIMATED_MODEL.apply(locationIn);
    }

    public static RenderType itemEntityTranslucentCull(ResourceLocation locationIn) {
        return ANIMATED_ITEM_ENTITY_TRANSLUCENT_CULL.apply(locationIn);
    }

    public static RenderType animatedArmor(ResourceLocation locationIn, boolean transparent) {
        return transparent ? ANIMATED_ARMOR_TRANSLUCENT_CUTOUT_NO_CULL.apply(locationIn) : ANIMATED_ARMOR_CUTOUT_NO_CULL.apply(locationIn);
    }

    public static RenderType enchantedAnimatedArmor() {
        return ANIMATED_ARMOR_GLINT;
    }

    public static RenderType entityIndicator(ResourceLocation locationIn) {
        return ENTITY_INDICATOR.apply(locationIn);
    }

    public static RenderType dragonExplosionAlphaTriangles(ResourceLocation locationIn) {
        return DRAGON_EXPLOSION_ALPHA_GL_TRIANGLES.apply(locationIn);
    }

    public static RenderType entityDecalTriangles(ResourceLocation locationIn) {
        return ENTITY_DECAL_GL_TRIANGLES.apply(locationIn);
    }

    public static RenderType debugQuads() {
        return DEBUG_QUADS;
    }

    public static RenderType debugCollider() {
        return DEBUG_COLLIDER;
    }

    public static RenderType energySwirlTrianlges(ResourceLocation texture, float u, float v) {
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:energy_swirl_trianlges", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228725_a_((RenderState.TexturingState)new RenderState.OffsetTexturingState(u, v)).func_228726_a_(field_228511_c_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(false));
    }

    public static RenderType entityTranslucentTriangles(ResourceLocation texture) {
        return EpicFightRenderTypes.func_228633_a_((String)"epicfight:entity_transparent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(field_228515_g_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228727_a_(field_228495_E_).func_228728_a_(false));
    }

    public static IVertexBuilder getArmorVertexBuilder(IRenderTypeBuffer buffer, RenderType renderType, boolean withGlint) {
        return withGlint ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)buffer.getBuffer(EpicFightRenderTypes.enchantedAnimatedArmor()), (IVertexBuilder)buffer.getBuffer(renderType)) : buffer.getBuffer(renderType);
    }
}

