/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightningRenderHelper {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    private static void vertex01(IVertexBuilder vertexConsumer, Matrix4f matrix4f, int alpha) {
        vertexConsumer.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_181675_d();
    }

    private static void vertex2(IVertexBuilder vertexConsumer, Matrix4f matrix4f, float height, float width, int rCol, int gCol, int bCol) {
        vertexConsumer.func_227888_a_(matrix4f, -HALF_SQRT_3 * width, height, -0.5f * width).func_225586_a_(rCol, gCol, bCol, 0).func_181675_d();
    }

    private static void vertex3(IVertexBuilder vertexConsumer, Matrix4f matrix4f, float height, float width, int rCol, int gCol, int bCol) {
        vertexConsumer.func_227888_a_(matrix4f, HALF_SQRT_3 * width, height, -0.5f * width).func_225586_a_(rCol, gCol, bCol, 0).func_181675_d();
    }

    private static void vertex4(IVertexBuilder vertexConsumer, Matrix4f matrix4f, float width, float height, int rCol, int gCol, int bCol) {
        vertexConsumer.func_227888_a_(matrix4f, 0.0f, width, 1.0f * height).func_225586_a_(rCol, gCol, bCol, 0).func_181675_d();
    }

    public static void renderCyclingLight(IVertexBuilder vertexConsumer, MatrixStack poseStack, int rCol, int gCol, int bCol, int density, float size, float progression, float repeater) {
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        Random random = new Random(123L);
        int i = 0;
        while ((float)i < (float)density) {
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + progression * 90.0f));
            float height = (random.nextFloat() * 20.0f + 5.0f + repeater * 10.0f) * size;
            float width = (random.nextFloat() * 2.0f + 1.0f + repeater * 2.0f) * size;
            float randomf = random.nextFloat();
            float alpha = ((float)Math.sin((double)(randomf + progression) * Math.PI) + 1.0f) * 0.5f;
            int j = (int)(255.0f * alpha);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, j);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, j);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, j);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            ++i;
        }
    }

    public static void renderFlashingLight(IVertexBuilder vertexConsumer, MatrixStack poseStack, int rCol, int gCol, int bCol, int density, float size, float progression) {
        double d1 = (double)(progression * 3.0f) * Math.PI / 2.0;
        float sinDelta = Math.max((float)(d1 < 1.5707963267948966 ? Math.sin(d1) : Math.sin((d1 + 1.5707963267948966) / 2.0)), 0.0f);
        float linearDelta = progression < 0.3f ? progression + 0.7f : 1.0f;
        Random random = new Random(432L);
        for (int i = 0; i < density; ++i) {
            poseStack.func_227860_a_();
            Vector3f randomAxis = new Vector3f(-0.5f + random.nextFloat(), 0.0f, -0.5f + random.nextFloat());
            randomAxis.func_229194_d_();
            float randomDegree = -120.0f + random.nextFloat() * 240.0f;
            Quaternion randomRotation = new Quaternion(randomAxis, randomDegree, true);
            poseStack.func_227863_a_(randomRotation);
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            float height = 14.0f * linearDelta * size;
            float width = (0.3f + random.nextFloat()) * size;
            Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
            int alpha = (int)(255.0f * sinDelta);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, alpha);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, alpha);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, alpha);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            poseStack.func_227865_b_();
        }
    }
}

