/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.client.model.CustomModelBakery;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class WearableItemLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends BipedModel<E>>
extends PatchedLayer<E, T, M, BipedArmorLayer<E, M, M>> {
    private static final Map<ResourceLocation, ClientModel> ARMOR_MODELS = new HashMap<ResourceLocation, ClientModel>();
    private static final Map<String, ResourceLocation> EPICFIGHT_OVERRIDING_TEXTURES = Maps.newHashMap();
    final boolean doNotRenderHelment;

    public static void clear() {
        ARMOR_MODELS.clear();
        EPICFIGHT_OVERRIDING_TEXTURES.clear();
    }

    public WearableItemLayer() {
        this(false);
    }

    public WearableItemLayer(boolean doNotRenderHelment) {
        this.doNotRenderHelment = doNotRenderHelment;
    }

    private void renderArmor(MatrixStack matStack, IRenderTypeBuffer multiBufferSource, int packedLightIn, boolean hasEffect, ClientModel model, float r, float g, float b, ResourceLocation armorTexture, OpenMatrix4f[] poses) {
        IVertexBuilder vertexConsumer = EpicFightRenderTypes.getArmorVertexBuilder(multiBufferSource, EpicFightRenderTypes.animatedArmor(armorTexture, model.getProperties().isTransparent()), hasEffect);
        model.drawAnimatedModel(matStack, vertexConsumer, packedLightIn, r, g, b, 1.0f, OverlayTexture.field_229196_a_, poses);
    }

    @Override
    public void renderLayer(T entitypatch, E entityliving, BipedArmorLayer<E, M, M> originalRenderer, MatrixStack poseStack, IRenderTypeBuffer buf, int packedLightIn, OpenMatrix4f[] poses, float netYawHead, float pitchHead, float partialTicks) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack;
            Item item;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || slot == EquipmentSlotType.HEAD && this.doNotRenderHelment || !((item = (stack = entityliving.func_184582_a(slot)).func_77973_b()) instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)stack.func_77973_b();
            if (slot != armorItem.func_185083_B_()) {
                return;
            }
            poseStack.func_227860_a_();
            float head = 0.0f;
            if (((BipedModel)originalRenderer.func_215332_c()).func_205072_a() != null && ((BipedModel)originalRenderer.func_215332_c()).func_205072_a().field_78804_l.size() > 0) {
                ModelRenderer.ModelBox headCube = (ModelRenderer.ModelBox)((BipedModel)originalRenderer.func_215332_c()).func_205072_a().field_78804_l.get(0);
                head = headCube.field_78248_d - headCube.field_78250_b - 12.0f;
            }
            if (slot == EquipmentSlotType.HEAD) {
                poseStack.func_227861_a_(0.0, (double)head * 0.055, 0.0);
            }
            ClientModel model = this.getArmorModel(originalRenderer, entityliving, armorItem, stack, slot);
            boolean hasEffect = stack.func_77962_s();
            if (armorItem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armorItem).func_200886_f(stack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, model, r, g, b, this.getArmorTexture(stack, (Entity)entityliving, slot, null), poses);
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, model, 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, slot, "overlay"), poses);
            } else {
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, model, 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, slot, null), poses);
            }
            poseStack.func_227865_b_();
        }
    }

    private ClientModel getArmorModel(BipedArmorLayer<E, M, M> originalRenderer, E entityliving, ArmorItem armorItem, ItemStack stack, EquipmentSlotType slot) {
        ResourceLocation rl;
        ClientModel model;
        ResourceLocation registryName = armorItem.getRegistryName();
        boolean debuggingMode = ClientEngine.instance.isArmorModelDebuggingMode();
        if (ARMOR_MODELS.containsKey(registryName) && !debuggingMode) {
            return ARMOR_MODELS.get(registryName);
        }
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager.func_219533_b((model = new ClientModel(rl = new ResourceLocation(armorItem.getRegistryName().func_110624_b(), "armor/" + armorItem.getRegistryName().func_110623_a()))).getLocation())) {
            model.loadMeshAndProperties(resourceManager);
        } else {
            BipedModel defaultModel = originalRenderer.func_241736_a_(slot);
            BipedModel customModel = ForgeHooksClient.getArmorModel(entityliving, (ItemStack)stack, (EquipmentSlotType)slot, (BipedModel)defaultModel);
            model = customModel == defaultModel || !(customModel instanceof BipedModel) ? WearableItemLayer.getDefaultArmorModel(slot) : CustomModelBakery.bakeBipedCustomArmorModel(customModel, armorItem, slot, debuggingMode);
        }
        ARMOR_MODELS.put(registryName, model);
        return model;
    }

    private ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        ResourceLocation resourcelocation;
        int idx2;
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        String s2 = String.format("%s/epicfight/%s", (s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type)).substring(0, idx2 = s1.lastIndexOf(47)), s1.substring(idx2 + 1));
        ResourceLocation resourcelocation2 = EPICFIGHT_OVERRIDING_TEXTURES.get(s2);
        if (resourcelocation2 != null) {
            return resourcelocation2;
        }
        if (!EPICFIGHT_OVERRIDING_TEXTURES.containsKey(s2)) {
            resourcelocation2 = new ResourceLocation(s2);
            IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
            if (rm.func_219533_b(resourcelocation2)) {
                EPICFIGHT_OVERRIDING_TEXTURES.put(s2, resourcelocation2);
                return resourcelocation2;
            }
            EPICFIGHT_OVERRIDING_TEXTURES.put(s2, null);
        }
        if ((resourcelocation = (ResourceLocation)BipedArmorLayer.field_177191_j.get(s1)) == null) {
            resourcelocation = new ResourceLocation(s1);
            BipedArmorLayer.field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public static ClientModel getDefaultArmorModel(EquipmentSlotType slot) {
        ClientModels modelDB = ClientModels.LOGICAL_CLIENT;
        switch (slot) {
            case HEAD: {
                return modelDB.helmet;
            }
            case CHEST: {
                return modelDB.chestplate;
            }
            case LEGS: {
                return modelDB.leggins;
            }
            case FEET: {
                return modelDB.boots;
            }
        }
        return null;
    }
}

