/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;

@OnlyIn(value=Dist.CLIENT)
public class AbstractClientPlayerPatch<T extends AbstractClientPlayerEntity>
extends PlayerPatch<T> {
    protected float prevYaw;
    protected float bodyYaw;
    protected float prevBodyYaw;
    private Item prevHeldItem;
    private Item prevHeldItemOffHand;

    @Override
    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        this.prevHeldItem = Items.field_190931_a;
        this.prevHeldItemOffHand = Items.field_190931_a;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((AbstractClientPlayerEntity)this.original).func_110143_aJ() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.movementLocked() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        } else {
            ClientAnimator animator = this.getClientAnimator();
            if (((AbstractClientPlayerEntity)this.original).func_184613_cA() || ((AbstractClientPlayerEntity)this.original).func_204805_cN()) {
                this.currentLivingMotion = LivingMotions.FLY;
            } else if (((AbstractClientPlayerEntity)this.original).func_184187_bx() != null) {
                this.currentLivingMotion = LivingMotions.MOUNT;
            } else if (((AbstractClientPlayerEntity)this.original).func_213314_bj()) {
                this.currentLivingMotion = LivingMotions.SWIM;
            } else if (((AbstractClientPlayerEntity)this.original).func_70608_bn()) {
                this.currentLivingMotion = LivingMotions.SLEEP;
            } else if (!((AbstractClientPlayerEntity)this.original).func_233570_aj_() && ((AbstractClientPlayerEntity)this.original).func_70617_f_()) {
                this.currentLivingMotion = LivingMotions.CLIMB;
                double y = ((AbstractClientPlayerEntity)this.original).field_71095_bQ - ((AbstractClientPlayerEntity)this.original).field_71096_bN;
                if (Math.abs(y) < 0.04) {
                    animator.baseLayer.pause();
                } else {
                    animator.baseLayer.resume();
                    if (y < 0.0) {
                        animator.baseLayer.animationPlayer.setReversed(true);
                    } else {
                        animator.baseLayer.animationPlayer.setReversed(false);
                    }
                }
            } else if (((AbstractClientPlayerEntity)this.original).func_204231_K() && ((AbstractClientPlayerEntity)this.original).field_71095_bQ - ((AbstractClientPlayerEntity)this.original).field_71096_bN < -0.005) {
                this.currentLivingMotion = LivingMotions.FLOAT;
            } else if (((AbstractClientPlayerEntity)this.original).field_71095_bQ - ((AbstractClientPlayerEntity)this.original).field_71096_bN < -0.25) {
                this.currentLivingMotion = LivingMotions.FALL;
            } else if (((AbstractClientPlayerEntity)this.original).field_70721_aZ > 0.01f) {
                this.currentLivingMotion = ((AbstractClientPlayerEntity)this.original).func_225608_bj_() ? LivingMotions.SNEAK : (((AbstractClientPlayerEntity)this.original).func_70051_ag() ? LivingMotions.RUN : LivingMotions.WALK);
                if (((AbstractClientPlayerEntity)this.original).field_191988_bg < 0.0f) {
                    animator.baseLayer.animationPlayer.setReversed(true);
                } else {
                    animator.baseLayer.animationPlayer.setReversed(false);
                }
            } else {
                animator.baseLayer.animationPlayer.setReversed(false);
                this.currentLivingMotion = ((AbstractClientPlayerEntity)this.original).func_225608_bj_() ? LivingMotions.KNEEL : LivingMotions.IDLE;
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new UpdatePlayerMotionEvent.BaseLayer(this, this.currentLivingMotion));
        CapabilityItem activeItem = this.getHoldingItemCapability(((AbstractClientPlayerEntity)this.original).func_184600_cs());
        if (((AbstractClientPlayerEntity)this.original).func_184587_cr()) {
            UseAction useAnim = ((AbstractClientPlayerEntity)this.original).func_184586_b(((AbstractClientPlayerEntity)this.original).func_184600_cs()).func_77975_n();
            UseAction secondUseAction = activeItem.getUseAnimation(this);
            this.currentCompositeMotion = useAnim == UseAction.BLOCK || secondUseAction == UseAction.BLOCK ? (activeItem.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAction.BOW || useAnim == UseAction.SPEAR ? LivingMotions.AIM : (useAnim == UseAction.CROSSBOW ? LivingMotions.RELOAD : this.currentLivingMotion));
        } else {
            this.currentCompositeMotion = ((AbstractClientPlayerEntity)this.original).func_184614_ca().func_77973_b() instanceof ShootableItem && CrossbowItem.func_220012_d((ItemStack)((AbstractClientPlayerEntity)this.original).func_184614_ca()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation() ? LivingMotions.NONE : (((AbstractClientPlayerEntity)this.original).field_82175_bq && !((AbstractClientPlayerEntity)this.original).func_213374_dv().isPresent() ? LivingMotions.DIGGING : this.currentLivingMotion));
            if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM && activeItem instanceof RangedWeaponCapability) {
                this.playReboundAnimation();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new UpdatePlayerMotionEvent.CompositeLayer(this, this.currentCompositeMotion));
    }

    @Override
    protected void clientTick(LivingEvent.LivingUpdateEvent event) {
        boolean isOffHandChanged;
        this.prevYaw = this.yaw;
        this.prevBodyYaw = this.bodyYaw;
        if (this.getEntityState().inaction()) {
            ((AbstractClientPlayerEntity)this.original).field_70761_aq = ((AbstractClientPlayerEntity)this.original).field_70177_z;
        }
        this.bodyYaw = ((AbstractClientPlayerEntity)this.original).field_70761_aq;
        boolean isMainHandChanged = this.prevHeldItem != ((AbstractClientPlayerEntity)this.original).field_71071_by.func_70448_g().func_77973_b();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand != ((ItemStack)((AbstractClientPlayerEntity)this.original).field_71071_by.field_184439_c.get(0)).func_77973_b();
        if (isMainHandChanged || isOffHandChanged) {
            this.updateHeldItem(this.getHoldingItemCapability(Hand.MAIN_HAND), this.getHoldingItemCapability(Hand.OFF_HAND));
            if (isMainHandChanged) {
                this.prevHeldItem = ((AbstractClientPlayerEntity)this.original).field_71071_by.func_70448_g().func_77973_b();
            }
            if (isOffHandChanged) {
                this.prevHeldItemOffHand = ((ItemStack)((AbstractClientPlayerEntity)this.original).field_71071_by.field_184439_c.get(0)).func_77973_b();
            }
        }
        super.clientTick(event);
        if (((AbstractClientPlayerEntity)this.original).field_70725_aQ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
    }

    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.cancelUsingItem();
    }

    @Override
    public void reserveAnimation(StaticAnimation animation) {
        this.animator.reserveAnimation(animation);
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)(((AbstractClientPlayerEntity)this.original).func_175154_l().equals("slim") ? modelDB.bipedAlex : modelDB.biped);
    }

    @Override
    public boolean shouldSkipRender() {
        return !this.isBattleMode() && EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue() != false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenMatrix4f getHeadMatrix(float partialTick) {
        float yaw = 0.0f;
        float pitch = 0.0f;
        float prvePitch = 0.0f;
        if (this.getEntityState().inaction() || ((AbstractClientPlayerEntity)this.original).func_184187_bx() != null || !((AbstractClientPlayerEntity)this.original).func_233570_aj_() && ((AbstractClientPlayerEntity)this.original).func_70617_f_()) {
            yaw = 0.0f;
        } else {
            float f = MathUtils.lerpBetween(this.prevBodyYaw, this.bodyYaw, partialTick);
            float f1 = MathUtils.lerpBetween(((AbstractClientPlayerEntity)this.original).field_70758_at, ((AbstractClientPlayerEntity)this.original).field_70759_as, partialTick);
            yaw = f1 - f;
        }
        if (!((AbstractClientPlayerEntity)this.original).func_184613_cA() && !((AbstractClientPlayerEntity)this.original).func_213314_bj()) {
            prvePitch = ((AbstractClientPlayerEntity)this.original).field_70127_C;
            pitch = ((AbstractClientPlayerEntity)this.original).field_70125_A;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prvePitch, pitch, yaw, yaw, partialTick, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTick) {
        float rotyaw;
        float prevRotYaw;
        if (((AbstractClientPlayerEntity)this.original).func_204805_cN()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 1.0f, 1.0f, 1.0f);
            float yawDegree = MathUtils.lerpBetween(((AbstractClientPlayerEntity)this.original).field_70126_B, ((AbstractClientPlayerEntity)this.original).field_70177_z, partialTick);
            float pitchDegree = MathUtils.lerpBetween(((AbstractClientPlayerEntity)this.original).field_70127_C, ((AbstractClientPlayerEntity)this.original).field_70125_A, partialTick);
            mat.rotateDeg(-yawDegree, Vec3f.Y_AXIS).rotateDeg(-pitchDegree, Vec3f.X_AXIS).rotateDeg(((float)((AbstractClientPlayerEntity)this.original).field_70173_aa + partialTick) * -55.0f, Vec3f.Z_AXIS).translate(0.0f, -0.39f, 0.0f);
            return mat;
        }
        if (((AbstractClientPlayerEntity)this.original).func_184613_cA()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 1.0f, 1.0f, 1.0f);
            float f1 = (float)((AbstractClientPlayerEntity)this.getOriginal()).func_184599_cB() + partialTick;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            mat.rotateDeg(-MathHelper.func_219805_h((float)partialTick, (float)((AbstractClientPlayerEntity)this.original).field_70760_ar, (float)((AbstractClientPlayerEntity)this.original).field_70761_aq), Vec3f.Y_AXIS);
            if (!((AbstractClientPlayerEntity)this.getOriginal()).func_204805_cN()) {
                mat.rotateDeg(f2 * -((AbstractClientPlayerEntity)this.original).field_70125_A, Vec3f.X_AXIS);
            }
            Vector3d vector3d = ((AbstractClientPlayerEntity)this.original).func_70676_i(partialTick);
            Vector3d vector3d1 = ((AbstractClientPlayerEntity)this.original).func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                mat.rotate((float)(-(Math.signum(d3) * Math.acos(d2))), Vec3f.Z_AXIS);
            }
            return mat;
        }
        if (((AbstractClientPlayerEntity)this.original).func_70608_bn()) {
            BlockState blockstate = ((AbstractClientPlayerEntity)this.original).func_213339_cH();
            float yaw = 0.0f;
            if (blockstate.isBed((IBlockReader)((AbstractClientPlayerEntity)this.original).field_70170_p, (BlockPos)((AbstractClientPlayerEntity)this.original).func_213374_dv().orElse(null), (LivingEntity)this.original) && blockstate.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                switch ((Direction)blockstate.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                    case EAST: {
                        yaw = 90.0f;
                        break;
                    }
                    case WEST: {
                        yaw = -90.0f;
                        break;
                    }
                    case SOUTH: {
                        yaw = 180.0f;
                        break;
                    }
                }
            }
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yaw, yaw, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        Direction direction = this.getLadderDirection(((AbstractClientPlayerEntity)this.original).func_213339_cH(), ((AbstractClientPlayerEntity)this.original).field_70170_p, ((AbstractClientPlayerEntity)this.original).func_233580_cy_(), (LivingEntity)this.original);
        if (direction != Direction.UP) {
            float yaw = 0.0f;
            switch (direction) {
                case EAST: {
                    yaw = 90.0f;
                    break;
                }
                case WEST: {
                    yaw = -90.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 180.0f;
                    break;
                }
            }
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yaw, yaw, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        float prevPitch = 0.0f;
        float pitch = 0.0f;
        if (((AbstractClientPlayerEntity)this.original).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((AbstractClientPlayerEntity)this.original).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            float yaw = MathUtils.lerpBetween(this.prevYaw, this.yaw, partialTick);
            prevRotYaw = this.prevBodyYaw + yaw;
            rotyaw = this.bodyYaw + yaw;
        }
        if (!this.getEntityState().inaction() && ((AbstractClientPlayerEntity)this.original).func_213283_Z() == Pose.SWIMMING) {
            float f4;
            float f = ((AbstractClientPlayerEntity)this.original).func_205015_b(partialTick);
            float f3 = ((AbstractClientPlayerEntity)this.original).func_70090_H() ? ((AbstractClientPlayerEntity)this.original).field_70125_A : 0.0f;
            prevPitch = f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            pitch = f4;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevPitch, pitch, prevRotYaw, rotyaw, partialTick, 1.0f, 1.0f, 1.0f);
    }

    public Direction getLadderDirection(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175149_v();
        if (isSpectator || ((AbstractClientPlayerEntity)this.original).func_233570_aj_() || !((AbstractClientPlayerEntity)this.original).func_70089_S()) {
            return Direction.UP;
        }
        if (((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            if (state.isLadder((IWorldReader)world, pos, entity)) {
                if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208149_B) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B)).booleanValue()) {
                    return Direction.UP;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208151_D) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D)).booleanValue()) {
                    return Direction.SOUTH;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208154_G) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G)).booleanValue()) {
                    return Direction.EAST;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208153_F) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F)).booleanValue()) {
                    return Direction.NORTH;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208152_E) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E)).booleanValue()) {
                    return Direction.WEST;
                }
            }
        } else {
            AxisAlignedBB bb = entity.func_174813_aQ();
            int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
            int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
            int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
            int y2 = mY;
            while ((double)y2 < bb.field_72337_e) {
                int x2 = mX;
                while ((double)x2 < bb.field_72336_d) {
                    int z2 = mZ;
                    while ((double)z2 < bb.field_72334_f) {
                        BlockPos tmp = new BlockPos(x2, y2, z2);
                        state = world.func_180495_p(tmp);
                        if (state.isLadder((IWorldReader)world, tmp, entity)) {
                            if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                                return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                            }
                            if (state.func_235901_b_((Property)BlockStateProperties.field_208149_B) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B)).booleanValue()) {
                                return Direction.UP;
                            }
                            if (state.func_235901_b_((Property)BlockStateProperties.field_208151_D) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D)).booleanValue()) {
                                return Direction.SOUTH;
                            }
                            if (state.func_235901_b_((Property)BlockStateProperties.field_208154_G) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G)).booleanValue()) {
                                return Direction.EAST;
                            }
                            if (state.func_235901_b_((Property)BlockStateProperties.field_208153_F) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F)).booleanValue()) {
                                return Direction.NORTH;
                            }
                            if (state.func_235901_b_((Property)BlockStateProperties.field_208152_E) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E)).booleanValue()) {
                                return Direction.WEST;
                            }
                        }
                        ++z2;
                    }
                    ++x2;
                }
                ++y2;
            }
        }
        return Direction.UP;
    }
}

