/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPPlayAnimation;
import yesman.epicfight.network.server.SPPotion;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.ProjectileHitEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@Mod.EventBusSubscriber(modid="epicfight")
public class EntityEvents {
    @SubscribeEvent
    public static void spawnEvent(EntityJoinWorldEvent event) {
        EntityPatch entitypatch = (EntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null && !entitypatch.isInitialized()) {
            entitypatch.onJoinWorld(event.getEntity(), event);
        }
        if (event.getEntity() instanceof ProjectileEntity) {
            ProjectileEntity projectileentity = (ProjectileEntity)event.getEntity();
            ProjectilePatch projectilePatch = (ProjectilePatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE, null).orElse(null);
            if (projectilePatch != null) {
                projectilePatch.onJoinWorld(projectileentity, event);
            }
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            entitypatch.tick(event);
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        EntityPatch cap = (EntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (cap != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        ExtendedDamageSource extendedDamageSource = null;
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource != null) {
            ProjectilePatch projectileCap;
            if (event.getSource() instanceof ExtendedDamageSource) {
                extendedDamageSource = (ExtendedDamageSource)event.getSource();
            } else if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76364_f() != null && (projectileCap = (ProjectilePatch)event.getSource().func_76364_f().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE, null).orElse(null)) != null) {
                extendedDamageSource = projectileCap.getEpicFightDamageSource(event.getSource());
            }
            if (extendedDamageSource != null) {
                LivingEntityPatch hitentitypatch;
                int k;
                int i;
                int j;
                float f;
                float f1;
                float f2;
                float ignoreDamage;
                LivingEntity hitEntity = event.getEntityLiving();
                float totalDamage = event.getAmount();
                if (hitEntity instanceof ServerPlayerEntity) {
                    ServerPlayerPatch playerpatch = (ServerPlayerPatch)hitEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
                    HurtEvent.Post hurtEvent = new HurtEvent.Post(playerpatch, extendedDamageSource, totalDamage);
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_POST, hurtEvent);
                    totalDamage = hurtEvent.getAmount();
                }
                float calculatedDamage = ignoreDamage = totalDamage * extendedDamageSource.getArmorNegation() * 0.01f;
                if (hitEntity.func_70644_a(Effects.field_76429_m) && (f2 = (f1 = calculatedDamage) - (calculatedDamage = Math.max((f = calculatedDamage * (float)(j = 25 - (i = (hitEntity.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
                    if (hitEntity instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)hitEntity).func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
                    } else if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)event.getSource().func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
                    }
                }
                if (calculatedDamage > 0.0f && (k = EnchantmentHelper.func_77508_a((Iterable)hitEntity.func_184193_aE(), (DamageSource)event.getSource())) > 0) {
                    calculatedDamage = CombatRules.func_188401_b((float)calculatedDamage, (float)k);
                }
                float absorpAmount = hitEntity.func_110139_bj() - calculatedDamage;
                hitEntity.func_110149_m(Math.max(absorpAmount, 0.0f));
                float realHealthDamage = Math.max(-absorpAmount, 0.0f);
                if (realHealthDamage > 0.0f && realHealthDamage < 3.4028235E37f && event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)event.getSource().func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(realHealthDamage * 10.0f));
                }
                if (absorpAmount < 0.0f) {
                    hitEntity.func_70606_j(hitEntity.func_110143_aJ() + absorpAmount);
                    LivingEntityPatch attacker = (LivingEntityPatch)trueSource.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (attacker != null) {
                        attacker.gatherDamageDealt(extendedDamageSource, calculatedDamage);
                    }
                }
                event.setAmount(totalDamage - ignoreDamage);
                if (event.getAmount() + ignoreDamage > 0.0f && (hitentitypatch = (LivingEntityPatch)hitEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                    StaticAnimation hitAnimation = null;
                    float extendStunTime = 0.0f;
                    float knockBackAmount = 0.0f;
                    float weightReduction = 40.0f / hitentitypatch.getWeight();
                    float stunShield = hitentitypatch.getStunShield();
                    if (stunShield > 0.0f) {
                        hitentitypatch.setStunShield(stunShield - extendedDamageSource.getImpact());
                    }
                    switch (extendedDamageSource.getStunType()) {
                        case SHORT: {
                            if (hitEntity.func_70644_a((Effect)EpicFightMobEffects.STUN_IMMUNITY.get()) || hitentitypatch.getStunShield() != 0.0f) break;
                            float totalStunTime = (0.25f + extendedDamageSource.getImpact() * 0.1f) * weightReduction;
                            if (!((totalStunTime *= 1.0f - hitentitypatch.getStunTimeTimeReduction()) >= 0.1f)) break;
                            extendStunTime = totalStunTime - 0.1f;
                            boolean flag = totalStunTime >= 0.83f;
                            ExtendedDamageSource.StunType stunType = flag ? ExtendedDamageSource.StunType.LONG : ExtendedDamageSource.StunType.SHORT;
                            extendStunTime = flag ? 0.0f : extendStunTime;
                            hitAnimation = hitentitypatch.getHitAnimation(stunType);
                            knockBackAmount = Math.min(flag ? extendedDamageSource.getImpact() * 0.05f : totalStunTime, 2.0f);
                            break;
                        }
                        case LONG: {
                            hitAnimation = hitEntity.func_70644_a((Effect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? null : hitentitypatch.getHitAnimation(ExtendedDamageSource.StunType.LONG);
                            knockBackAmount = Math.min(extendedDamageSource.getImpact() * 0.25f * weightReduction, 5.0f);
                            break;
                        }
                        case HOLD: {
                            hitAnimation = hitentitypatch.getHitAnimation(ExtendedDamageSource.StunType.SHORT);
                            extendStunTime = extendedDamageSource.getImpact() * 0.1f;
                            break;
                        }
                        case KNOCKDOWN: {
                            hitAnimation = hitEntity.func_70644_a((Effect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? null : hitentitypatch.getHitAnimation(ExtendedDamageSource.StunType.KNOCKDOWN);
                            knockBackAmount = Math.min(extendedDamageSource.getImpact() * 0.05f, 5.0f);
                            break;
                        }
                        case FALL: {
                            break;
                        }
                    }
                    Vector3d sourcePosition = ((DamageSource)extendedDamageSource).func_188404_v();
                    if (sourcePosition != null) {
                        if (hitAnimation != null) {
                            if (!(hitEntity instanceof PlayerEntity)) {
                                hitEntity.func_200602_a(EntityAnchorArgument.Type.FEET, sourcePosition);
                            }
                            hitentitypatch.setStunReductionOnHit();
                            hitentitypatch.playAnimationSynchronized(hitAnimation, extendStunTime);
                        }
                        if (knockBackAmount != 0.0f) {
                            hitentitypatch.knockBackEntity(((DamageSource)extendedDamageSource).func_188404_v(), knockBackAmount);
                        }
                    }
                }
            }
        }
        if (event.getEntityLiving().func_184587_cr() && event.getEntityLiving().func_184607_cu().func_77973_b() == Items.field_185159_cQ && event.getEntityLiving() instanceof PlayerEntity) {
            event.getEntityLiving().field_70170_p.func_184133_a((PlayerEntity)event.getEntityLiving(), event.getEntityLiving().func_233580_cy_(), SoundEvents.field_187767_eL, event.getEntityLiving().func_184176_by(), 1.0f, 0.8f + event.getEntityLiving().func_70681_au().nextFloat() * 0.4f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        LivingEntityPatch attacker;
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getSource() instanceof ExtendedDamageSource && trueSource != null && (attacker = (LivingEntityPatch)trueSource.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            attacker.gatherDamageDealt((ExtendedDamageSource)event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        if (event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        Object damageSource = null;
        if (entitypatch != null && event.getEntityLiving().func_110143_aJ() > 0.0f) {
            ProjectilePatch projectilepatch;
            if (damageSource == DamageSource.field_76379_h && event.getEntity().field_70170_p.func_82736_K().func_223586_b(EpicFightGamerules.HAS_FALL_ANIMATION)) {
                StaticAnimation fallAnimation;
                float damage;
                if (!entitypatch.getEntityState().inaction() && (damage = event.getAmount()) > 5.0f && (fallAnimation = entitypatch.getHitAnimation(ExtendedDamageSource.StunType.FALL)) != null) {
                    entitypatch.playAnimationSynchronized(fallAnimation, 0.0f);
                }
                return;
            }
            if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76364_f() != null && (projectilepatch = (ProjectilePatch)event.getSource().func_76364_f().getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE).orElse(null)) != null) {
                damageSource = projectilepatch.getEpicFightDamageSource(event.getSource());
            }
            if (damageSource == null) {
                damageSource = event.getSource();
            }
            AttackResult result = entitypatch.tryHurt((DamageSource)damageSource, event.getAmount());
            if (!result.resultType.dealtDamage()) {
                event.setCanceled(true);
            } else if (event.getAmount() != result.damage) {
                event.setCanceled(true);
                DamageSource damagesource = new DamageSource(event.getSource().func_76355_l());
                damagesource.func_76359_i();
                event.getEntity().func_70097_a(damagesource, result.damage);
            }
        }
    }

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (entitypatch != null && entitypatch.onDrop(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void projectileImpactEvent(ProjectileImpactEvent event) {
        EntityRayTraceResult rayresult;
        Entity eProjectile = event.getEntity();
        if (!(eProjectile instanceof ProjectileEntity)) {
            return;
        }
        ProjectileEntity projectile = (ProjectileEntity)eProjectile;
        ProjectilePatch projectilepatch = (ProjectilePatch)projectile.getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE, null).orElse(null);
        if (!projectile.field_70170_p.func_201670_d() && projectilepatch != null && projectilepatch.onProjectileImpact(event)) {
            event.setCanceled(true);
            return;
        }
        if (event.getRayTraceResult() instanceof EntityRayTraceResult && (rayresult = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() != null) {
            ServerPlayerPatch playerpatch;
            boolean canceled;
            if (rayresult.func_216348_a() instanceof ServerPlayerEntity && (canceled = (playerpatch = (ServerPlayerPatch)rayresult.func_216348_a().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)).getEventListener().triggerEvents(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, new ProjectileHitEvent(playerpatch, event)))) {
                event.setCanceled(true);
            }
            if (projectile.func_234616_v_() != null) {
                if (rayresult.func_216348_a().equals((Object)projectile.func_234616_v_().func_184187_bx())) {
                    event.setCanceled(true);
                }
                if (rayresult.func_216348_a() instanceof PartEntity) {
                    Entity parent = ((PartEntity)rayresult.func_216348_a()).getParent();
                    if (projectile.func_234616_v_().func_70028_i(parent)) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getFrom().func_77973_b() == event.getTo().func_77973_b()) {
            return;
        }
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        CapabilityItem fromCap = EpicFightCapabilities.getItemStackCapability(event.getFrom());
        CapabilityItem toCap = EpicFightCapabilities.getItemStackCapability(event.getTo());
        if (event.getSlot() != EquipmentSlotType.OFFHAND) {
            if (fromCap != null) {
                event.getEntityLiving().func_233645_dx_().func_233785_a_(fromCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
            if (toCap != null) {
                event.getEntityLiving().func_233645_dx_().func_233793_b_(toCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
        }
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.HAND) {
                Hand hand = event.getSlot() == EquipmentSlotType.MAINHAND ? Hand.MAIN_HAND : Hand.OFF_HAND;
                entitypatch.updateHeldItem(fromCap, toCap, event.getFrom(), event.getTo(), hand);
            } else if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR) {
                entitypatch.updateArmor(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void sizingEvent(EntityEvent.Size event) {
        if (event.getEntity() instanceof EnderDragonEntity) {
            event.setNewSize(EntitySize.func_220314_b((float)5.0f, (float)3.0f));
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntity().field_70170_p.func_201670_d()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getPotionEffect().func_188419_a(), SPPotion.Action.ACTIVATE, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (!event.getEntity().field_70170_p.func_201670_d() && event.getPotionEffect() != null) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getPotionEffect().func_188419_a(), SPPotion.Action.REMOVE, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (!event.getEntity().field_70170_p.func_201670_d()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getPotionEffect().func_188419_a(), SPPotion.Action.REMOVE, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        EntityPatch mountEntity = (EntityPatch)event.getEntityMounting().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (!event.getWorldObj().func_201670_d() && mountEntity instanceof HumanoidMobPatch && mountEntity.getOriginal() != null && event.getEntityBeingMounted() instanceof MobEntity) {
            ((HumanoidMobPatch)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void tpEvent(EntityTeleportEvent.EnderEntity event) {
        EndermanEntity enderman;
        EndermanPatch endermanpatch;
        LivingEntity entity = event.getEntityLiving();
        if (event.getEntityLiving() instanceof EndermanEntity && (endermanpatch = (EndermanPatch)(enderman = (EndermanEntity)entity).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            if (endermanpatch.getEntityState().inaction()) {
                for (Entity collideEntity : enderman.field_70170_p.func_217357_a(Entity.class, enderman.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2))) {
                    if (!(collideEntity instanceof ProjectileEntity)) continue;
                    return;
                }
                event.setCanceled(true);
            } else if (endermanpatch.isRaging()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null && entitypatch.isLogicalClient() && !entitypatch.getEntityState().inaction() && !event.getEntity().func_70090_H()) {
            StaticAnimation jumpAnimation = entitypatch.getClientAnimator().getJumpAnimation();
            ((Animator)entitypatch.getAnimator()).playAnimation(jumpAnimation, 0.0f);
            EpicFightNetworkManager.sendToServer(new CPPlayAnimation(jumpAnimation.getNamespaceId(), jumpAnimation.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)event.getEntityLiving().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null) {
            entitypatch.onDeath();
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
    }
}

