/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeGamerule;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.ItemUseEndEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@Mod.EventBusSubscriber(modid="epicfight")
public class PlayerEvents {
    @SubscribeEvent
    public static void startTrackingEvent(PlayerEvent.StartTracking event) {
        Entity trackingTarget = event.getTarget();
        LivingEntityPatch entitypatch = (LivingEntityPatch)trackingTarget.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (entitypatch != null) {
            entitypatch.onStartTracking((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void rightClickItemServerEvent(PlayerInteractEvent.RightClickItem event) {
        ServerPlayerPatch playerpatch;
        if (!(event.getSide() != LogicalSide.SERVER || (playerpatch = (ServerPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) == null || ((ServerPlayerEntity)playerpatch.getOriginal()).func_184592_cb().func_77975_n() != UseAction.NONE && playerpatch.getHoldingItemCapability(Hand.MAIN_HAND).getStyle(playerpatch).canUseOffhand())) {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, new RightClickItemEvent<ServerPlayerPatch>(playerpatch));
            if (playerpatch.getEntityState().movementLocked()) {
                canceled = true;
            }
            event.setCanceled(canceled);
        }
    }

    @SubscribeEvent
    public static void itemUseStartEvent(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            PlayerPatch playerpatch = (PlayerPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            Hand hand = player.func_184586_b(Hand.MAIN_HAND).equals(event.getItem()) ? Hand.MAIN_HAND : Hand.OFF_HAND;
            CapabilityItem itemCap = playerpatch.getHoldingItemCapability(hand);
            if (!playerpatch.getEntityState().canUseSkill()) {
                event.setCanceled(true);
            } else if (event.getItem() == player.func_184592_cb() && !playerpatch.getHoldingItemCapability(Hand.MAIN_HAND).getStyle(playerpatch).canUseOffhand()) {
                event.setCanceled(true);
            }
            if (itemCap.getUseAnimation(playerpatch) == UseAction.BLOCK) {
                event.setDuration(Integer.MAX_VALUE);
            }
        }
    }

    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        ServerPlayerPatch oldCap = (ServerPlayerPatch)event.getOriginal().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (oldCap != null) {
            ServerPlayerPatch newCap = (ServerPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (!event.isWasDeath() || event.getOriginal().field_70170_p.func_82736_K().func_223586_b(EpicFightGamerules.KEEP_SKILLS)) {
                newCap.copySkillsFrom(oldCap);
            }
            newCap.toMode(oldCap.getPlayerMode(), false);
        }
    }

    @SubscribeEvent
    public static void changeDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        ServerPlayerPatch playerpatch = (ServerPlayerPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        playerpatch.modifyLivingMotionByCurrentItem();
        EpicFightNetworkManager.sendToPlayer(new SPChangeGamerule(SPChangeGamerule.SynchronizedGameRules.WEIGHT_PENALTY, player.field_70170_p.func_82736_K().func_223592_c(EpicFightGamerules.WEIGHT_PENALTY)), (ServerPlayerEntity)player);
        EpicFightNetworkManager.sendToPlayer(new SPChangeGamerule(SPChangeGamerule.SynchronizedGameRules.DIABLE_ENTITY_UI, player.field_70170_p.func_82736_K().func_223586_b(EpicFightGamerules.DISABLE_ENTITY_UI)), (ServerPlayerEntity)player);
    }

    @SubscribeEvent
    public static void itemUseStopEvent(LivingEntityUseItemEvent.Stop event) {
        ServerPlayerEntity player;
        ServerPlayerPatch playerpatch;
        if (event.getEntity().field_70170_p.func_201670_d()) {
            if (event.getEntity() instanceof ClientPlayerEntity) {
                ClientEngine.instance.renderEngine.zoomOut(0);
            }
        } else if (event.getEntity() instanceof ServerPlayerEntity && (playerpatch = (ServerPlayerPatch)(player = (ServerPlayerEntity)event.getEntity()).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, new ItemUseEndEvent(playerpatch));
            event.setCanceled(canceled);
        }
    }

    @SubscribeEvent
    public static void itemUseTickEvent(LivingEntityUseItemEvent.Tick event) {
        PlayerPatch playerpatch;
        if (event.getEntity() instanceof PlayerEntity && event.getItem().func_77973_b() instanceof BowItem && (playerpatch = (PlayerPatch)event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)).getEntityState().inaction()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attackEntityEvent(AttackEntityEvent event) {
        boolean isLivingTarget;
        boolean bl = isLivingTarget = event.getTarget() instanceof LivingEntity ? ((LivingEntity)event.getTarget()).func_190631_cK() : false;
        if (!event.getEntity().field_70170_p.func_82736_K().func_223586_b(EpicFightGamerules.DO_VANILLA_ATTACK) && isLivingTarget) {
            event.setCanceled(true);
        }
    }
}

