/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.gameasset;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import yesman.epicfight.api.model.Model;

public abstract class Models<T extends Model> {
    public static final ServerModels LOGICAL_SERVER = new ServerModels();
    protected final Map<ResourceLocation, T> models = Maps.newHashMap();
    public T biped;
    public T bipedOldTexture;
    public T bipedAlex;
    public T villagerZombie;
    public T villagerZombieBody;
    public T creeper;
    public T enderman;
    public T skeleton;
    public T spider;
    public T ironGolem;
    public T illager;
    public T witch;
    public T ravager;
    public T vex;
    public T piglin;
    public T hoglin;
    public T dragon;
    public T wither;

    public abstract T register(ResourceLocation var1);

    public T get(ResourceLocation location) {
        return (T)((Model)this.models.get(location));
    }

    public void loadArmatures(IResourceManager resourceManager) {
        ((Model)this.biped).loadArmatureData(resourceManager);
        ((Model)this.bipedOldTexture).loadArmatureData(((Model)this.biped).getArmature());
        ((Model)this.bipedAlex).loadArmatureData(((Model)this.biped).getArmature());
        ((Model)this.villagerZombie).loadArmatureData(((Model)this.biped).getArmature());
        ((Model)this.creeper).loadArmatureData(resourceManager);
        ((Model)this.skeleton).loadArmatureData(resourceManager);
        ((Model)this.enderman).loadArmatureData(resourceManager);
        ((Model)this.spider).loadArmatureData(resourceManager);
        ((Model)this.ironGolem).loadArmatureData(resourceManager);
        ((Model)this.ravager).loadArmatureData(resourceManager);
        ((Model)this.vex).loadArmatureData(resourceManager);
        ((Model)this.piglin).loadArmatureData(resourceManager);
        ((Model)this.illager).loadArmatureData(((Model)this.biped).getArmature());
        ((Model)this.witch).loadArmatureData(((Model)this.biped).getArmature());
        ((Model)this.hoglin).loadArmatureData(resourceManager);
        ((Model)this.dragon).loadArmatureData(resourceManager);
        ((Model)this.wither).loadArmatureData(resourceManager);
    }

    public abstract Models<?> getModels(boolean var1);

    public static class ServerModels
    extends Models<Model> {
        public ServerModels() {
            this.biped = this.register(new ResourceLocation("epicfight", "entity/biped"));
            this.bipedOldTexture = this.register(new ResourceLocation("epicfight", "entity/biped_old_texture"));
            this.bipedAlex = this.register(new ResourceLocation("epicfight", "entity/biped_slim_arm"));
            this.villagerZombie = this.register(new ResourceLocation("epicfight", "entity/zombie_villager"));
            this.villagerZombieBody = this.register(new ResourceLocation("epicfight", "entity/zombie_villager_body"));
            this.creeper = this.register(new ResourceLocation("epicfight", "entity/creeper"));
            this.enderman = this.register(new ResourceLocation("epicfight", "entity/enderman"));
            this.skeleton = this.register(new ResourceLocation("epicfight", "entity/skeleton"));
            this.spider = this.register(new ResourceLocation("epicfight", "entity/spider"));
            this.ironGolem = this.register(new ResourceLocation("epicfight", "entity/iron_golem"));
            this.illager = this.register(new ResourceLocation("epicfight", "entity/illager"));
            this.witch = this.register(new ResourceLocation("epicfight", "entity/witch"));
            this.ravager = this.register(new ResourceLocation("epicfight", "entity/ravager"));
            this.vex = this.register(new ResourceLocation("epicfight", "entity/vex"));
            this.piglin = this.register(new ResourceLocation("epicfight", "entity/piglin"));
            this.hoglin = this.register(new ResourceLocation("epicfight", "entity/hoglin"));
            this.dragon = this.register(new ResourceLocation("epicfight", "entity/dragon"));
            this.wither = this.register(new ResourceLocation("epicfight", "entity/wither"));
        }

        @Override
        public Models<?> getModels(boolean isLogicalClient) {
            return LOGICAL_SERVER;
        }

        @Override
        public Model register(ResourceLocation rl) {
            Model model = new Model(rl);
            this.models.put(rl, model);
            return model;
        }
    }
}

