/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPChangeSkill {
    private int skillSlotIndex;
    private int itemSlotIndex;
    private String skillName;
    private boolean consumeXp;

    public CPChangeSkill() {
        this(0, -1, "", false);
    }

    public CPChangeSkill(int skillSlotIndex, int itemSlotIndex, String name, boolean consumeXp) {
        this.skillSlotIndex = skillSlotIndex;
        this.itemSlotIndex = itemSlotIndex;
        this.skillName = name;
        this.consumeXp = consumeXp;
    }

    public static CPChangeSkill fromBytes(PacketBuffer buf) {
        CPChangeSkill msg = new CPChangeSkill(buf.readInt(), buf.readInt(), buf.func_218666_n(), buf.readBoolean());
        return msg;
    }

    public static void toBytes(CPChangeSkill msg, PacketBuffer buf) {
        buf.writeInt(msg.skillSlotIndex);
        buf.writeInt(msg.itemSlotIndex);
        buf.func_180714_a(msg.skillName);
        buf.writeBoolean(msg.consumeXp);
    }

    public static void handle(CPChangeSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerpatch != null) {
                Skill skill = Skills.getSkill(msg.skillName);
                playerpatch.getSkill(msg.skillSlotIndex).setSkill(skill);
                if (skill.getCategory().learnable()) {
                    playerpatch.getSkillCapability().addLearnedSkill(skill);
                }
                if (msg.consumeXp) {
                    serverPlayer.func_82242_a(-skill.getRequiredXp());
                } else if (!serverPlayer.func_184812_l_()) {
                    serverPlayer.field_71071_by.func_184437_d(serverPlayer.field_71071_by.func_70301_a(msg.itemSlotIndex));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

