/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.lang.constant.Constable;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.network.NetworkEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class SPChangeGamerule {
    private SynchronizedGameRules gamerule;
    private int gameruleId;
    private Object object;

    public SPChangeGamerule(SynchronizedGameRules gamerule, Object object) {
        this.gamerule = gamerule;
        this.gameruleId = gamerule.ordinal();
        this.object = object;
    }

    public static SPChangeGamerule fromBytes(PacketBuffer buf) {
        int id = buf.readInt();
        SynchronizedGameRules gamerule = SynchronizedGameRules.values()[id];
        Constable obj = null;
        switch (gamerule.valueType) {
            case INTEGER: {
                obj = buf.readInt();
                break;
            }
            case BOOLEAN: {
                obj = Boolean.valueOf(buf.readBoolean());
            }
        }
        return new SPChangeGamerule(gamerule, obj);
    }

    public static void toBytes(SPChangeGamerule msg, PacketBuffer buf) {
        buf.writeInt(msg.gameruleId);
        switch (msg.gamerule.valueType) {
            case INTEGER: {
                buf.writeInt(((Integer)msg.object).intValue());
                break;
            }
            case BOOLEAN: {
                buf.writeBoolean(((Boolean)msg.object).booleanValue());
            }
        }
    }

    public static void handle(SPChangeGamerule msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (msg.gamerule.valueType) {
                case INTEGER: {
                    ((GameRules.IntegerValue)Minecraft.func_71410_x().field_71441_e.func_82736_K().func_223585_a(msg.gamerule.key)).func_234909_b_(msg.object.toString());
                    break;
                }
                case BOOLEAN: {
                    ((GameRules.BooleanValue)Minecraft.func_71410_x().field_71441_e.func_82736_K().func_223585_a(msg.gamerule.key)).func_223570_a(((Boolean)msg.object).booleanValue(), null);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum SynchronizedGameRules {
        HAS_FALL_ANIMATION(ValueType.BOOLEAN, EpicFightGamerules.HAS_FALL_ANIMATION),
        WEIGHT_PENALTY(ValueType.INTEGER, EpicFightGamerules.WEIGHT_PENALTY),
        DIABLE_ENTITY_UI(ValueType.BOOLEAN, EpicFightGamerules.DISABLE_ENTITY_UI);

        ValueType valueType;
        GameRules.RuleKey<?> key;

        private SynchronizedGameRules(ValueType valueType, GameRules.RuleKey<?> key) {
            this.valueType = valueType;
            this.key = key;
        }

        static enum ValueType {
            INTEGER,
            BOOLEAN;

        }
    }
}

