/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class SPChangeSkill {
    private int slotIndex;
    private String skillName;
    private State state;

    public SPChangeSkill() {
        this(0, "", State.ENABLE);
    }

    public SPChangeSkill(int slotIndex, String name, State state) {
        this.slotIndex = slotIndex;
        this.skillName = name;
        this.state = state;
    }

    public static SPChangeSkill fromBytes(PacketBuffer buf) {
        SPChangeSkill msg = new SPChangeSkill(buf.readInt(), buf.func_218666_n(), State.values()[buf.readInt()]);
        return msg;
    }

    public static void toBytes(SPChangeSkill msg, PacketBuffer buf) {
        buf.writeInt(msg.slotIndex);
        buf.func_180714_a(msg.skillName);
        buf.writeInt(msg.state.ordinal());
    }

    public static void handle(SPChangeSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.func_71410_x();
            LocalPlayerPatch playerpatch = (LocalPlayerPatch)mc.field_71439_g.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerpatch != null) {
                if (!msg.skillName.equals("")) {
                    Skill skill = Skills.getSkill(msg.skillName);
                    playerpatch.getSkill(msg.slotIndex).setSkill(skill);
                    if (SkillCategory.ENUM_MANAGER.get(msg.slotIndex).learnable()) {
                        playerpatch.getSkillCapability().addLearnedSkill(skill);
                    }
                }
                playerpatch.getSkill(msg.slotIndex).setDisabled(msg.state.setter);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum State {
        ENABLE(false),
        DISABLE(true);

        boolean setter;

        private State(boolean setter) {
            this.setter = setter;
        }
    }
}

