/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerModeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"mode").requires(commandSourceStack -> commandSourceStack.func_197034_c(2));
        for (PlayerPatch.PlayerMode mode : PlayerPatch.PlayerMode.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)mode.name().toLowerCase(Locale.ROOT)).executes(command -> PlayerModeCommand.setMode((CommandContext<CommandSource>)command, Collections.singleton(((CommandSource)command.getSource()).func_197035_h()), mode))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(p_137728_ -> PlayerModeCommand.setMode((CommandContext<CommandSource>)p_137728_, EntityArgument.func_197090_e((CommandContext)p_137728_, (String)"target"), mode))));
        }
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"epicfight").then((ArgumentBuilder)builder));
    }

    private static int setMode(CommandContext<CommandSource> command, Collection<ServerPlayerEntity> players, PlayerPatch.PlayerMode playerMode) {
        int i = 0;
        for (ServerPlayerEntity serverplayer : players) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverplayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (playerpatch == null) continue;
            PlayerModeCommand.logGamemodeChange((CommandSource)command.getSource(), serverplayer, playerMode);
            playerpatch.toMode(playerMode, true);
            ++i;
        }
        return i;
    }

    private static void logGamemodeChange(CommandSource command, ServerPlayerEntity serverPlayer, PlayerPatch.PlayerMode playerMode) {
        TranslationTextComponent component = new TranslationTextComponent("gameMode.epicfight." + playerMode.name().toLowerCase(Locale.ROOT));
        if (command.func_197022_f() == serverPlayer) {
            command.func_197030_a((ITextComponent)new TranslationTextComponent("commands.gamemode.success.self", new Object[]{component}), true);
        } else {
            if (command.func_197023_e().func_82736_K().func_223586_b(GameRules.field_223611_n)) {
                serverPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("gameMode.changed", new Object[]{component}), Util.field_240973_b_);
            }
            command.func_197030_a((ITextComponent)new TranslationTextComponent("commands.gamemode.success.other", new Object[]{serverPlayer.func_145748_c_(), component}), true);
        }
    }
}

