/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPClearSkills;
import yesman.epicfight.network.server.SPRemoveSkill;
import yesman.epicfight.server.commands.arguments.SkillArgument;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerSkillCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.epicfight.skill.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.epicfight.skill.remove.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.epicfight.skill.clear.failed"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"skill").requires(commandSourceStack -> commandSourceStack.func_197034_c(2))).then(Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(commandContext -> PlayerSkillCommand.clearSkill((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext)commandContext, (String)"targets")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.addSkill((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext)commandContext, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSource>)commandContext, "skill"))))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.removeSkill((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext)commandContext, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSource>)commandContext, "skill"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"epicfight").then((ArgumentBuilder)builder));
    }

    public static int clearSkill(CommandSource commandSourceStack, Collection<? extends ServerPlayerEntity> targets) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayerEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            playerpatch.getSkillCapability().clear();
            EpicFightNetworkManager.sendToPlayer(new SPClearSkills(), serverPlayerEntity);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.func_197030_a((ITextComponent)new TranslationTextComponent("commands.epicfight.skill.clear.success.single", new Object[]{targets.iterator().next().func_145748_c_()}), true);
            } else {
                commandSourceStack.func_197030_a((ITextComponent)new TranslationTextComponent("commands.epicfight.skill.clear.success.multiple", new Object[]{i}), true);
            }
        } else {
            throw ERROR_CLEAR_FAILED.create();
        }
        return i;
    }

    public static int addSkill(CommandSource commandSourceStack, Collection<? extends ServerPlayerEntity> targets, Skill skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayerEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (!playerpatch.getSkillCapability().skillContainers[skill.getCategory().universalOrdinal()].setSkill(skill)) continue;
            if (skill.getCategory().learnable()) {
                playerpatch.getSkillCapability().addLearnedSkill(skill);
            }
            EpicFightNetworkManager.sendToPlayer(new SPChangeSkill(skill.getCategory().universalOrdinal(), skill.toString(), SPChangeSkill.State.ENABLE), serverPlayerEntity);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.func_197030_a((ITextComponent)new TranslationTextComponent("commands.epicfight.skill.add.success.single", new Object[]{skill.getDisplayName(), targets.iterator().next().func_145748_c_()}), true);
            } else {
                commandSourceStack.func_197030_a((ITextComponent)new TranslationTextComponent("commands.epicfight.skill.add.success.multiple", new Object[]{skill.getDisplayName(), i}), true);
            }
        } else {
            throw ERROR_ADD_FAILED.create();
        }
        return i;
    }

    public static int removeSkill(CommandSource commandSourceStack, Collection<? extends ServerPlayerEntity> targets, Skill skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)serverPlayerEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerpatch == null || !playerpatch.getSkillCapability().removeLearnedSkill(skill)) continue;
            SkillContainer skillContainer = playerpatch.getSkillCapability().skillContainers[skill.getCategory().universalOrdinal()];
            if (skillContainer.getSkill() == skill) {
                skillContainer.setSkill(null);
            }
            EpicFightNetworkManager.sendToPlayer(new SPRemoveSkill(skill.toString()), serverPlayerEntity);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.func_197030_a((ITextComponent)new TranslationTextComponent("commands.epicfight.skill.remove.success.single", new Object[]{skill.getDisplayName(), targets.iterator().next().func_145748_c_()}), true);
            } else {
                commandSourceStack.func_197030_a((ITextComponent)new TranslationTextComponent("commands.epicfight.skill.remove.success.multiple", new Object[]{skill.getDisplayName(), i}), true);
            }
        } else {
            throw ERROR_REMOVE_FAILED.create();
        }
        return i;
    }
}

