/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class AirAttack
extends Skill {
    public static Skill.Builder<AirAttack> createBuilder() {
        return new Skill.Builder(new ResourceLocation("epicfight", "air_attack")).setCategory(SkillCategories.AIR_ATTACK).setConsumption(2.0f).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public AirAttack(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        PlayerEntity player = (PlayerEntity)executer.getOriginal();
        return !player.func_184218_aH() && !player.func_175149_v() && !executer.isUnstable() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, PacketBuffer args) {
        List<StaticAnimation> motions = executer.getHoldingItemCapability(Hand.MAIN_HAND).getAutoAttckMotion(executer);
        StaticAnimation attackMotion = motions.get(motions.size() - 1);
        if (attackMotion != null) {
            super.executeOnServer(executer, args);
            executer.playAnimationSynchronized(attackMotion, 0.0f);
        }
    }
}

