/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class GuardSkill
extends Skill {
    protected static final SkillDataManager.SkillDataKey<Integer> LAST_HIT_TICK = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    protected static final SkillDataManager.SkillDataKey<Float> PENALTY = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.FLOAT);
    protected static final UUID EVENT_UUID = UUID.fromString("b422f7a0-f378-11eb-9a03-0242ac130003");
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions;
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> advancedGuardMotions;
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardBreakMotions;

    public static Builder createBuilder(ResourceLocation resourceLocation) {
        return new Builder(resourceLocation).setCategory(SkillCategories.GUARD).setMaxStack(0).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA).addGuardMotion(CapabilityItem.WeaponCategories.AXE, (item, player) -> Animations.SWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.KATANA, (item, player) -> Animations.KATANA_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.TWO_HAND ? Animations.SPEAR_GUARD_HIT : null).addGuardMotion(CapabilityItem.WeaponCategories.SWORD, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.ONE_HAND ? Animations.SWORD_GUARD_HIT : Animations.SWORD_DUAL_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addGuardBreakMotion(CapabilityItem.WeaponCategories.AXE, (item, player) -> Animations.COMMON_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.KATANA, (item, player) -> Animations.COMMON_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.COMMON_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.COMMON_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.SWORD, (item, player) -> Animations.COMMON_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.COMMON_GUARD_BREAK);
    }

    public GuardSkill(Builder builder) {
        super(builder);
        this.guardMotions = builder.guardMotions;
        this.advancedGuardMotions = builder.advancedGuardMotions;
        this.guardBreakMotions = builder.guardBreakMotions;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(LAST_HIT_TICK);
        container.getDataManager().registerData(PENALTY);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(Hand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, BlockType.GUARD) && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                ((ClientPlayerEntity)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).func_184598_c(Hand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(Hand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, BlockType.GUARD) && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                ((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_184598_c(Hand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {
            ServerPlayerEntity serverplayer = (ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            container.getDataManager().setDataSync(LAST_HIT_TICK, serverplayer.field_70173_aa, serverplayer);
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> container.getDataManager().setDataSync(PENALTY, Float.valueOf(0.0f), (ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_184600_cs());
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, BlockType.GUARD) && ((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_184587_cr() && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vector3d sourceLocation = damageSource.func_188404_v();
                if (sourceLocation != null) {
                    Vector3d viewVector = ((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_70676_i(1.0f);
                    Vector3d toSourceLocation = sourceLocation.func_178788_d(((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_213303_ch()).func_72432_b();
                    if (toSourceLocation.func_72430_b(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof ExtendedDamageSource) {
                        impact = ((ExtendedDamageSource)event.getDamageSource()).getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
                }
            }
        }, 1);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource = (DamageSource)event.getDamageSource();
        if (this.isBlockableSource(damageSource, advanced)) {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
            ServerPlayerEntity serveerPlayer = (ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerWorld)serveerPlayer.field_70170_p, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serveerPlayer, damageSource.func_76364_f());
            if (damageSource.func_76364_f() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)damageSource.func_76364_f())) * 0.1f;
            }
            float penalty = container.getDataManager().getDataValue(PENALTY).floatValue() + this.getPenaltyMultiplier(itemCapability);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.func_76364_f().func_213303_ch(), knockback);
            float stamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() - penalty * impact;
            ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(stamina);
            container.getDataManager().setDataSync(PENALTY, Float.valueOf(penalty), (ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            BlockType blockType = stamina >= 0.0f ? BlockType.GUARD : BlockType.GUARD_BREAK;
            StaticAnimation animation = this.getGuardMotion((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.NEUTRALIZE_MOBS, 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event);
        }
    }

    public void dealEvent(PlayerPatch<?> playerpatch, HurtEvent.Pre event) {
        event.setCanceled(true);
        event.setResult(AttackResult.ResultType.BLOCKED);
        Entity directEntity = ((DamageSource)event.getDamageSource()).func_76364_f();
        LivingEntityPatch entitypatch = (LivingEntityPatch)directEntity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (entitypatch != null) {
            entitypatch.onAttackBlocked(event, playerpatch);
        }
    }

    protected float getPenaltyMultiplier(CapabilityItem itemCapapbility) {
        return 0.6f;
    }

    protected Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> getGuradMotionMap(BlockType blockType) {
        switch (blockType) {
            case GUARD_BREAK: {
                return this.guardBreakMotions;
            }
            case GUARD: {
                return this.guardMotions;
            }
            case ADVANCED_GUARD: {
                return this.advancedGuardMotions;
            }
        }
        throw new IllegalArgumentException("unsupported block type " + (Object)((Object)blockType));
    }

    protected boolean isHoldingWeaponAvailable(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, BlockType blockType) {
        Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = this.getGuradMotionMap(blockType);
        if (!guardMotions.containsKey(itemCapability.getWeaponCategory())) {
            return false;
        }
        Object motion = guardMotions.get(itemCapability.getWeaponCategory()).apply(itemCapability, playerpatch);
        return motion != null;
    }

    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, BlockType blockType) {
        return (StaticAnimation)this.getGuradMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch);
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient() && !((PlayerEntity)container.getExecuter().getOriginal()).func_184587_cr()) {
            int hitTick;
            float penalty = container.getDataManager().getDataValue(PENALTY).floatValue();
            if (penalty > 0.0f && ((PlayerEntity)container.getExecuter().getOriginal()).field_70173_aa - (hitTick = container.getDataManager().getDataValue(LAST_HIT_TICK).intValue()) > 40) {
                container.getDataManager().setDataSync(PENALTY, Float.valueOf(0.0f), (ServerPlayerEntity)container.getExecuter().getOriginal());
            }
        } else {
            container.getExecuter().resetActionTick();
        }
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 1);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !executer.isUnstable() && !playerState.hurt() && executer.isBattleMode();
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return !damageSource.func_76357_e() && !damageSource.func_76363_c() && !damageSource.func_76352_a() && !damageSource.func_94541_c() && !damageSource.func_82725_o() && !damageSource.func_76347_k();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgs() {
        ArrayList list = Lists.newArrayList();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s", this.guardMotions.keySet().toArray(new Object[0])).toLowerCase());
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.getDataManager().getDataValue(PENALTY).floatValue() > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, MatrixStack matStackIn, float x, float y, float scale, int width, int height) {
        matStackIn.func_227860_a_();
        matStackIn.func_227862_a_(scale, scale, 1.0f);
        matStackIn.func_227861_a_(0.0, (double)((float)gui.getSlidingProgression() * 1.0f / scale), 0.0);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(Skills.GUARD.getSkillTexture());
        float scaleMultiply = 1.0f / scale;
        gui.drawTexturedModalRectFixCoord(matStackIn.func_227866_c_().func_227870_a_(), ((float)width - x) * scaleMultiply, ((float)height - y) * scaleMultiply, 0, 0, 255, 255);
        matStackIn.func_227862_a_(scaleMultiply, scaleMultiply, 1.0f);
        gui.font.func_238405_a_(matStackIn, String.format("x%.1f", container.getDataManager().getDataValue(PENALTY)), (float)width - x, (float)height - y + 6.0f, 0xFFFFFF);
    }

    protected boolean isAdvancedGuard() {
        return false;
    }

    protected static enum BlockType {
        GUARD_BREAK,
        GUARD,
        ADVANCED_GUARD;

    }

    public static class Builder
    extends Skill.Builder<GuardSkill> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = Maps.newHashMap();
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> advancedGuardMotions = Maps.newHashMap();
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardBreakMotions = Maps.newHashMap();

        public Builder(ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setConsumption(float consumption) {
            this.consumption = consumption;
            return this;
        }

        public Builder setMaxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder setMaxStack(int maxStack) {
            this.maxStack = maxStack;
            return this;
        }

        public Builder setRequiredXp(int requiredXp) {
            this.requiredXp = requiredXp;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder addGuardMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.guardMotions.put(weaponCategory, function);
            return this;
        }

        public Builder addAdvancedGuardMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?> function) {
            this.advancedGuardMotions.put(weaponCategory, function);
            return this;
        }

        public Builder addGuardBreakMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.guardBreakMotions.put(weaponCategory, function);
            return this;
        }
    }
}

