/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SpecialAttackSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LiechtenauerSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("244c57c0-a837-11eb-bcbc-0242ac130002");
    private static final SkillDataManager.SkillDataKey<Integer> PARRY_MOTION_COUNTER = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);

    public LiechtenauerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(PARRY_MOTION_COUNTER);
        if (!container.getExecuter().isLogicalClient()) {
            this.setMaxDurationSynchronize((ServerPlayerPatch)container.getExecuter(), this.maxDuration + EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_191530_r, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())));
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (container.isActivated() && !event.getTarget().func_70089_S()) {
                this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.duration + 1);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (event.getAmount() > 0.0f && container.duration > 0 && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch()) && this.canExecute((PlayerPatch<?>)event.getPlayerPatch()) && LiechtenauerSkill.isBlockableSource((DamageSource)event.getDamageSource())) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vector3d sourceLocation = damageSource.func_188404_v();
                if (sourceLocation != null) {
                    Vector3d viewVector = ((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_70676_i(1.0f);
                    Vector3d toSourceLocation = sourceLocation.func_178788_d(((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_213303_ch()).func_72432_b();
                    if (toSourceLocation.func_72430_b(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.duration - 1);
                    if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillCategory)SkillCategories.GUARD).containingSkill == Skills.ACTIVE_GUARD) {
                        SkillDataManager dataManager = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill(this.getCategory()).getDataManager();
                        int motionCounter = dataManager.getDataValue(PARRY_MOTION_COUNTER);
                        dataManager.setDataF(PARRY_MOTION_COUNTER, v -> v + 1);
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized((motionCounter %= 2) == 0 ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2, 0.0f);
                    } else {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(Animations.LONGSWORD_GUARD_HIT, 0.0f);
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
                    Object playerentity = ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerWorld)((Entity)playerentity).field_70170_p, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.func_76364_f());
                    float knockback = 0.25f;
                    if (damageSource instanceof ExtendedDamageSource) {
                        knockback += Math.min(((ExtendedDamageSource)damageSource).getImpact() * 0.1f, 1.0f);
                    }
                    if (damageSource.func_76364_f() instanceof LivingEntity) {
                        knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)damageSource.func_76364_f())) * 0.1f;
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.func_76364_f().func_213303_ch(), knockback);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                }
            }
        }, 0);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getSkill(this.category).isActivated()) {
                ClientPlayerEntity clientPlayer = (ClientPlayerEntity)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.func_70031_b(false);
                clientPlayer.field_71156_d = -1;
                Minecraft mc = Minecraft.func_71410_x();
                ClientEngine.instance.inputController.setKeyBind(mc.field_71474_y.field_151444_V, false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, PacketBuffer args) {
        if (executer.getSkill(this.category).isActivated()) {
            super.cancelOnServer(executer, args);
            this.setConsumptionSynchronize(executer, this.consumption * ((float)executer.getSkill((SkillCategory)this.category).duration / (float)(this.maxDuration + EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_191530_r, (LivingEntity)((LivingEntity)executer.getOriginal())) + 1)));
            this.setDurationSynchronize(executer, 0);
            this.setStackSynchronize(executer, executer.getSkill(this.category).getStack() - 1);
            executer.modifyLivingMotionByCurrentItem();
        } else {
            this.setDurationSynchronize(executer, this.maxDuration + EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_191530_r, (LivingEntity)((LivingEntity)executer.getOriginal())));
            executer.getSkill(this.category).activate();
            executer.modifyLivingMotionByCurrentItem();
        }
    }

    @Override
    public void cancelOnServer(ServerPlayerPatch executer, PacketBuffer args) {
        super.cancelOnServer(executer, args);
        this.setConsumptionSynchronize(executer, 0.0f);
        this.setStackSynchronize(executer, executer.getSkill(this.category).getStack() - 1);
        executer.modifyLivingMotionByCurrentItem();
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        return executer.getHoldingItemCapability(Hand.MAIN_HAND).getSpecialAttack(executer) == this && ((PlayerEntity)executer.getOriginal()).func_184187_bx() == null;
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        return this;
    }

    private static boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.func_76357_e() && !damageSource.func_94541_c();
    }
}

