/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPModifySkillData;

public class SkillDataManager {
    private final Map<Integer, Data> data = Maps.newHashMap();
    private final int slotIndex;

    public SkillDataManager(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public <T> void registerData(SkillDataKey<T> key) {
        this.data.put(key.getId(), ((SkillDataKey)key).valueType.create());
    }

    @Deprecated
    public void setDataRawtype(SkillDataKey<?> key, Object data) {
        if (this.hasData(key)) {
            ((SkillDataKey)key).valueType.set(this.data.get(key.getId()), data);
        }
    }

    public <T> void setData(SkillDataKey<T> key, T data) {
        this.setDataRawtype(key, data);
    }

    public <T> void setDataF(SkillDataKey<T> key, Function<T, T> dataManipulator) {
        this.setDataRawtype(key, dataManipulator.apply(this.getDataValue(key)));
    }

    public <T> void setDataSync(SkillDataKey<T> key, T data, ServerPlayerEntity player) {
        this.setData(key, data);
        SPModifySkillData msg2 = new SPModifySkillData(key, this.slotIndex, data);
        EpicFightNetworkManager.sendToPlayer(msg2, player);
    }

    public <T> void setDataSyncF(SkillDataKey<T> key, Function<T, T> dataManipulator, ServerPlayerEntity player) {
        this.setDataF(key, dataManipulator);
        SPModifySkillData msg2 = new SPModifySkillData(key, this.slotIndex, this.data.get(key.getId()));
        EpicFightNetworkManager.sendToPlayer(msg2, player);
    }

    public <T> T getDataValue(SkillDataKey<T> key) {
        if (this.hasData(key)) {
            return ((SkillDataKey)key).valueType.get(this.data.get(key.getId()));
        }
        return null;
    }

    public boolean hasData(SkillDataKey<?> key) {
        return this.data.containsKey(key.getId());
    }

    public void reset() {
        this.data.clear();
    }

    public static class SkillDataKey<T> {
        private static int NEXT_ID;
        private static final Map<Integer, SkillDataKey<?>> KEYS;
        private final ValueType<T> valueType;
        private final int id;

        public static <V> SkillDataKey<V> createDataKey(ValueType<V> valueType) {
            int id = NEXT_ID++;
            SkillDataKey<V> key = new SkillDataKey<V>(valueType, id);
            KEYS.put(id, key);
            return key;
        }

        public static SkillDataKey<?> findById(int id) {
            return KEYS.get(id);
        }

        private SkillDataKey(ValueType<T> valueType, int id) {
            this.valueType = valueType;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public ValueType<T> getValueType() {
            return this.valueType;
        }

        static {
            KEYS = Maps.newHashMap();
        }
    }

    public static abstract class ValueType<T> {
        public static final IntegerType INTEGER = new IntegerType();
        public static final FloatType FLOAT = new FloatType();
        public static final BooleanType BOOLEAN = new BooleanType();

        public abstract Data create();

        public abstract void set(Data var1, Object var2);

        public abstract T get(Data var1);

        public abstract void writeToBuffer(PacketBuffer var1, Object var2);

        public abstract T readFromBuffer(PacketBuffer var1);

        private static class FloatType
        extends ValueType<Float> {
            private FloatType() {
            }

            @Override
            public Data.FloatData create() {
                return new Data.FloatData();
            }

            @Override
            public void set(Data data, Object value) {
                ((Data.FloatData)data).data = ((Float)value).floatValue();
            }

            @Override
            public Float get(Data data) {
                return Float.valueOf(data != null ? ((Data.FloatData)data).data : 0.0f);
            }

            @Override
            public void writeToBuffer(PacketBuffer buf, Object data) {
                buf.writeFloat(((Float)data).floatValue());
            }

            @Override
            public Float readFromBuffer(PacketBuffer buf) {
                return Float.valueOf(buf.readFloat());
            }
        }

        private static class BooleanType
        extends ValueType<Boolean> {
            private BooleanType() {
            }

            @Override
            public Data.BooleanData create() {
                return new Data.BooleanData();
            }

            @Override
            public void set(Data data, Object value) {
                ((Data.BooleanData)data).data = (Boolean)value;
            }

            @Override
            public Boolean get(Data data) {
                return data != null ? ((Data.BooleanData)data).data : false;
            }

            @Override
            public void writeToBuffer(PacketBuffer buf, Object data) {
                buf.writeBoolean(((Boolean)data).booleanValue());
            }

            @Override
            public Boolean readFromBuffer(PacketBuffer buf) {
                return buf.readBoolean();
            }
        }

        private static class IntegerType
        extends ValueType<Integer> {
            private IntegerType() {
            }

            @Override
            public Data.IntegerData create() {
                return new Data.IntegerData();
            }

            @Override
            public void set(Data data, Object value) {
                ((Data.IntegerData)data).data = (Integer)value;
            }

            @Override
            public Integer get(Data data) {
                return data != null ? ((Data.IntegerData)data).data : 0;
            }

            @Override
            public void writeToBuffer(PacketBuffer buf, Object data) {
                buf.writeInt(((Integer)data).intValue());
            }

            @Override
            public Integer readFromBuffer(PacketBuffer buf) {
                return buf.readInt();
            }
        }
    }

    static abstract class Data {
        Data() {
        }

        static class FloatData
        extends Data {
            float data;

            FloatData() {
            }
        }

        static class BooleanData
        extends Data {
            boolean data;

            BooleanData() {
            }
        }

        static class IntegerData
        extends Data {
            int data;

            IntegerData() {
            }
        }
    }
}

