/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.network.EpicFightDataSerializers;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.DroppedNetherStar;
import yesman.epicfight.world.entity.WitherGhostClone;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviorGoal;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public class WitherPatch
extends MobPatch<WitherEntity> {
    private static final DataParameter<Boolean> DATA_ARMOR_ACTIVED = EntityDataManager.func_187226_a(WitherEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_GHOST = EntityDataManager.func_187226_a(WitherEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DATA_TRANSPARENCY = EntityDataManager.func_187226_a(WitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Vector3d> DATA_LASER_DESTINATION_A = EntityDataManager.func_187226_a(WitherEntity.class, EpicFightDataSerializers.VEC3);
    private static final DataParameter<Vector3d> DATA_LASER_DESTINATION_B = EntityDataManager.func_187226_a(WitherEntity.class, EpicFightDataSerializers.VEC3);
    private static final DataParameter<Vector3d> DATA_LASER_DESTINATION_C = EntityDataManager.func_187226_a(WitherEntity.class, EpicFightDataSerializers.VEC3);
    private static final List<DataParameter<Vector3d>> DATA_LASER_TARGET_POSITIONS = ImmutableList.of(DATA_LASER_DESTINATION_A, DATA_LASER_DESTINATION_B, DATA_LASER_DESTINATION_C);
    private static final DataParameter<Integer> DATA_LASER_TARGET_A = EntityDataManager.func_187226_a(WitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_LASER_TARGET_B = EntityDataManager.func_187226_a(WitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_LASER_TARGET_C = EntityDataManager.func_187226_a(WitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final List<DataParameter<Integer>> DATA_LASER_TARGETS = ImmutableList.of(DATA_LASER_TARGET_A, DATA_LASER_TARGET_B, DATA_LASER_TARGET_C);
    private static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = p_213797_0_ -> p_213797_0_.func_70668_bt() != CreatureAttribute.field_223223_b_ && p_213797_0_.func_190631_cK();
    public static final EntityPredicate WTIHER_TARGETING_CONDITIONS = new EntityPredicate().func_221013_a(20.0).func_221012_a(LIVING_ENTITY_SELECTOR);
    public static final EntityPredicate WTIHER_GHOST_TARGETING_CONDITIONS = new EntityPredicate().func_221013_a(20.0).func_221012_a(LIVING_ENTITY_SELECTOR).func_221010_e();
    private boolean blockedNow;
    private int deathTimerExt;
    private int blockingCount;
    private int blockingStartTick;
    private LivingEntityPatch<?> blockingEntity;

    @Override
    public void onConstructed(WitherEntity witherBoss) {
        super.onConstructed(witherBoss);
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_ARMOR_ACTIVED, (Object)false);
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_GHOST, (Object)false);
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_TRANSPARENCY, (Object)0);
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_LASER_DESTINATION_A, (Object)new Vector3d(Double.NaN, Double.NaN, Double.NaN));
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_LASER_DESTINATION_C, (Object)new Vector3d(Double.NaN, Double.NaN, Double.NaN));
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_LASER_DESTINATION_B, (Object)new Vector3d(Double.NaN, Double.NaN, Double.NaN));
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_LASER_TARGET_A, (Object)0);
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_LASER_TARGET_B, (Object)0);
        ((WitherEntity)this.original).func_184212_Q().func_187214_a(DATA_LASER_TARGET_C, (Object)0);
    }

    @Override
    public void initAI() {
        super.initAI();
        ((WitherEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new WitherChasingGoal());
        ((WitherEntity)this.original).field_70714_bg.func_75776_a(0, (Goal)new WitherGhostAttackGoal());
        ((WitherEntity)this.original).field_70714_bg.func_75776_a(0, new CombatBehaviorGoal<WitherPatch>(this, MobCombatBehaviors.WITHER.build(this)));
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((WitherEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(3.0);
    }

    @Override
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.WITHER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.WITHER_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((WitherEntity)this.original).func_110143_aJ() <= 0.0f ? LivingMotions.DEATH : LivingMotions.IDLE;
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        int targetId;
        Entity target;
        if (((WitherEntity)this.original).func_110143_aJ() <= 0.0f && ((WitherEntity)this.original).field_70725_aQ > 1 && this.deathTimerExt < 17) {
            ++this.deathTimerExt;
            --((WitherEntity)this.original).field_70725_aQ;
        }
        if (!this.getEntityState().inaction() && (target = ((WitherEntity)this.original).field_70170_p.func_73045_a(targetId = ((WitherEntity)this.original).func_82203_t(0))) != null) {
            float yrot;
            Vector3d vec3 = target.func_213303_ch().func_178788_d(((WitherEntity)this.original).func_213303_ch()).func_72432_b();
            ((WitherEntity)this.original).field_70177_z = yrot = MathUtils.rotlerp(((WitherEntity)this.original).field_70177_z, (float)MathHelper.func_181159_b((double)vec3.field_72449_c, (double)vec3.field_72450_a) * 57.295776f - 90.0f, 10.0f);
        }
        super.tick(event);
    }

    @Override
    public void clientTick(LivingEvent.LivingUpdateEvent event) {
        super.clientTick(event);
        ((WitherEntity)this.original).func_213293_j(0.0, 0.0, 0.0);
        int transparencyCount = this.getTransparency();
        if (transparencyCount != 0) {
            this.setTransparency(transparencyCount + (transparencyCount > 0 ? -1 : 1));
        }
    }

    @Override
    public void serverTick(LivingEvent.LivingUpdateEvent event) {
        super.serverTick(event);
        if (((WitherEntity)this.original).func_110143_aJ() <= ((WitherEntity)this.original).func_110138_aP() * 0.5f) {
            if (!this.isArmorActivated() && !this.getEntityState().inaction() && ((WitherEntity)this.original).func_82212_n() <= 0 && ((WitherEntity)this.original).func_70089_S()) {
                this.playAnimationSynchronized(Animations.WITHER_SPELL_ARMOR, 0.0f);
            }
        } else if (this.isArmorActivated()) {
            this.setArmorActivated(false);
        }
        if (this.animator.getPlayerFor(null).getAnimation().equals(Animations.WITHER_CHARGE) && this.getEntityState().attacking() && ForgeEventFactory.getMobGriefingEvent((World)((WitherEntity)this.original).field_70170_p, (Entity)this.original)) {
            int x = MathHelper.func_76128_c((double)((WitherEntity)this.original).func_226277_ct_());
            int y = MathHelper.func_76128_c((double)((WitherEntity)this.original).func_226278_cu_());
            int z = MathHelper.func_76128_c((double)((WitherEntity)this.original).func_226281_cx_());
            boolean flag = false;
            for (int j = -1; j <= 1; ++j) {
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int k = 0; k <= 3; ++k) {
                        int l2 = x + j;
                        int l = y + k;
                        int i1 = z + k2;
                        BlockPos blockpos = new BlockPos(l2, l, i1);
                        BlockState blockstate = ((WitherEntity)this.original).field_70170_p.func_180495_p(blockpos);
                        if (!blockstate.canEntityDestroy((IBlockReader)((WitherEntity)this.original).field_70170_p, blockpos, this.original) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)this.original), (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = ((WitherEntity)this.original).field_70170_p.func_225521_a_(blockpos, true, this.original) || flag;
                    }
                }
            }
            if (flag) {
                ((WitherEntity)this.original).field_70170_p.func_217378_a((PlayerEntity)null, 1022, ((WitherEntity)this.original).func_233580_cy_(), 0);
            }
        }
        if (this.blockedNow) {
            if (this.blockingCount < 0) {
                this.playAnimationSynchronized(Animations.WITHER_NEUTRALIZED, 0.0f);
                ((WitherEntity)this.original).func_184185_a(EpicFightSounds.NEUTRALIZE_BOSSES, 5.0f, 1.0f);
                this.blockedNow = false;
                this.blockingEntity = null;
            } else if (((WitherEntity)this.original).field_70173_aa % 4 == (this.blockingStartTick - 1) % 4) {
                if (((WitherEntity)this.original).func_213303_ch().func_72436_e(((LivingEntity)this.blockingEntity.getOriginal()).func_213303_ch()) < 9.0) {
                    ExtendedDamageSource extendedSource = this.getDamageSource(ExtendedDamageSource.StunType.KNOCKDOWN, Animations.WITHER_CHARGE, Hand.MAIN_HAND);
                    extendedSource.setImpact(4.0f);
                    extendedSource.setInitialPosition(this.lastAttackPosition);
                    AttackResult attackResult = this.tryHarm((Entity)this.blockingEntity.getOriginal(), extendedSource, this.blockingCount);
                    if (attackResult.resultType == AttackResult.ResultType.SUCCESS) {
                        ((LivingEntity)this.blockingEntity.getOriginal()).func_70097_a((DamageSource)extendedSource, 4.0f);
                        this.blockedNow = false;
                        this.blockingEntity = null;
                    }
                } else {
                    this.blockedNow = false;
                    this.blockingEntity = null;
                }
            }
        }
    }

    @Override
    public void onAttackBlocked(HurtEvent.Pre hurtEvent, LivingEntityPatch<?> opponent) {
        ExtendedDamageSource extendedDamageSource;
        DamageSource damageSource = (DamageSource)hurtEvent.getDamageSource();
        if (damageSource instanceof ExtendedDamageSource && (extendedDamageSource = (ExtendedDamageSource)damageSource).getAnimationId() == Animations.WITHER_CHARGE.getId()) {
            if (!this.blockedNow) {
                this.blockedNow = true;
                this.blockingStartTick = ((WitherEntity)this.original).field_70173_aa;
                this.blockingEntity = opponent;
                this.playAnimationSynchronized(Animations.WITHER_BLOCKED, 0.0f);
            }
            --this.blockingCount;
            Vector3d lookAngle = ((LivingEntity)opponent.getOriginal()).func_70040_Z();
            lookAngle = lookAngle.func_178786_a(0.0, lookAngle.field_72448_b, 0.0);
            lookAngle.func_186678_a(0.1);
            Vector3d dest = ((LivingEntity)opponent.getOriginal()).func_213303_ch().func_178787_e(lookAngle);
            ((WitherEntity)this.original).func_70107_b(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        Entity entity;
        DynamicAnimation animation = ((Animator)this.getAnimator()).getPlayerFor(null).getAnimation();
        if ((animation.equals(Animations.WITHER_CHARGE) || animation.equals(Animations.WITHER_BLOCKED)) && (entity = damageSource.func_76364_f()) instanceof AbstractArrowEntity) {
            return new AttackResult(AttackResult.ResultType.FAILED, 0.0f);
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void onDeath() {
        super.onDeath();
        if (!this.isLogicalClient() && ((WitherEntity)this.original).field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            Vector3d startMovement = ((WitherEntity)this.original).func_70040_Z().func_186678_a(0.4).func_72441_c(0.0, 0.63, 0.0);
            DroppedNetherStar itemEntity = new DroppedNetherStar(((WitherEntity)this.original).field_70170_p, ((WitherEntity)this.original).func_213303_ch().func_72441_c(0.0, (double)((WitherEntity)this.original).func_213302_cg() * 0.5, 0.0), startMovement);
            ((WitherEntity)this.original).field_70170_p.func_217376_c((Entity)itemEntity);
        }
    }

    @Override
    public boolean onDrop(LivingDropsEvent event) {
        event.getDrops().removeIf(itemEntity -> itemEntity.func_92059_d().func_77973_b().equals(Items.field_151156_bN));
        return false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float prevYRot;
        if (((WitherEntity)this.original).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((WitherEntity)this.original).func_184187_bx();
            prevYRot = ridingEntity.field_70760_ar;
            yRot = ridingEntity.field_70761_aq;
        } else {
            prevYRot = this.isLogicalClient() ? ((WitherEntity)this.original).field_70760_ar : ((WitherEntity)this.original).field_70126_B;
            yRot = this.isLogicalClient() ? ((WitherEntity)this.original).field_70761_aq : ((WitherEntity)this.original).field_70177_z;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevYRot, yRot, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.wither;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }

    public void startCharging() {
        this.setLastAttackPosition();
        this.blockingCount = 3;
    }

    public void setArmorActivated(boolean set) {
        ((WitherEntity)this.original).func_184212_Q().func_187227_b(DATA_ARMOR_ACTIVED, (Object)set);
    }

    public boolean isArmorActivated() {
        return (Boolean)((WitherEntity)this.original).func_184212_Q().func_187225_a(DATA_ARMOR_ACTIVED);
    }

    public void setGhost(boolean set) {
        ((WitherEntity)this.original).func_184212_Q().func_187227_b(DATA_GHOST, (Object)set);
        ((WitherEntity)this.original).func_189654_d(set);
        this.setTransparency(set ? 40 : -40);
        ((WitherEntity)this.original).func_82142_c(set);
    }

    public boolean isGhost() {
        return (Boolean)((WitherEntity)this.original).func_184212_Q().func_187225_a(DATA_GHOST);
    }

    public void setTransparency(int set) {
        ((WitherEntity)this.original).func_184212_Q().func_187227_b(DATA_TRANSPARENCY, (Object)set);
    }

    public int getTransparency() {
        return (Integer)((WitherEntity)this.original).func_184212_Q().func_187225_a(DATA_TRANSPARENCY);
    }

    public void setLaserTargetPosition(int head, Vector3d pos) {
        ((WitherEntity)this.original).func_184212_Q().func_187227_b(DATA_LASER_TARGET_POSITIONS.get(head), (Object)pos);
    }

    public Vector3d getLaserTargetPosition(int head) {
        return (Vector3d)((WitherEntity)this.original).func_184212_Q().func_187225_a(DATA_LASER_TARGET_POSITIONS.get(head));
    }

    public void setLaserTarget(int head, Entity target) {
        ((WitherEntity)this.original).func_184212_Q().func_187227_b(DATA_LASER_TARGETS.get(head), (Object)(target != null ? target.func_145782_y() : -1));
    }

    public Entity getLaserTargetEntity(int head) {
        int laserTarget = (Integer)((WitherEntity)this.original).func_184212_Q().func_187225_a(DATA_LASER_TARGETS.get(head));
        return laserTarget > 0 ? ((WitherEntity)this.original).field_70170_p.func_73045_a(laserTarget) : null;
    }

    public Entity getAlternativeTargetEntity(int head) {
        int id = ((WitherEntity)this.original).func_82203_t(head);
        return id > 0 ? ((WitherEntity)this.original).field_70170_p.func_73045_a(id) : null;
    }

    public double getHeadX(int index) {
        if (index <= 0) {
            return ((WitherEntity)this.original).func_226277_ct_();
        }
        float f = (((WitherEntity)this.original).field_70177_z + (float)(180 * (index - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return ((WitherEntity)this.original).func_226277_ct_() + (double)f1 * 1.3;
    }

    public double getHeadY(int index) {
        return index <= 0 ? ((WitherEntity)this.original).func_226278_cu_() + 3.0 : ((WitherEntity)this.original).func_226278_cu_() + 2.2;
    }

    public double getHeadZ(int index) {
        if (index <= 0) {
            return ((WitherEntity)this.original).func_226281_cx_();
        }
        float f = (((WitherEntity)this.original).field_70177_z + (float)(180 * (index - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return ((WitherEntity)this.original).func_226281_cx_() + (double)f1 * 1.3;
    }

    public class WitherChasingGoal
    extends Goal {
        public WitherChasingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return ((WitherEntity)WitherPatch.this.original).func_82203_t(0) > 0;
        }

        public void func_75246_d() {
            WitherEntity witherBoss = (WitherEntity)WitherPatch.this.getOriginal();
            Vector3d vec3 = witherBoss.func_213322_ci().func_216372_d(1.0, 0.6, 1.0);
            Entity entity = witherBoss.field_70170_p.func_73045_a(((WitherEntity)WitherPatch.this.original).func_82203_t(0));
            if (!WitherPatch.this.getEntityState().hurt() && !WitherPatch.this.blockedNow) {
                if (entity != null) {
                    double followingRange;
                    Vector3d vec31 = new Vector3d(entity.func_226277_ct_() - witherBoss.func_226277_ct_(), 0.0, entity.func_226281_cx_() - witherBoss.func_226281_cx_());
                    double d0 = vec3.field_72448_b;
                    if (witherBoss.func_226278_cu_() < entity.func_226278_cu_() || !witherBoss.func_225509_J__() && witherBoss.func_226278_cu_() < entity.func_226278_cu_() + 5.0 && !((Animator)WitherPatch.this.getAnimator()).getPlayerFor(null).getAnimation().getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false).booleanValue()) {
                        d0 = Math.max(0.0, d0);
                        d0 += 0.3 - d0 * (double)0.6f;
                    }
                    vec3 = new Vector3d(vec3.field_72450_a, d0, vec3.field_72449_c);
                    double d = followingRange = witherBoss.func_225509_J__() ? 9.0 : 49.0;
                    if (MathUtils.horizontalDistanceSqr(vec31) > followingRange && !WitherPatch.this.getEntityState().inaction()) {
                        Vector3d vec32 = vec31.func_72432_b();
                        vec3 = vec3.func_72441_c(vec32.field_72450_a * 0.3 - vec3.field_72450_a * 0.6, 0.0, vec32.field_72449_c * 0.3 - vec3.field_72449_c * 0.6);
                    }
                }
                witherBoss.func_213317_d(vec3);
            }
        }
    }

    public class WitherGhostAttackGoal
    extends Goal {
        private int ghostSummonCount;
        private int maxGhostSpawn;
        private int summonInverval;
        private int cooldown;

        public WitherGhostAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return --this.cooldown < 0 && WitherPatch.this.isArmorActivated() && !WitherPatch.this.getEntityState().inaction() && ((WitherEntity)WitherPatch.this.original).func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return this.ghostSummonCount <= this.maxGhostSpawn;
        }

        public void func_75249_e() {
            WitherPatch.this.playAnimationSynchronized(Animations.WITHER_GHOST_STANDBY, 0.0f);
            WitherPatch.this.updateEntityState();
            WitherPatch.this.setGhost(true);
            List<LivingEntity> nearbyEnemies = this.getNearbyTargets();
            this.ghostSummonCount = 0;
            this.summonInverval = 25;
            this.maxGhostSpawn = MathHelper.func_76125_a((int)(nearbyEnemies.size() / 2), (int)2, (int)4);
        }

        public void func_75246_d() {
            if (--this.summonInverval <= 0) {
                LivingEntity target;
                if (this.ghostSummonCount < this.maxGhostSpawn) {
                    List<LivingEntity> nearbyEnemies = this.getNearbyTargets();
                    if (nearbyEnemies.size() > 0) {
                        LivingEntity randomTarget = nearbyEnemies.get(((WitherEntity)WitherPatch.this.original).func_70681_au().nextInt(nearbyEnemies.size()));
                        Vector3d summonPosition = randomTarget.func_213303_ch().func_178787_e(new Vector3d(0.0, 0.0, 6.0).func_178785_b(((WitherEntity)WitherPatch.this.original).func_70681_au().nextFloat() * 360.0f));
                        WitherGhostClone ghostclone = new WitherGhostClone((ServerWorld)((WitherEntity)((WitherPatch)WitherPatch.this).original).field_70170_p, summonPosition, randomTarget);
                        ((WitherEntity)((WitherPatch)WitherPatch.this).original).field_70170_p.func_217376_c((Entity)ghostclone);
                    } else {
                        this.ghostSummonCount = this.maxGhostSpawn + 1;
                    }
                }
                ++this.ghostSummonCount;
                int n = this.summonInverval = this.ghostSummonCount < this.maxGhostSpawn ? 25 : 35;
                if (this.ghostSummonCount == this.maxGhostSpawn && (target = ((WitherEntity)WitherPatch.this.original).func_70638_az()) != null) {
                    Vector3d summonPosition = target.func_213303_ch().func_178787_e(new Vector3d(0.0, 0.0, 6.0).func_178785_b(((WitherEntity)WitherPatch.this.original).func_70681_au().nextFloat() * 360.0f)).func_72441_c(0.0, 5.0, 0.0);
                    ((WitherEntity)WitherPatch.this.original).func_70107_b(summonPosition.field_72450_a, summonPosition.field_72448_b, summonPosition.field_72449_c);
                    ((WitherEntity)WitherPatch.this.original).func_200602_a(EntityAnchorArgument.Type.FEET, ((WitherEntity)WitherPatch.this.original).func_70638_az().func_213303_ch());
                }
            }
        }

        public void func_75251_c() {
            this.cooldown = 300;
            if (((WitherEntity)WitherPatch.this.original).func_70638_az() != null) {
                WitherPatch.this.playSound(SoundEvents.field_187925_gy, -0.1f, 0.1f);
                WitherPatch.this.playAnimationSynchronized(Animations.WITHER_CHARGE, 0.0f);
            } else {
                WitherPatch.this.playAnimationSynchronized(Animations.OFF_ANIMATION_HIGHEST, 0.0f);
            }
            WitherPatch.this.setGhost(false);
        }

        public List<LivingEntity> getNearbyTargets() {
            return ((WitherEntity)((WitherPatch)WitherPatch.this).original).field_70170_p.func_217374_a(LivingEntity.class, WTIHER_GHOST_TARGETING_CONDITIONS, (LivingEntity)WitherPatch.this.original, ((WitherEntity)WitherPatch.this.original).func_174813_aQ().func_72314_b(20.0, 5.0, 20.0));
        }
    }
}

