/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Region;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonFlyingPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class DragonGroundBattlePhase
extends PatchedDragonPhase {
    private List<PlayerEntity> recognizedPlayers = Lists.newArrayList();
    private PathFinder pathFinder;
    private int aggroCounter;
    private int noPathWarningCounter;
    CombatBehaviors<EnderDragonPatch> combatBehaviors;

    public DragonGroundBattlePhase(EnderDragonEntity dragon) {
        super(dragon);
        if (!dragon.field_70170_p.func_201670_d()) {
            this.combatBehaviors = MobCombatBehaviors.ENDER_DRAGON.build(this.dragonpatch);
            WalkNodeProcessor nodeEvaluator = new WalkNodeProcessor();
            nodeEvaluator.func_186317_a(true);
            this.pathFinder = new PathFinder((NodeProcessor)nodeEvaluator, 100);
        }
    }

    public void func_188660_d() {
        this.dragonpatch.setGroundPhase();
    }

    public void func_188659_c() {
        LivingEntity target = this.field_188661_a.func_70638_az();
        if (target != null) {
            if (this.isValidTarget(target) && DragonGroundBattlePhase.isInEndSpikes(target)) {
                EntityState state = this.dragonpatch.getEntityState();
                this.combatBehaviors.tick();
                --this.aggroCounter;
                if (this.combatBehaviors.hasActivatedMove()) {
                    CombatBehaviors.Behavior<EnderDragonPatch> result;
                    if (state.canBasicAttack() && (result = this.combatBehaviors.tryProceed()) != null) {
                        result.execute(this.dragonpatch);
                    }
                } else if (!state.inaction()) {
                    CombatBehaviors.Behavior<EnderDragonPatch> result = this.combatBehaviors.selectRandomBehaviorSeries();
                    if (result != null) {
                        result.execute(this.dragonpatch);
                    } else {
                        if (this.field_188661_a.field_70173_aa % 20 == 0) {
                            if (!this.checkTargetPath(target)) {
                                if (this.noPathWarningCounter++ >= 3) {
                                    this.fly();
                                }
                            } else {
                                this.noPathWarningCounter = 0;
                            }
                        }
                        double dx = target.func_226277_ct_() - this.field_188661_a.func_226277_ct_();
                        double dz = target.func_226281_cx_() - this.field_188661_a.func_226281_cx_();
                        float yRot = 180.0f - (float)Math.toDegrees(MathHelper.func_181159_b((double)dx, (double)dz));
                        this.field_188661_a.field_70177_z = MathUtils.rotlerp(this.field_188661_a.field_70177_z, yRot, 6.0f);
                        Vector3d forward = Vector3d.func_189984_a((Vector2f)this.field_188661_a.func_189653_aC()).func_186678_a(-0.25);
                        this.field_188661_a.func_213315_a(MoverType.SELF, forward);
                    }
                } else if (this.aggroCounter < 0) {
                    this.aggroCounter = 200;
                    this.searchNearestTarget();
                }
            } else if (!this.dragonpatch.getEntityState().inaction()) {
                this.searchNearestTarget();
            }
        } else {
            this.searchNearestTarget();
            if (this.field_188661_a.func_70638_az() == null && !this.dragonpatch.getEntityState().inaction()) {
                this.dragonpatch.playAnimationSynchronized(Animations.DRAGON_GROUND_TO_FLY, 0.0f);
                this.field_188661_a.func_184670_cT().func_188758_a(PatchedPhases.FLYING);
                ((DragonFlyingPhase)this.field_188661_a.func_184670_cT().func_188756_a()).enableAirstrike();
            }
        }
    }

    public float func_221113_a(DamageSource damagesource, float amount) {
        if (damagesource.func_76352_a()) {
            if (damagesource.func_76364_f() instanceof AbstractArrowEntity) {
                damagesource.func_76364_f().func_70015_d(1);
            }
            return 0.0f;
        }
        if (damagesource instanceof EntityDamageSource && !(damagesource instanceof ExtendedDamageSource)) {
            return 0.0f;
        }
        return super.func_221113_a(damagesource, amount);
    }

    private void refreshNearbyPlayers(double within) {
        this.recognizedPlayers.clear();
        this.recognizedPlayers.addAll(this.getPlayersNearbyWithin(within));
    }

    private boolean checkTargetPath(LivingEntity target) {
        BlockPos blockpos = this.field_188661_a.func_233580_cy_();
        while (this.field_188661_a.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c()) {
            blockpos = blockpos.func_177984_a();
        }
        while (!this.field_188661_a.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_185904_a().func_76230_c()) {
            blockpos = blockpos.func_177977_b();
        }
        int sight = 60;
        Region pathnavigationregion = new Region(this.field_188661_a.field_70170_p, blockpos.func_177982_a(-sight, -sight, -sight), blockpos.func_177982_a(sight, sight, sight));
        Path path = this.pathFinder.func_227478_a_(pathnavigationregion, (MobEntity)this.field_188661_a, (Set)ImmutableSet.of((Object)target.func_233580_cy_()), (float)sight, 0, 1.0f);
        BlockPos pathEnd = path.func_75877_a(path.func_75874_d() - 1).func_224759_a();
        BlockPos targetPos = path.func_224770_k();
        double xd = Math.abs(pathEnd.func_177958_n() - targetPos.func_177958_n());
        double yd = Math.abs(pathEnd.func_177956_o() - targetPos.func_177956_o());
        double zd = Math.abs(pathEnd.func_177952_p() - targetPos.func_177952_p());
        return xd < (double)this.field_188661_a.func_213311_cf() && yd < (double)this.field_188661_a.func_213302_cg() && zd < (double)this.field_188661_a.func_213311_cf();
    }

    private void searchNearestTarget() {
        this.refreshNearbyPlayers(60.0);
        if (this.recognizedPlayers.size() > 0) {
            int nearestPlayerIndex = 0;
            double nearestDistance = this.recognizedPlayers.get(0).func_70068_e((Entity)this.field_188661_a);
            for (int i = 1; i < this.recognizedPlayers.size(); ++i) {
                double distance = this.recognizedPlayers.get(i).func_70068_e((Entity)this.field_188661_a);
                if (!(distance < nearestDistance)) continue;
                nearestPlayerIndex = i;
                nearestDistance = distance;
            }
            PlayerEntity nearestPlayer = this.recognizedPlayers.get(nearestPlayerIndex);
            if (this.isValidTarget((LivingEntity)nearestPlayer) && DragonGroundBattlePhase.isInEndSpikes((LivingEntity)nearestPlayer)) {
                this.dragonpatch.setAttakTargetSync((LivingEntity)nearestPlayer);
                return;
            }
        }
        this.dragonpatch.setAttakTargetSync(null);
    }

    public void fly() {
        this.combatBehaviors.execute(6);
    }

    public void resetFlyCooldown() {
        this.combatBehaviors.resetCooldown(6, false);
    }

    public boolean func_188654_a() {
        return true;
    }

    public PhaseType<? extends IPhase> func_188652_i() {
        return PatchedPhases.GROUND_BATTLE;
    }
}

