/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.Heightmap;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonGroundBattlePhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;

public class DragonLandingPhase
extends PatchedDragonPhase {
    private final BlockPos[] landingCandidates = new BlockPos[3];
    private Vector3d landingPosition;
    private boolean actualLandingPhase;

    public DragonLandingPhase(EnderDragonEntity enderdragon) {
        super(enderdragon);
        this.landingCandidates[0] = enderdragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(-3, 0, -11));
        this.landingCandidates[1] = enderdragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(17, 0, 0));
        this.landingCandidates[2] = enderdragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(0, 0, 17));
    }

    public void func_188660_d() {
        this.actualLandingPhase = false;
        this.landingPosition = this.getFarthestLandingPosition();
        if (!this.dragonpatch.isLogicalClient()) {
            ((DragonGroundBattlePhase)((EnderDragonEntity)this.dragonpatch.getOriginal()).func_184670_cT().func_188757_b(PatchedPhases.GROUND_BATTLE)).resetFlyCooldown();
        }
    }

    public Vector3d getFarthestLandingPosition() {
        double max = 0.0;
        Vector3d result = null;
        for (int i = 0; i < this.landingCandidates.length; ++i) {
            Vector3d vec3d = new Vector3d((double)this.landingCandidates[i].func_177958_n(), (double)this.landingCandidates[i].func_177956_o(), (double)this.landingCandidates[i].func_177952_p());
            double distanceSqr = vec3d.func_72436_e(this.field_188661_a.func_213303_ch());
            if (!(distanceSqr > max)) continue;
            max = distanceSqr;
            result = vec3d;
        }
        return result;
    }

    public void func_188659_c() {
        double dx = this.landingPosition.field_72450_a - this.field_188661_a.func_226277_ct_();
        double dy = this.landingPosition.field_72448_b - this.field_188661_a.func_226278_cu_();
        double dz = this.landingPosition.field_72449_c - this.field_188661_a.func_226281_cx_();
        double squaredD = dx * dx + dy * dy + dz * dz;
        double squaredHorizontalD = dx * dx + dz * dz;
        if (this.actualLandingPhase) {
            if (squaredHorizontalD < 50.0) {
                this.field_188661_a.func_184670_cT().func_188758_a(PatchedPhases.GROUND_BATTLE);
            }
        } else {
            float f5 = this.func_188651_f();
            double horizontalD = Math.sqrt(squaredHorizontalD);
            double yMove = dy;
            if (horizontalD > 0.0) {
                yMove = MathHelper.func_151237_a((double)dy, (double)(-f5), (double)f5) * MathHelper.func_151237_a((double)((Math.abs(dy) - 13.0) * 0.01), (double)0.01, (double)0.03);
            }
            this.field_188661_a.func_213317_d(this.field_188661_a.func_213322_ci().func_72441_c(0.0, yMove, 0.0));
            this.field_188661_a.field_70177_z = MathHelper.func_76142_g((float)this.field_188661_a.field_70177_z);
            Vector3d vec32 = this.landingPosition.func_178786_a(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_()).func_72432_b();
            Vector3d vec33 = new Vector3d((double)MathHelper.func_76126_a((float)(this.field_188661_a.field_70177_z * ((float)Math.PI / 180))), this.field_188661_a.func_213322_ci().field_72448_b, (double)(-MathHelper.func_76134_b((float)(this.field_188661_a.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
            float f6 = Math.max(((float)vec33.func_72430_b(vec32) + 0.5f) / 1.5f, 0.0f);
            if (Math.abs(dx) > (double)1.0E-5f || Math.abs(dz) > (double)1.0E-5f) {
                double d5 = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)dx, (double)dz) * 57.2957763671875 - (double)this.field_188661_a.field_70177_z)), (double)-50.0, (double)50.0);
                this.field_188661_a.field_226525_bB_ *= 0.8f;
                this.field_188661_a.field_226525_bB_ = (float)((double)this.field_188661_a.field_226525_bB_ + d5 * (double)this.func_188653_h());
                this.field_188661_a.field_70177_z += this.field_188661_a.field_226525_bB_ * 0.1f;
            }
            float f18 = (float)(2.0 / (squaredD + 1.0));
            this.field_188661_a.func_213309_a(0.06f * (f6 * f18 + (1.0f - f18)), new Vector3d(0.0, 0.0, -1.0));
            if (this.field_188661_a.field_70994_bF) {
                this.field_188661_a.func_213315_a(MoverType.SELF, this.field_188661_a.func_213322_ci().func_186678_a((double)0.8f));
            } else {
                this.field_188661_a.func_213315_a(MoverType.SELF, this.field_188661_a.func_213322_ci());
            }
            Vector3d vec34 = this.field_188661_a.func_213322_ci().func_72432_b();
            double d6 = 0.8 + 0.15 * (vec34.func_72430_b(vec33) + 1.0) / 2.0;
            this.field_188661_a.func_213317_d(this.field_188661_a.func_213322_ci().func_216372_d(d6, (double)0.91f, d6));
            if (squaredD < 400.0 && Math.abs(dy) < 14.0) {
                Vector3d vector3d = new Vector3d(dx, 0.0, dz);
                Vector2f vector2f = new Vector2f(0.0f, 180.0f + this.field_188661_a.field_70177_z);
                if (vector3d.func_72432_b().func_72430_b(Vector3d.func_189984_a((Vector2f)vector2f)) > 0.95) {
                    this.dragonpatch.playAnimationSynchronized(Animations.DRAGON_FLY_TO_GROUND, 0.0f);
                    this.actualLandingPhase = true;
                }
            }
        }
    }

    public Vector3d getLandingPosition() {
        return this.landingPosition;
    }

    public PhaseType<DragonLandingPhase> func_188652_i() {
        return PatchedPhases.LANDING;
    }
}

