/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonAirstrikePhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonCrystalLinkPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PhaseManagerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class EnderDragonPatch
extends MobPatch<EnderDragonEntity> {
    public static final EntityPredicate DRAGON_TARGETING = new EntityPredicate().func_221013_a(64.0).func_221010_e();
    public static EnderDragonPatch INSTANCE_CLIENT;
    public static EnderDragonPatch INSTANCE_SERVER;
    private Map<String, TipPointAnimation> tipPointAnimations = Maps.newHashMap();
    private Map<LivingMotions, StaticAnimation> livingMotions = Maps.newHashMap();
    private boolean groundPhase;
    public float xRoot;
    public float xRootO;
    public float zRoot;
    public float zRootO;
    public LivingMotion prevMotion = LivingMotions.FLY;

    @Override
    public void onConstructed(EnderDragonEntity entityIn) {
        this.livingMotions.put(LivingMotions.IDLE, Animations.DRAGON_IDLE);
        this.livingMotions.put(LivingMotions.WALK, Animations.DRAGON_WALK);
        this.livingMotions.put(LivingMotions.FLY, Animations.DRAGON_FLY);
        this.livingMotions.put(LivingMotions.CHASE, Animations.DRAGON_AIRSTRIKE);
        this.livingMotions.put(LivingMotions.DEATH, Animations.DRAGON_DEATH);
        super.onConstructed(entityIn);
        this.currentLivingMotion = LivingMotions.FLY;
    }

    @Override
    public void onJoinWorld(EnderDragonEntity entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        IPhase currentPhase = ((EnderDragonEntity)this.original).field_184677_bJ.func_188756_a();
        PhaseType startPhase = currentPhase == null || !(currentPhase instanceof PatchedDragonPhase) ? PatchedPhases.FLYING : ((EnderDragonEntity)this.original).field_184677_bJ.func_188756_a().func_188652_i();
        ((EnderDragonEntity)this.original).field_184677_bJ = new PhaseManagerPatch((EnderDragonEntity)this.original, this);
        ((EnderDragonEntity)this.original).field_184677_bJ.func_188758_a(startPhase);
        entityIn.field_70138_W = 1.0f;
        if (entityIn.field_70170_p.func_201670_d()) {
            INSTANCE_CLIENT = this;
        } else {
            INSTANCE_SERVER = this;
        }
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EnderDragonEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(8.0);
        ((EnderDragonEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111128_a(Double.MAX_VALUE);
        ((EnderDragonEntity)this.original).func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        for (Map.Entry<LivingMotions, StaticAnimation> livingmotionEntry : this.livingMotions.entrySet()) {
            clientAnimator.addLivingAnimation(livingmotionEntry.getKey(), livingmotionEntry.getValue());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((EnderDragonEntity)this.original).func_110143_aJ() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        } else {
            IPhase phase = ((EnderDragonEntity)this.original).func_184670_cT().func_188756_a();
            this.currentLivingMotion = !this.groundPhase ? (phase.func_188652_i() == PatchedPhases.AIRSTRIKE && ((DragonAirstrikePhase)phase).isActuallyAttacking() ? LivingMotions.CHASE : LivingMotions.FLY) : (phase.func_188652_i() == PatchedPhases.GROUND_BATTLE ? (((EnderDragonEntity)this.original).func_70638_az() != null ? LivingMotions.WALK : LivingMotions.IDLE) : LivingMotions.IDLE);
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        super.tick(event);
        if (((EnderDragonEntity)this.original).func_184670_cT().func_188756_a().func_188654_a()) {
            ((EnderDragonEntity)this.original).field_70992_bH = null;
        }
    }

    @Override
    public void serverTick(LivingEvent.LivingUpdateEvent event) {
        super.serverTick(event);
        ((EnderDragonEntity)this.original).field_70737_aN = 2;
        ((EnderDragonEntity)this.original).func_70635_at().func_75523_a();
        this.updateMotion(true);
        if (this.prevMotion != this.currentLivingMotion && !this.animator.getEntityState().inaction()) {
            if (this.livingMotions.containsKey(this.currentLivingMotion)) {
                this.animator.playAnimation(this.livingMotions.get(this.currentLivingMotion), 0.0f);
            }
            this.prevMotion = this.currentLivingMotion;
        }
        this.updateTipPoints();
        PartEntity bodyPart = ((EnderDragonEntity)this.original).getParts()[2];
        AxisAlignedBB bodyBoundingBox = bodyPart.func_174813_aQ();
        List list = ((EnderDragonEntity)this.original).field_70170_p.func_72839_b(this.original, bodyBoundingBox);
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                double d1;
                Entity entity = (Entity)list.get(l);
                double d0 = entity.func_226277_ct_() - ((EnderDragonEntity)this.original).func_226277_ct_();
                double d2 = MathHelper.func_76132_a((double)d0, (double)(d1 = entity.func_226281_cx_() - ((EnderDragonEntity)this.original).func_226281_cx_()));
                if (!(d2 >= 0.01)) continue;
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 = d0 * d3 * 0.2;
                d1 = d1 * d3 * 0.2;
                if (entity.func_184207_aI()) continue;
                entity.func_70024_g(d0, 0.0, d1);
                entity.field_70133_I = true;
            }
        }
    }

    @Override
    public void clientTick(LivingEvent.LivingUpdateEvent event) {
        this.xRootO = this.xRoot;
        this.zRootO = this.zRoot;
        super.clientTick(event);
        this.updateTipPoints();
    }

    @Override
    public void setStunShield(float value) {
        IPhase currentPhase;
        super.setStunShield(value);
        if (value <= 0.0f && (currentPhase = ((EnderDragonEntity)this.original).func_184670_cT().func_188756_a()).func_188652_i() == PatchedPhases.CRYSTAL_LINK && ((DragonCrystalLinkPhase)currentPhase).getChargingCount() > 0) {
            ((EnderDragonEntity)this.original).func_184185_a(EpicFightSounds.NEUTRALIZE_BOSSES, 5.0f, 1.0f);
            ((EnderDragonEntity)this.original).func_184670_cT().func_188758_a(PatchedPhases.NEUTRALIZED);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        return super.tryHurt(damageSource, ((EnderDragonEntity)this.original).func_184670_cT().func_188756_a().func_188652_i() == PatchedPhases.CRYSTAL_LINK ? 0.0f : amount);
    }

    @Override
    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.func_226277_ct_() - ((EnderDragonEntity)this.original).func_226277_ct_();
        double d1 = target.func_226281_cx_() - ((EnderDragonEntity)this.original).func_226281_cx_();
        float degree = 180.0f - (float)Math.toDegrees(MathHelper.func_181159_b((double)d0, (double)d1));
        this.rotateTo(degree, limit, partialSync);
    }

    public void updateTipPoints() {
        for (Map.Entry<String, TipPointAnimation> entry : this.tipPointAnimations.entrySet()) {
            if (!entry.getValue().isOnWorking()) continue;
            entry.getValue().tick();
        }
        if (this.tipPointAnimations.size() > 0) {
            TipPointAnimation frontL = this.getTipPointAnimation("Leg_Front_L3");
            TipPointAnimation frontR = this.getTipPointAnimation("Leg_Front_R3");
            TipPointAnimation backL = this.getTipPointAnimation("Leg_Back_L3");
            TipPointAnimation backR = this.getTipPointAnimation("Leg_Back_R3");
            float entityPosY = (float)((EnderDragonEntity)this.original).func_213303_ch().field_72448_b;
            float yFrontL = frontL != null && frontL.isTouchingGround() ? frontL.getTargetPosition().y : entityPosY;
            float yFrontR = frontR != null && frontR.isTouchingGround() ? frontR.getTargetPosition().y : entityPosY;
            float yBackL = backL != null && backL.isTouchingGround() ? backL.getTargetPosition().y : entityPosY;
            float yBackR = backR != null && backR.isTouchingGround() ? backR.getTargetPosition().y : entityPosY;
            float xdiff = (yFrontL + yBackL) * 0.5f - (yFrontR + yBackR) * 0.5f;
            float zdiff = (yFrontL + yFrontR) * 0.5f - (yBackL + yBackR) * 0.5f;
            float xdistance = 4.0f;
            float zdistance = 5.7f;
            this.xRoot += MathHelper.func_76131_a((float)((float)Math.toDegrees(Math.atan2(zdiff, zdistance)) - this.xRoot), (float)-1.0f, (float)1.0f);
            this.zRoot += MathHelper.func_76131_a((float)((float)Math.toDegrees(Math.atan2(xdiff, xdistance)) - this.zRoot), (float)-1.0f, (float)1.0f);
            float averageY = (yFrontL + yFrontR + yBackL + yBackR) * 0.25f;
            if (!this.isLogicalClient()) {
                float dy = averageY - entityPosY;
                ((EnderDragonEntity)this.original).func_213315_a(MoverType.SELF, new Vector3d(0.0, (double)dy, 0.0));
            }
        }
    }

    public void resetTipAnimations() {
        this.tipPointAnimations.clear();
    }

    public void setFlyingPhase() {
        this.groundPhase = false;
        ((EnderDragonEntity)this.original).field_70123_F = false;
        ((EnderDragonEntity)this.original).field_70124_G = false;
    }

    public void setGroundPhase() {
        this.groundPhase = true;
    }

    public boolean isGroundPhase() {
        return this.groundPhase;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return EpicFightSounds.WHOOSH_BIG;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.dragon;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((EnderDragonEntity)this.original).field_70126_B, ((EnderDragonEntity)this.original).field_70177_z, partialTicks, -1.0f, 1.0f, -1.0f);
    }

    @Override
    public double getAngleTo(Entity entityIn) {
        Vector3d a = ((EnderDragonEntity)this.original).func_70040_Z().func_186678_a(-1.0);
        Vector3d b = new Vector3d(entityIn.func_226277_ct_() - ((EnderDragonEntity)this.original).func_226277_ct_(), entityIn.func_226278_cu_() - ((EnderDragonEntity)this.original).func_226278_cu_(), entityIn.func_226281_cx_() - ((EnderDragonEntity)this.original).func_226281_cx_()).func_72432_b();
        double cosTheta = a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
        return Math.toDegrees(Math.acos(cosTheta));
    }

    @Override
    public double getAngleToHorizontal(Entity entityIn) {
        Vector3d a = ((EnderDragonEntity)this.original).func_70040_Z().func_186678_a(-1.0);
        Vector3d b = new Vector3d(entityIn.func_226277_ct_() - ((EnderDragonEntity)this.original).func_226277_ct_(), 0.0, entityIn.func_226281_cx_() - ((EnderDragonEntity)this.original).func_226281_cx_()).func_72432_b();
        double cos = a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
        return Math.toDegrees(Math.acos(cos));
    }

    public TipPointAnimation getTipPointAnimation(String jointName) {
        return this.tipPointAnimations.get(jointName);
    }

    public void addTipPointAnimation(String jointName, Vec3f initpos, TransformSheet transformSheet, IKInfo ikSetter) {
        this.tipPointAnimations.put(jointName, new TipPointAnimation(transformSheet, initpos, ikSetter));
    }

    public Collection<TipPointAnimation> getTipPointAnimations() {
        return this.tipPointAnimations.values();
    }
}

