/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPSpawnData;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviorGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class EndermanPatch
extends MobPatch<EndermanEntity> {
    private static final UUID SPEED_MODIFIER_RAGE_UUID = UUID.fromString("dc362d1a-8424-11ec-a8a3-0242ac120002");
    private static final AttributeModifier SPEED_MODIFIER_RAGE = new AttributeModifier(SPEED_MODIFIER_RAGE_UUID, "Rage speed bonus", 0.1, AttributeModifier.Operation.ADDITION);
    private int deathTimerExt = 0;
    private boolean onRage;
    private Goal normalAttacks;
    private Goal teleportAttacks;
    private Goal rageAttacks;
    private Goal rageTargeting;

    public EndermanPatch() {
        super(Faction.ENDERMAN);
    }

    @Override
    public void onJoinWorld(EndermanEntity enderman, EntityJoinWorldEvent event) {
        if (enderman.field_70170_p.func_234923_W_() == World.field_234920_i_ && MathUtils.horizontalDistanceSqr(enderman.func_213303_ch()) < 40000.0) {
            event.setCanceled(true);
        }
        super.onJoinWorld(enderman, event);
    }

    @Override
    public void onStartTracking(ServerPlayerEntity trackingPlayer) {
        if (this.isRaging()) {
            SPSpawnData packet = new SPSpawnData(((EndermanEntity)this.original).func_145782_y());
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer);
        }
    }

    @Override
    public void processSpawnData(ByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
        animator.setCurrentMotionsAsDefault();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EndermanEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.STUN_ARMOR.get()).func_111128_a(8.0);
        ((EndermanEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a((double)1.8f);
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN.build(this));
        this.teleportAttacks = new EndermanTeleportMove(this, MobCombatBehaviors.ENDERMAN_TELEPORT.build(this));
        this.rageAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN_RAGE.build(this));
        this.rageTargeting = new NearestAttackableTargetGoal((MobEntity)this.original, PlayerEntity.class, true);
        ((EndermanEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.getOriginal(), 0.75, false));
        if (this.isRaging()) {
            ((EndermanEntity)this.original).field_70715_bh.func_75776_a(3, this.rageTargeting);
            ((EndermanEntity)this.original).field_70714_bg.func_75776_a(1, this.rageAttacks);
        } else {
            ((EndermanEntity)this.original).field_70714_bg.func_75776_a(1, this.normalAttacks);
            ((EndermanEntity)this.original).field_70714_bg.func_75776_a(0, this.teleportAttacks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.ENDERMAN_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_IDLE);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public void serverTick(LivingEvent.LivingUpdateEvent event) {
        super.serverTick(event);
        if (this.isRaging() && !this.onRage && ((EndermanEntity)this.original).field_70173_aa > 5) {
            this.toRaging();
        } else if (this.onRage && !this.isRaging()) {
            this.toNormal();
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        if (((EndermanEntity)this.original).func_110143_aJ() <= 0.0f) {
            ((EndermanEntity)this.original).field_70125_A = 0.0f;
            if (((EndermanEntity)this.original).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((EndermanEntity)this.original).field_70725_aQ;
            }
        }
        super.tick(event);
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (!((EndermanEntity)this.original).field_70170_p.func_201670_d() && damageSource instanceof EntityDamageSource && !this.isRaging()) {
            ExtendedDamageSource extDamageSource = null;
            if (damageSource instanceof ExtendedDamageSource) {
                extDamageSource = (ExtendedDamageSource)damageSource;
            }
            if (extDamageSource == null || extDamageSource.getStunType() != ExtendedDamageSource.StunType.HOLD) {
                int percentage;
                int n = percentage = this.getServerAnimator().getPlayerFor(null).getAnimation() instanceof AttackAnimation ? 10 : 3;
                if (((EndermanEntity)this.original).func_70681_au().nextInt(percentage) == 0) {
                    for (int i = 0; i < 9; ++i) {
                        if (!((EndermanEntity)this.original).func_70820_n()) continue;
                        if (damageSource.func_76346_g() instanceof LivingEntity) {
                            ((EndermanEntity)this.original).func_70604_c((LivingEntity)damageSource.func_76346_g());
                        }
                        if (this.state.inaction()) {
                            this.playAnimationSynchronized(Animations.ENDERMAN_TP_EMERGENCE, 0.0f);
                        }
                        return new AttackResult(AttackResult.ResultType.FAILED, amount);
                    }
                }
            }
        }
        return super.tryHurt(damageSource, amount);
    }

    public boolean isRaging() {
        return ((EndermanEntity)this.original).func_110143_aJ() / ((EndermanEntity)this.original).func_110138_aP() < 0.33f;
    }

    protected void toRaging() {
        this.onRage = true;
        this.playAnimationSynchronized(Animations.ENDERMAN_CONVERT_RAGE, 0.0f);
        if (!((EndermanEntity)this.original).func_175446_cd()) {
            ((EndermanEntity)this.original).field_70714_bg.func_85156_a(this.normalAttacks);
            ((EndermanEntity)this.original).field_70714_bg.func_85156_a(this.teleportAttacks);
            ((EndermanEntity)this.original).field_70714_bg.func_75776_a(1, this.rageAttacks);
            ((EndermanEntity)this.original).field_70715_bh.func_75776_a(3, this.rageTargeting);
            ((EndermanEntity)this.original).func_184212_Q().func_187227_b(EndermanEntity.field_184719_bw, (Object)true);
            ((EndermanEntity)this.original).func_195064_c(new EffectInstance((Effect)EpicFightMobEffects.STUN_IMMUNITY.get(), 120000));
            ((EndermanEntity)this.original).func_110148_a(Attributes.field_233821_d_).func_233767_b_(SPEED_MODIFIER_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EndermanEntity)this.original).func_145782_y(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original);
        }
    }

    protected void toNormal() {
        this.onRage = false;
        if (!((EndermanEntity)this.original).func_175446_cd()) {
            ((EndermanEntity)this.original).field_70714_bg.func_75776_a(1, this.normalAttacks);
            ((EndermanEntity)this.original).field_70714_bg.func_75776_a(0, this.teleportAttacks);
            ((EndermanEntity)this.original).field_70714_bg.func_85156_a(this.rageAttacks);
            ((EndermanEntity)this.original).field_70715_bh.func_85156_a(this.rageTargeting);
            if (((EndermanEntity)this.original).func_70638_az() == null) {
                ((EndermanEntity)this.original).func_184212_Q().func_187227_b(EndermanEntity.field_184719_bw, (Object)false);
            }
            ((EndermanEntity)this.original).func_195063_d((Effect)EpicFightMobEffects.STUN_IMMUNITY.get());
            ((EndermanEntity)this.original).func_110148_a(Attributes.field_233821_d_).func_111124_b(SPEED_MODIFIER_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EndermanEntity)this.original).func_145782_y(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original);
        }
    }

    @Override
    public void aboutToDeath() {
        ((EndermanEntity)this.original).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        if (this.isLogicalClient()) {
            for (int i = 0; i < 100; ++i) {
                Random rand = ((EndermanEntity)this.original).func_70681_au();
                Vec3f vec = new Vec3f(rand.nextInt(), rand.nextInt(), rand.nextInt());
                vec.normalise().scale(0.5f);
                Minecraft minecraft = Minecraft.func_71410_x();
                minecraft.field_71452_i.func_199280_a((IParticleData)EpicFightParticles.ENDERMAN_DEATH_EMIT.get(), ((EndermanEntity)this.original).func_226277_ct_(), ((EndermanEntity)this.original).func_226278_cu_() + (double)(((EndermanEntity)this.original).func_213305_a((Pose)Pose.STANDING).field_220316_b / 2.0f), ((EndermanEntity)this.original).func_226281_cx_(), (double)vec.x, (double)vec.y, (double)vec.z);
            }
        }
        super.aboutToDeath();
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        if (stunType == ExtendedDamageSource.StunType.LONG) {
            return Animations.ENDERMAN_HIT_LONG;
        }
        return Animations.ENDERMAN_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.enderman;
    }

    static class EndermanTeleportMove
    extends CombatBehaviorGoal<EndermanPatch> {
        private int waitingCounter;
        private int delayCounter;
        private CombatBehaviors.Behavior<EndermanPatch> move;

        public EndermanTeleportMove(EndermanPatch mobpatch, CombatBehaviors<EndermanPatch> mobAttacks) {
            super(mobpatch, mobAttacks);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            this.combatBehaviors.tick();
            if (super.func_75250_a()) {
                this.move = this.combatBehaviors.selectRandomBehaviorSeries();
                return this.move != null;
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            boolean waitExpired;
            boolean bl = waitExpired = this.waitingCounter <= 100;
            if (!waitExpired) {
                this.waitingCounter = 500;
            }
            return this.isValidTarget(this.mob.func_70638_az()) && !((EndermanPatch)this.mobpatch).getEntityState().hurt() && !((EndermanPatch)this.mobpatch).getEntityState().inaction() && waitExpired;
        }

        public void func_75249_e() {
            this.delayCounter = 20 + this.mob.func_70681_au().nextInt(5);
            this.waitingCounter = 0;
        }

        public void func_75251_c() {
            this.move = null;
        }

        @Override
        public void func_75246_d() {
            LivingEntity target = this.mob.func_70638_az();
            this.mob.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- < 0 && !((EndermanPatch)this.mobpatch).getEntityState().inaction()) {
                Vec3f vec = new Vec3f((float)(this.mob.func_226277_ct_() - target.func_226277_ct_()), 0.0f, (float)(this.mob.func_226281_cx_() - target.func_226281_cx_()));
                vec.normalise().scale(1.414f);
                boolean flag = this.mob.func_213373_a(target.func_226277_ct_() + (double)vec.x, target.func_226278_cu_(), target.func_226281_cx_() + (double)vec.z, true);
                if (flag) {
                    ((EndermanPatch)this.mobpatch).rotateTo((Entity)target, 360.0f, true);
                    this.move.execute((EndermanPatch)this.mobpatch);
                    this.mob.field_70170_p.func_184148_a((PlayerEntity)null, this.mob.field_70169_q, this.mob.field_70167_r, this.mob.field_70166_s, SoundEvents.field_187534_aX, this.mob.func_184176_by(), 1.0f, 1.0f);
                    this.mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    this.waitingCounter = 0;
                } else {
                    ++this.waitingCounter;
                }
            }
        }
    }
}

