/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class IronGolemPatch
extends MobPatch<IronGolemEntity> {
    private int deathTimerExt;

    public IronGolemPatch() {
        super(Faction.VILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((IronGolemEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<IronGolemPatch>(this, MobCombatBehaviors.IRON_GOLEM.build(this)));
        ((IronGolemEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.original, 1.0, false));
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        for (PrioritizedGoal wrappedGoal : ((IronGolemEntity)this.original).field_70714_bg.field_220892_d) {
            Goal goal = wrappedGoal.func_220772_j();
            if (!(goal instanceof MoveTowardsTargetGoal)) continue;
            toRemove.add(goal);
        }
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((IronGolemEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111128_a(4.0);
        ((IronGolemEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(6.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.GOLEM_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.GOLEM_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.GOLEM_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        if (((IronGolemEntity)this.original).func_110143_aJ() <= 0.0f) {
            ((IronGolemEntity)this.original).field_70125_A = 0.0f;
            if (((IronGolemEntity)this.original).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((IronGolemEntity)this.original).field_70725_aQ;
            }
        }
        super.tick(event);
    }

    @Override
    public SoundEvent getWeaponHitSound(Hand hand) {
        return EpicFightSounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return EpicFightSounds.WHOOSH_BIG;
    }

    @Override
    public float getDamageTo(Entity targetEntity, ExtendedDamageSource source, Hand hand) {
        float damage = super.getDamageTo(targetEntity, source, hand);
        return (int)damage > 0 ? damage / 2.0f + (float)((IronGolemEntity)this.original).func_70681_au().nextInt((int)damage) : damage;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ironGolem;
    }
}

