/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class RavagerPatch
extends MobPatch<RavagerEntity> {
    public RavagerPatch() {
        super(Faction.ILLAGER);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((RavagerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111128_a(8.0);
        ((RavagerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(6.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.RAVAGER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.RAVAGER_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.RAVAGER_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((RavagerEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<RavagerPatch>(this, MobCombatBehaviors.RAVAGER.build(this)));
        ((RavagerEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.original, 1.0, false));
    }

    @Override
    public void onHurtSomeone(Entity target, Hand handIn, ExtendedDamageSource damagesource, float amount, boolean succeed) {
        super.onHurtSomeone(target, handIn, damagesource, amount, succeed);
        if (!succeed && ((RavagerEntity)this.original).func_213684_dX() > 0) {
            this.playAnimationSynchronized(Animations.RAVAGER_STUN, 0.0f);
        }
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public SoundEvent getWeaponHitSound(Hand hand) {
        return EpicFightSounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return EpicFightSounds.WHOOSH_BIG;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ravager;
    }
}

