/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAddSkill;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPChangePlayerMode;
import yesman.epicfight.network.server.SPChangePlayerYaw;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ServerPlayerPatch
extends PlayerPatch<ServerPlayerEntity> {
    private LivingEntity attackTarget;
    private boolean updatedMotionCurrentTick;

    @Override
    public void onJoinWorld(ServerPlayerEntity entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        for (SkillContainer skill2 : skillCapability.skillContainers) {
            if (skill2.getSkill() == null || !skill2.getSkill().getCategory().shouldSynchronized()) continue;
            EpicFightNetworkManager.sendToPlayer(new SPChangeSkill(skill2.getSkill().getCategory().universalOrdinal(), skill2.getSkill().toString(), SPChangeSkill.State.ENABLE), (ServerPlayerEntity)this.original);
        }
        ArrayList learnedSkill = Lists.newArrayList();
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!skillCapability.hasCategory(category)) continue;
            learnedSkill.addAll(Lists.newArrayList(skillCapability.getLearnedSkills(category).stream().map(skill -> skill.toString()).iterator()));
        }
        EpicFightNetworkManager.sendToPlayer(new SPAddSkill(learnedSkill.toArray(new String[0])), (ServerPlayerEntity)this.original);
        EpicFightNetworkManager.sendToPlayer(new SPChangePlayerMode(((ServerPlayerEntity)this.getOriginal()).func_145782_y(), this.playerMode), (ServerPlayerEntity)this.original);
    }

    @Override
    public void onStartTracking(ServerPlayerEntity trackingPlayer) {
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayerEntity)this.getOriginal()).func_145782_y());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToPlayer(msg, trackingPlayer);
        EpicFightNetworkManager.sendToPlayer(new SPChangePlayerMode(((ServerPlayerEntity)this.getOriginal()).func_145782_y(), this.playerMode), trackingPlayer);
    }

    @Override
    public void gatherDamageDealt(ExtendedDamageSource source, float amount) {
        float value;
        SkillContainer container;
        if (source.isBasicAttack() && !(container = this.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK)).isFull() && container.hasSkill(this.getHoldingItemCapability(Hand.MAIN_HAND).getSpecialAttack(this)) && (value = container.getResource() + amount) > 0.0f) {
            this.getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).getSkill().setConsumptionSynchronize(this, value);
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        super.tick(event);
        this.updatedMotionCurrentTick = false;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, Hand hand) {
        CapabilityItem mainHandCap = hand == Hand.MAIN_HAND ? toCap : this.getHoldingItemCapability(Hand.MAIN_HAND);
        mainHandCap.changeWeaponSpecialSkill(this);
        if (hand == Hand.OFF_HAND) {
            if (!from.func_190926_b()) {
                from.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).func_111124_b(arg_0));
                from.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).func_111124_b(arg_0));
            }
            if (!fromCap.isEmpty()) {
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.ARMOR_NEGATION.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).func_111124_b(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.IMPACT.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).func_111124_b(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.MAX_STRIKES.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).func_111124_b(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)Attributes.field_233823_f_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).func_111124_b(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)Attributes.field_233825_h_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).func_111124_b(arg_0));
            }
            if (!to.func_190926_b()) {
                to.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).func_233767_b_(arg_0));
                to.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).func_233767_b_(arg_0));
            }
            if (!toCap.isEmpty()) {
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.ARMOR_NEGATION.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).func_233767_b_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.IMPACT.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).func_233767_b_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.MAX_STRIKES.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).func_233767_b_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)Attributes.field_233823_f_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).func_233767_b_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)Attributes.field_233825_h_).forEach(arg_0 -> ((ModifiableAttributeInstance)((ServerPlayerEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).func_233767_b_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem();
    }

    public void modifyLivingMotionByCurrentItem() {
        if (this.updatedMotionCurrentTick) {
            return;
        }
        ((Animator)this.getAnimator()).resetMotions();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(Hand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(Hand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        offhandCap.getLivingMotionModifier(this, Hand.OFF_HAND).forEach(motionModifier::put);
        mainhandCap.getLivingMotionModifier(this, Hand.MAIN_HAND).forEach(motionModifier::put);
        for (Map.Entry entry : motionModifier.entrySet()) {
            ((Animator)this.getAnimator()).addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayerEntity)this.original).func_145782_y());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayerEntity)this.original);
        this.updatedMotionCurrentTick = true;
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
        super.playAnimationSynchronized(animation, convertTimeModifier, packetProvider);
        EpicFightNetworkManager.sendToPlayer(packetProvider.get(animation, convertTimeModifier, this), (ServerPlayerEntity)this.original);
    }

    @Override
    public void reserveAnimation(StaticAnimation animation) {
        super.reserveAnimation(animation);
        EpicFightNetworkManager.sendToPlayer(new SPPlayAnimation(animation, ((ServerPlayerEntity)this.original).func_145782_y(), 0.0f), (ServerPlayerEntity)this.original);
    }

    @Override
    public void changeYaw(float amount) {
        super.changeYaw(amount);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPChangePlayerYaw(((ServerPlayerEntity)this.original).func_145782_y(), this.yaw), (ServerPlayerEntity)this.original);
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        HurtEvent.Pre hurtEvent = new HurtEvent.Pre(this, damageSource, amount);
        if (this.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_PRE, hurtEvent)) {
            return new AttackResult(hurtEvent.getResult(), hurtEvent.getAmount());
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void toMiningMode(boolean synchronize) {
        super.toMiningMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPChangePlayerMode(((ServerPlayerEntity)this.original).func_145782_y(), PlayerPatch.PlayerMode.MINING), (ServerPlayerEntity)this.original);
        }
    }

    @Override
    public void toBattleMode(boolean synchronize) {
        super.toBattleMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPChangePlayerMode(((ServerPlayerEntity)this.original).func_145782_y(), PlayerPatch.PlayerMode.BATTLE), (ServerPlayerEntity)this.original);
        }
    }

    @Override
    public boolean isTeammate(Entity entityIn) {
        if (entityIn instanceof PlayerEntity && !((ServerPlayerEntity)this.getOriginal()).field_71133_b.func_71219_W()) {
            return true;
        }
        return super.isTeammate(entityIn);
    }

    public void setAttackTarget(LivingEntity entity) {
        this.attackTarget = entity;
    }

    @Override
    public LivingEntity getTarget() {
        return this.attackTarget;
    }
}

