/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ArmorCapability
extends CapabilityItem {
    protected static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected final double weight;
    protected final double stunArmor;
    private final EquipmentSlotType equipmentSlot;

    protected ArmorCapability(CapabilityItem.Builder builder) {
        super(builder);
        Builder armorBuilder = (Builder)builder;
        this.equipmentSlot = armorBuilder.equipmentSlot;
        this.weight = armorBuilder.weight;
        this.stunArmor = armorBuilder.stunArmor;
    }

    @Override
    public void modifyItemTooltip(ItemStack stack, List<ITextComponent> itemTooltip, LivingEntityPatch<?> entitypatch) {
        itemTooltip.add(1, (ITextComponent)new StringTextComponent(TextFormatting.BLUE + " +" + (int)this.weight + " ").func_230529_a_((ITextComponent)new TranslationTextComponent(((Attribute)EpicFightAttributes.WEIGHT.get()).func_233754_c_()).func_240699_a_(TextFormatting.BLUE)));
        if (this.stunArmor > 0.0) {
            itemTooltip.add(1, (ITextComponent)new StringTextComponent(TextFormatting.BLUE + " +" + ItemStack.field_111284_a.format(this.stunArmor) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent(((Attribute)EpicFightAttributes.STUN_ARMOR.get()).func_233754_c_()).func_240699_a_(TextFormatting.BLUE)));
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, LivingEntityPatch<?> entitypatch) {
        HashMultimap map = HashMultimap.create();
        if (entitypatch != null && equipmentSlot == this.equipmentSlot) {
            map.put((Object)EpicFightAttributes.WEIGHT.get(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", this.weight, AttributeModifier.Operation.ADDITION));
            map.put((Object)EpicFightAttributes.STUN_ARMOR.get(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", this.stunArmor, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CapabilityItem.Builder {
        EquipmentSlotType equipmentSlot;
        double weight;
        double stunArmor;

        protected Builder() {
            this.constructor = ArmorCapability::new;
            this.weight = -1.0;
            this.stunArmor = -1.0;
        }

        public Builder item(Item item) {
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                IArmorMaterial armorMaterial = armorItem.func_200880_d();
                this.equipmentSlot = armorItem.func_185083_B_();
                if (this.weight < 0.0) {
                    this.weight = (float)armorMaterial.func_200902_b(this.equipmentSlot) * 2.5f;
                }
                if (this.stunArmor < 0.0) {
                    this.stunArmor = (float)armorMaterial.func_200902_b(this.equipmentSlot) * 0.375f;
                }
            }
            return this;
        }

        public Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder stunArmor(double stunArmor) {
            this.stunArmor = stunArmor;
            return this;
        }
    }
}

