/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.Hand;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class RangedWeaponCapability
extends CapabilityItem {
    protected Map<LivingMotion, StaticAnimation> rangeAnimationModifiers;

    protected RangedWeaponCapability(CapabilityItem.Builder builder) {
        super(builder);
        Builder rangedBuilder = (Builder)builder;
        this.rangeAnimationModifiers = rangedBuilder.rangeAnimationModifiers;
    }

    @Override
    public void setConfigFileAttribute(double armorNegation1, double impact1, int maxStrikes1, double armorNegation2, double impact2, int maxStrikes2) {
        this.addStyleAttributes(CapabilityItem.Styles.RANGED, armorNegation1, impact1, maxStrikes1);
    }

    @Override
    public Map<LivingMotion, StaticAnimation> getLivingMotionModifier(LivingEntityPatch<?> playerdata, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return this.rangeAnimationModifiers;
        }
        return super.getLivingMotionModifier(playerdata, hand);
    }

    @Override
    public boolean availableOnHorse() {
        return true;
    }

    @Override
    public boolean canBePlacedOffhand() {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CapabilityItem.Builder {
        Map<LivingMotion, StaticAnimation> rangeAnimationModifiers;

        protected Builder() {
            this.category = CapabilityItem.WeaponCategories.RANGED;
            this.constructor = RangedWeaponCapability::new;
            this.rangeAnimationModifiers = Maps.newHashMap();
        }

        public Builder addAnimationsModifier(LivingMotion livingMotion, StaticAnimation animations) {
            this.rangeAnimationModifiers.put(livingMotion, animations);
            return this;
        }
    }
}

