/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.IndirectEpicFightDamageSource;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class ProjectilePatch<T extends ProjectileEntity> {
    protected float impact;
    protected float armorNegation;
    protected Vector3d initialFirePosition;

    public void onJoinWorld(T projectileEntity, EntityJoinWorldEvent event) {
        Entity shooter = projectileEntity.func_234616_v_();
        boolean flag = true;
        if (shooter != null && shooter instanceof LivingEntity) {
            this.initialFirePosition = shooter.func_213303_ch();
            LivingEntity livingshooter = (LivingEntity)shooter;
            ItemStack heldItem = livingshooter.func_184614_ca();
            CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(heldItem);
            if (itemCap instanceof RangedWeaponCapability) {
                Map<Attribute, AttributeModifier> modifierMap = itemCap.getDamageAttributesInCondition(CapabilityItem.Styles.RANGED);
                if (modifierMap != null) {
                    this.armorNegation = modifierMap.containsKey(EpicFightAttributes.ARMOR_NEGATION.get()) ? (float)modifierMap.get(EpicFightAttributes.ARMOR_NEGATION.get()).func_111164_d() : (float)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_111110_b();
                    float f = this.impact = modifierMap.containsKey(EpicFightAttributes.IMPACT.get()) ? (float)modifierMap.get(EpicFightAttributes.IMPACT.get()).func_111164_d() : (float)((Attribute)EpicFightAttributes.IMPACT.get()).func_111110_b();
                    if (modifierMap.containsKey(EpicFightAttributes.MAX_STRIKES.get())) {
                        this.setMaxStrikes(projectileEntity, (int)modifierMap.get(EpicFightAttributes.MAX_STRIKES.get()).func_111164_d());
                    }
                }
                flag = false;
            }
        }
        if (flag) {
            this.armorNegation = 0.0f;
            this.impact = 0.0f;
        }
    }

    public boolean onProjectileImpact(ProjectileImpactEvent event) {
        return false;
    }

    protected abstract void setMaxStrikes(T var1, int var2);

    public IndirectEpicFightDamageSource getEpicFightDamageSource(DamageSource original) {
        IndirectEpicFightDamageSource extSource = new IndirectEpicFightDamageSource(original.field_76373_n, original.func_76346_g(), original.func_76364_f(), ExtendedDamageSource.StunType.SHORT);
        extSource.func_76349_b();
        extSource.setArmorNegation(this.armorNegation);
        extSource.setImpact(this.impact);
        extSource.setInitialPosition(this.initialFirePosition);
        return extSource;
    }
}

