/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AnimatedAttackGoal<T extends MobPatch<?>>
extends Goal {
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public AnimatedAttackGoal(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    public boolean func_75250_a() {
        return this.checkTargetValid();
    }

    public void func_75246_d() {
        if (((MobPatch)this.mobpatch).getTarget() != null) {
            CombatBehaviors.Behavior<T> result;
            EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
            this.combatBehaviors.tick();
            if (this.combatBehaviors.hasActivatedMove()) {
                CombatBehaviors.Behavior<T> result2;
                if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                    result2.execute(this.mobpatch);
                }
            } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
                result.execute(this.mobpatch);
            }
        }
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = ((MobPatch)this.mobpatch).getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }
}

