/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class CombatBehaviorGoal<T extends MobPatch<?>>
extends Goal {
    protected final MobEntity mob;
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public CombatBehaviorGoal(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        this.mob = (MobEntity)((EntityPatch)mobpatch).getOriginal();
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
        this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean func_75250_a() {
        return this.isValidTarget(this.mob.func_70638_az());
    }

    public boolean func_75253_b() {
        return this.func_75250_a() && !((LivingEntityPatch)this.mobpatch).getEntityState().hurt();
    }

    public void func_75246_d() {
        if (this.isValidTarget(this.mob.func_70638_az())) {
            CombatBehaviors.Behavior<T> result;
            EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
            this.combatBehaviors.tick();
            if (this.combatBehaviors.hasActivatedMove()) {
                CombatBehaviors.Behavior<T> result2;
                if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                    result2.execute(this.mobpatch);
                }
            } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
                result.execute(this.mobpatch);
            }
        }
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.func_70089_S() && !attackTarget.func_175149_v() && (!(attackTarget instanceof PlayerEntity) || !((PlayerEntity)attackTarget).func_184812_l_());
    }
}

