/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.item.EpicFightItemGroup;

public class SkillBookItem
extends Item {
    public static void setContainingSkill(String name, ItemStack stack) {
        stack.func_196082_o().func_218657_a("skill", (INBT)StringNBT.func_229705_a_((String)name));
    }

    public static void setContainingSkill(Skill skill, ItemStack stack) {
        SkillBookItem.setContainingSkill(skill.toString(), stack);
    }

    public static Skill getContainSkill(ItemStack stack) {
        String skillName = stack.func_77978_p().func_74779_i("skill");
        return Skills.getSkill(skillName);
    }

    public SkillBookItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("skill");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Skill skill;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("skill") && (skill = Skills.getSkill(stack.func_77978_p().func_74779_i("skill"))) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(skill.getTranslatableText()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == EpicFightItemGroup.ITEMS) {
            Skills.getLearnableSkills().forEach(skill -> {
                ItemStack stack = new ItemStack((IItemProvider)this);
                SkillBookItem.setContainingSkill(skill, stack);
                items.add((Object)stack);
            });
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        playerIn.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(capability -> {
            if (capability instanceof PlayerPatch) {
                ((PlayerPatch)capability).openSkillBook(itemstack, hand);
            }
        });
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return ActionResult.func_226250_c_((Object)itemstack);
    }
}

