/*
 * Decompiled with CFR 0.152.
 */
package net.kaikk.mc.serverredirect.forge;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.kaikk.mc.serverredirect.forge.PacketHandler;
import net.kaikk.mc.serverredirect.forge.event.ClientFallbackEvent;
import net.kaikk.mc.serverredirect.forge.event.ClientRedirectEvent;
import net.kaikk.mc.serverredirect.forge.event.PlayerFallbackEvent;
import net.kaikk.mc.serverredirect.forge.event.PlayerRedirectEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="serverredirect")
public class ServerRedirect {
    public static final String MODID = "serverredirect";
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final Set<UUID> players = Collections.synchronizedSet(new HashSet());
    @OnlyIn(value=Dist.CLIENT)
    public static volatile String fallbackServerAddress;
    @OnlyIn(value=Dist.CLIENT)
    public static boolean connected;

    public ServerRedirect() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"redirect").requires(cs -> cs.func_197034_c(2))).redirect((CommandNode)event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)MODID).requires(cs -> cs.func_197034_c(2))).then(this.commandAddress(ServerRedirect::sendTo)))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"fallback").requires(cs -> cs.func_197034_c(2))).redirect((CommandNode)event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"fallbackserver").requires(cs -> cs.func_197034_c(2))).then(this.commandAddress(ServerRedirect::sendFallbackTo)))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ifplayercanredirect").requires(cs -> cs.func_197034_c(2))).then(this.commandIfPlayerRedirect(false)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ifplayercannotredirect").requires(cs -> cs.func_197034_c(2))).then(this.commandIfPlayerRedirect(true)));
    }

    private ArgumentBuilder<CommandSource, ?> commandAddress(BiConsumer<ServerPlayerEntity, String> consumer) {
        return Commands.func_197056_a((String)"Player(s)", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"Server Address", (ArgumentType)StringArgumentType.greedyString()).executes(cs -> {
            try {
                String addr = (String)cs.getArgument("Server Address", String.class);
                if (!PacketHandler.ADDRESS_PREVALIDATOR.matcher(addr).matches()) {
                    ((CommandSource)cs.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Invalid Server Address"));
                    return 0;
                }
                ((EntitySelector)cs.getArgument("Player(s)", EntitySelector.class)).func_197342_d((CommandSource)cs.getSource()).forEach(p -> {
                    try {
                        consumer.accept((ServerPlayerEntity)p, addr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    private ArgumentBuilder<CommandSource, ?> commandIfPlayerRedirect(boolean not) {
        return Commands.func_197056_a((String)"Player(s)", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"Command...", (ArgumentType)StringArgumentType.greedyString()).executes(cs -> {
            try {
                String command = (String)cs.getArgument("Command...", String.class);
                ((EntitySelector)cs.getArgument("Player(s)", EntitySelector.class)).func_197342_d((CommandSource)cs.getSource()).forEach(p -> {
                    try {
                        if (ServerRedirect.isUsingServerRedirect(p) != not) {
                            ((CommandSource)cs.getSource()).func_197028_i().func_195571_aL().func_197059_a((CommandSource)cs.getSource(), command.replace("%PlayerName", p.func_146103_bH().getName()).replace("%PlayerId", p.func_189512_bd()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (connected != (mc.field_71441_e != null)) {
            boolean bl = connected = mc.field_71441_e != null;
            if (connected) {
                PacketHandler.ANNOUNCE_CHANNEL.sendToServer(PacketHandler.EMPTY_OBJECT);
            }
        } else if (fallbackServerAddress != null) {
            if (mc.field_71462_r instanceof DisconnectedScreen) {
                String addr = fallbackServerAddress;
                fallbackServerAddress = null;
                ServerRedirect.redirect(addr);
            } else if (mc.field_71462_r instanceof MainMenuScreen || mc.field_71462_r instanceof MultiplayerScreen) {
                fallbackServerAddress = null;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        players.remove(event.getPlayer().func_110124_au());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void redirect(String serverAddress) {
        if (!Minecraft.func_71410_x().func_213162_bc()) {
            throw new IllegalStateException("Not in the main thread");
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new ClientRedirectEvent(serverAddress))) {
            return;
        }
        LOGGER.info("Connecting to " + serverAddress);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            mc.field_71441_e.func_72882_A();
        }
        if (mc.func_71387_A()) {
            mc.func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("menu.savingLevel")));
        } else {
            mc.func_213254_o();
        }
        mc.func_147108_a((Screen)new MultiplayerScreen((Screen)new MainMenuScreen()));
        mc.func_147108_a((Screen)new ConnectingScreen(mc.field_71462_r, mc, new ServerData(serverAddress, serverAddress, false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getFallbackServerAddress() {
        return fallbackServerAddress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setFallbackServerAddress(String fallbackServerAddress) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ClientFallbackEvent(fallbackServerAddress))) {
            return;
        }
        ServerRedirect.fallbackServerAddress = fallbackServerAddress;
    }

    public static boolean sendTo(ServerPlayerEntity player, String serverAddress) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlayerRedirectEvent(player, serverAddress))) {
            return false;
        }
        PacketHandler.REDIRECT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        return true;
    }

    public static void sendToAll(String serverAddress) {
        PlayerList pl = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        for (ServerPlayerEntity player : pl.func_181057_v()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerRedirectEvent(player, serverAddress))) continue;
            PacketHandler.REDIRECT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        }
    }

    public static boolean sendFallbackTo(ServerPlayerEntity player, String serverAddress) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlayerFallbackEvent(player, serverAddress))) {
            return false;
        }
        PacketHandler.FALLBACK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        return true;
    }

    public static void sendFallbackToAll(String serverAddress) {
        PlayerList pl = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        for (ServerPlayerEntity player : pl.func_181057_v()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerFallbackEvent(player, serverAddress))) continue;
            PacketHandler.FALLBACK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        }
    }

    public static boolean isUsingServerRedirect(ServerPlayerEntity player) {
        return ServerRedirect.isUsingServerRedirect(player.func_110124_au());
    }

    public static boolean isUsingServerRedirect(UUID playerId) {
        return players.contains(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachPlayerUsingServerRedirect(Consumer<UUID> consumer) {
        Set<UUID> set = players;
        synchronized (set) {
            for (UUID playerId : players) {
                consumer.accept(playerId);
            }
        }
    }

    public static Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(new HashSet<UUID>(players));
    }
}

