/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintingHighlightPlacementRenderer {
    public static void renderPaintTool(ItemStack itemStack, PlayerEntity player, BlockRayTraceResult traceResult, ActiveRenderInfo renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        float z1;
        float y1;
        float x1;
        float z0;
        float y0;
        float x0;
        World level = PropertyProvider.getLevel((Entity)player);
        BlockPos pos = traceResult.func_216350_a();
        OpenDirection direction = AbstractDirection.wrap(traceResult.func_216354_b());
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof IBlockPaintable)) {
            return;
        }
        Integer radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        Integer radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        Boolean restrictPlane = ToolAPI.get(itemStack, PaintingToolOptions.PLANE_RESTRICT);
        ArrayList<BlockPos> blockSamples = BlockUtils.findTouchingBlockFaces(level, pos, direction, radiusSample, restrictPlane);
        ArrayList<BlockPos> blockEffects = BlockUtils.findTouchingBlockFaces(level, pos, direction, radiusEffect, restrictPlane);
        poseStack.pushPose();
        Vector3d origin = renderInfo.func_216785_c();
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.HIGHLIGHTED_LINES);
        poseStack.translate((float)(-origin.func_82615_a()), (float)(-origin.func_82617_b()), (float)(-origin.func_82616_c()));
        poseStack.translate(0.5f, 0.5f, 0.5f);
        for (BlockPos pos1 : blockSamples) {
            x0 = (float)pos1.func_177958_n() - 0.5f;
            y0 = (float)pos1.func_177956_o() - 0.5f;
            z0 = (float)pos1.func_177952_p() - 0.5f;
            x1 = (float)pos1.func_177958_n() + 0.5f;
            y1 = (float)pos1.func_177956_o() + 0.5f;
            z1 = (float)pos1.func_177952_p() + 0.5f;
            ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, UIColor.RED, poseStack, builder);
        }
        for (BlockPos pos1 : blockEffects) {
            x0 = (float)pos1.func_177958_n() - 0.4f;
            y0 = (float)pos1.func_177956_o() - 0.4f;
            z0 = (float)pos1.func_177952_p() - 0.4f;
            x1 = (float)pos1.func_177958_n() + 0.4f;
            y1 = (float)pos1.func_177956_o() + 0.4f;
            z1 = (float)pos1.func_177952_p() + 0.4f;
            ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, UIColor.GREEN, poseStack, builder);
        }
        poseStack.popPose();
    }
}

