/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data;

import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class BoundingBox
extends OpenRectangle3i {
    public static final EntityTextureModel MODEL = EntityTextureModel.STAVE_V2;
    public static final EntityTextureModel SLIM_MODEL = EntityTextureModel.ALEX_V2;
    private final SkinPartType partType;

    public BoundingBox(SkinPartType partType, OpenRectangle3i rect) {
        super(rect.x(), rect.y(), rect.z(), rect.width(), rect.height(), rect.depth());
        this.partType = partType;
    }

    public void forEach(IPixelConsumer consumer) {
        for (int ix = 0; ix < this.width(); ++ix) {
            for (int iy = 0; iy < this.height(); ++iy) {
                for (int iz = 0; iz < this.depth(); ++iz) {
                    consumer.accept(ix, iy, iz);
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundingBox)) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.partType.equals(that.partType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.partType);
    }

    public SkinPartType partType() {
        return this.partType;
    }

    public static interface IPixelConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

