/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateOutfitMakerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final GenericValue<OutfitMakerBlockEntity, ?> fieldValue;

    public UpdateOutfitMakerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateOutfitMakerPacket(OutfitMakerBlockEntity entity, GenericValue<OutfitMakerBlockEntity, ?> fieldValue) {
        this.pos = entity.func_174877_v();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        GenericProperty<OutfitMakerBlockEntity, ?> genericProperty;
        OutfitMakerBlockEntity blockEntity1;
        block3: {
            block2: {
                TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
                if (!(blockEntity instanceof OutfitMakerBlockEntity)) break block2;
                blockEntity1 = (OutfitMakerBlockEntity)blockEntity;
                genericProperty = this.fieldValue.property();
                if (genericProperty instanceof Field) break block3;
            }
            return;
        }
        Field field = (Field)genericProperty;
        BlockUtils.performBatch(() -> {
            try {
                field.apply(this, blockEntity1, player);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void craftItem(OutfitMakerBlockEntity blockEntity, ServerPlayerEntity player) {
        if (!ModPermissions.OUTFIT_MAKER_MAKE.accept((PlayerEntity)player)) {
            return;
        }
        Container container = player.field_71070_bA;
        if (container instanceof OutfitMakerMenu) {
            OutfitMakerMenu menu = (OutfitMakerMenu)container;
            CompoundNBT nbt = (CompoundNBT)this.fieldValue.value();
            GameProfile profile = DataSerializers.readGameProfile(nbt);
            menu.saveArmourItem((PlayerEntity)player, profile);
        }
    }

    public static final class Field<T>
    extends GenericProperty<OutfitMakerBlockEntity, T> {
        private static final GenericProperties<OutfitMakerBlockEntity> TYPE = GenericProperties.of(OutfitMakerBlockEntity.class, UpdateOutfitMakerPacket::new);
        public static final Field<String> ITEM_NAME = Field.create(OutfitMakerBlockEntity::itemName, OutfitMakerBlockEntity::setItemName, DataSerializers.STRING);
        public static final Field<String> ITEM_FLAVOUR = Field.create(OutfitMakerBlockEntity::itemFlavour, OutfitMakerBlockEntity::setItemFlavour, DataSerializers.STRING);
        public static final Field<CompoundNBT> ITEM_CRAFTING = Field.create((rec$, x$0, x$1) -> UpdateOutfitMakerPacket.access$200(rec$, x$0, x$1), DataSerializers.COMPOUND_TAG);
        private FieldAction<T> action;

        private static <T> Field<T> create(FieldAction<T> action, IEntitySerializer<T> dataSerializer) {
            Field field = TYPE.create(dataSerializer).build(Field::new);
            field.action = action;
            return field;
        }

        private static <T> Field<T> create(Function<OutfitMakerBlockEntity, T> supplier, BiConsumer<OutfitMakerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
        }

        private void apply(UpdateOutfitMakerPacket packet, OutfitMakerBlockEntity blockEntity, ServerPlayerEntity player) throws Exception {
            if (this.action != null) {
                this.action.accept(packet, blockEntity, player);
            } else {
                packet.fieldValue.apply(blockEntity);
            }
        }
    }

    public static interface FieldAction<T> {
        public void accept(UpdateOutfitMakerPacket var1, OutfitMakerBlockEntity var2, ServerPlayerEntity var3) throws Exception;
    }
}

