/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CubeSelector
implements IPaintToolSelector {
    final BlockPos blockPos;
    final MatchMode mode;
    final ArrayList<OpenRectangle3i> rects;
    final int radius;
    final boolean isPlaneOnly;
    final boolean isApplyAllFaces;

    protected CubeSelector(MatchMode mode, BlockPos blockPos, int radius, boolean isApplyAllFaces, boolean isPlaneOnly) {
        this.blockPos = blockPos;
        this.mode = mode;
        this.radius = Math.max(radius, 1);
        this.isApplyAllFaces = isApplyAllFaces;
        this.isPlaneOnly = isPlaneOnly;
        this.rects = new ArrayList();
    }

    protected CubeSelector(MatchMode mode, Iterable<OpenRectangle3i> rects) {
        this.blockPos = BlockPos.field_177992_a;
        this.mode = mode;
        this.radius = 0;
        this.isApplyAllFaces = true;
        this.isPlaneOnly = false;
        this.rects = Collections.newList(rects);
    }

    protected CubeSelector(IFriendlyByteBuf buffer) {
        this.blockPos = buffer.readBlockPos();
        this.mode = buffer.readEnum(MatchMode.class);
        this.radius = buffer.readInt();
        this.isApplyAllFaces = buffer.readBoolean();
        this.isPlaneOnly = buffer.readBoolean();
        this.rects = new ArrayList();
        if (this.mode == MatchMode.ALL) {
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                int x = buffer.readInt();
                int y = buffer.readInt();
                int z = buffer.readInt();
                int width = buffer.readInt();
                int height = buffer.readInt();
                int depth = buffer.readInt();
                this.rects.add(new OpenRectangle3i(x, y, z, width, height, depth));
            }
        }
    }

    public static CubeSelector from(IFriendlyByteBuf buffer) {
        return new CubeSelector(buffer);
    }

    public static CubeSelector box(BlockPos pos, boolean isApplyAllFaces) {
        return CubeSelector.box(pos, 1, isApplyAllFaces);
    }

    public static CubeSelector box(BlockPos pos, int radius, boolean isApplyAllFaces) {
        return new CubeSelector(MatchMode.SAME, pos, radius, isApplyAllFaces, false);
    }

    public static CubeSelector all(Iterable<OpenRectangle3i> rects) {
        return new CubeSelector(MatchMode.ALL, rects);
    }

    public static CubeSelector plane(BlockPos pos, int radius, boolean isApplyAllFaces) {
        return new CubeSelector(MatchMode.SAME, pos, radius, isApplyAllFaces, true);
    }

    public static CubeSelector touching(BlockPos pos, int radius, boolean isApplyAllFaces, boolean isPlaneOnly) {
        return new CubeSelector(MatchMode.TOUCHING, pos, radius, isApplyAllFaces, isPlaneOnly);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.blockPos);
        buffer.writeEnum(this.mode);
        buffer.writeInt(this.radius);
        buffer.writeBoolean(this.isApplyAllFaces);
        buffer.writeBoolean(this.isPlaneOnly);
        if (this.mode == MatchMode.ALL) {
            buffer.writeInt(this.rects.size());
            for (OpenRectangle3i rect : this.rects) {
                buffer.writeInt(rect.x());
                buffer.writeInt(rect.y());
                buffer.writeInt(rect.z());
                buffer.writeInt(rect.width());
                buffer.writeInt(rect.height());
                buffer.writeInt(rect.depth());
            }
        }
    }

    @Override
    public void forEach(ItemUseContext context, BiConsumer<BlockPos, OpenDirection> consumer) {
        World level = context.func_195991_k();
        OpenDirection clickedFace = AbstractDirection.wrap(context.func_196000_l());
        OpenDirection[] dirs = this.resolvedDirections(clickedFace);
        this.forEach(level, clickedFace, targetPos -> {
            for (OpenDirection dir : dirs) {
                consumer.accept((BlockPos)targetPos, dir);
            }
        });
    }

    private void forEach(World level, OpenDirection dir, Consumer<BlockPos> consumer) {
        switch (this.mode.ordinal()) {
            case 0: {
                for (OpenRectangle3i rect : this.rects) {
                    for (OpenVector3i pos : rect.enumerateZYX()) {
                        consumer.accept(new BlockPos(pos.x(), pos.y(), pos.z()));
                    }
                }
                break;
            }
            case 1: {
                Object info = this.resolvedBlockInfo(level, this.blockPos);
                Consumer<BlockPos> consumer1 = targetPos -> {
                    if (Objects.equals(info, this.resolvedBlockInfo(level, (BlockPos)targetPos))) {
                        consumer.accept((BlockPos)targetPos);
                    }
                };
                if (this.isPlaneOnly) {
                    for (int j = -this.radius + 1; j < this.radius; ++j) {
                        for (int i = -this.radius + 1; i < this.radius; ++i) {
                            consumer1.accept(this.resolvedPos(dir, i, j));
                        }
                    }
                } else {
                    for (int iy = -this.radius + 1; iy < this.radius; ++iy) {
                        for (int ix = -this.radius + 1; ix < this.radius; ++ix) {
                            for (int iz = -this.radius + 1; iz < this.radius; ++iz) {
                                consumer1.accept(this.blockPos.func_177982_a(ix, iy, iz));
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                BlockUtils.findTouchingBlockFaces(level, this.blockPos, dir, this.radius, this.isPlaneOnly).forEach(consumer);
            }
        }
    }

    private BlockPos resolvedPos(OpenDirection dir, int i, int j) {
        BlockPos blockPos;
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: 
            case DOWN: {
                blockPos = this.blockPos.func_177982_a(j, 0, i);
                break;
            }
            case NORTH: 
            case SOUTH: {
                blockPos = this.blockPos.func_177982_a(i, j, 0);
                break;
            }
            case WEST: 
            case EAST: {
                blockPos = this.blockPos.func_177982_a(0, i, j);
            }
        }
        return blockPos;
    }

    private OpenDirection[] resolvedDirections(OpenDirection clickedFace) {
        if (!this.isApplyAllFaces) {
            return new OpenDirection[]{clickedFace};
        }
        return OpenDirection.values();
    }

    private Object resolvedBlockInfo(World level, BlockPos pos) {
        if (this.radius == 1) {
            return null;
        }
        return level.func_180495_p(pos).func_203425_a((Block)ModBlocks.BOUNDING_BOX.get());
    }

    protected static enum MatchMode {
        ALL,
        SAME,
        TOUCHING;

    }
}

