/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.registry.IEventHandler;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeInitializer;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;

public class AbstractForgeEventBus {
    private static final Map<IEventHandler.Priority, EventPriority> CONVERTER = Collections.immutableMap(it -> {
        it.put((Object)IEventHandler.Priority.HIGHEST, (Object)EventPriority.HIGHEST);
        it.put((Object)IEventHandler.Priority.HIGH, (Object)EventPriority.HIGH);
        it.put((Object)IEventHandler.Priority.NORMAL, (Object)EventPriority.NORMAL);
        it.put((Object)IEventHandler.Priority.LOW, (Object)EventPriority.LOW);
        it.put((Object)IEventHandler.Priority.LOWEST, (Object)EventPriority.LOWEST);
    });
    private static final HashMap<Object, ArrayList<?>> LISTENERS = new HashMap();

    public static <E extends Event> void observer(Class<E> eventType, Consumer<E> handler) {
        AbstractForgeEventBus.observer(eventType, EventPriority.NORMAL, false, handler, event -> event);
    }

    public static <E extends Event, T> void observer(Class<E> eventType, EventPriority priority, boolean receiveCancelled, Consumer<T> handler, Function<E, T> transform) {
        ArrayList<Serializable> key = Collections.newList(eventType, priority, receiveCancelled);
        ArrayList handlers = LISTENERS.computeIfAbsent(key, key1 -> {
            ArrayList queue = new ArrayList();
            Consumer<Event> listener = event -> queue.forEach(element -> element.accept(transform.apply(event)));
            if (IModBusEvent.class.isAssignableFrom(eventType)) {
                AbstractForgeInitializer.getModEventBus().addListener(priority, receiveCancelled, eventType, listener);
            } else {
                AbstractForgeInitializer.getEventBus().addListener(priority, receiveCancelled, eventType, listener);
            }
            return queue;
        });
        handlers.add(Objects.unsafeCast(handler));
    }

    public static <E extends Event> IEventHandler<E> create(Class<E> eventType) {
        return (priority, receiveCancelled, handler) -> AbstractForgeEventBus.observer(eventType, CONVERTER.getOrDefault((Object)priority, EventPriority.NORMAL), receiveCancelled, handler, event -> event);
    }
}

