/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.core.block.AbstractAttachedHorizontalBlock;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlock
extends AbstractAttachedHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockHandler {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;

    public SkinnableBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)FACE, (Comparable)AttachFace.WALL)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)BedPart.HEAD)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntity createBlockEntity(IBlockReader level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKINNABLE.get()).create(level, blockPos, blockState);
    }

    public void func_180633_a(World level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        SkinBlockPlaceContext context = SkinBlockPlaceContext.of(blockPos);
        if (context == null) {
            return;
        }
        context.parts().forEach(part -> {
            BlockPos target = blockPos.func_177971_a((Vector3i)part.offset());
            level.func_180501_a(target, blockState, 11);
            SkinnableBlockEntity blockEntity = this.getBlockEntity((IBlockReader)level, target);
            if (blockEntity != null) {
                TagSerializer serializer = new TagSerializer(new CompoundNBT(), level);
                part.serialize(serializer);
                blockEntity.readAdditionalData(serializer);
                blockEntity.updateBlockStates();
            }
        });
        super.func_180633_a(level, blockPos, blockState, entity, itemStack);
    }

    public void func_196243_a(BlockState blockState, World level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.func_203425_a(blockState2.func_177230_c())) {
            this.brokenByAnything(level, blockPos, blockState, null);
        }
        super.func_196243_a(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        SkinnableBlockEntity blockEntity1;
        List<ItemStack> results;
        block4: {
            block3: {
                results = super.getDrops(blockState, context);
                TileEntity blockEntity = context.getOptionalParameter(ILootContextParam.BLOCK_ENTITY);
                if (!(blockEntity instanceof SkinnableBlockEntity)) break block3;
                blockEntity1 = (SkinnableBlockEntity)blockEntity;
                if (!results.isEmpty()) break block4;
            }
            return results;
        }
        ArrayList<ItemStack> fixedResults = new ArrayList<ItemStack>(results.size());
        for (ItemStack itemStack : results) {
            if (Fix16.is(itemStack, (Item)ModItems.SKIN.get()) && SkinDescriptor.of(itemStack).isEmpty() && (itemStack = blockEntity1.getDropped()) == null) continue;
            fixedResults.add(itemStack);
        }
        return fixedResults;
    }

    @Override
    public BlockState destroyByPlayer(World level, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        this.brokenByAnything(level, blockPos, blockState, player);
        return super.destroyByPlayer(level, blockPos, blockState, player);
    }

    @Override
    protected ActionResultType useWithoutItem(BlockState blockState, World level, BlockPos blockPos, PlayerEntity player, BlockRayTraceResult blockHitResult) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((IBlockReader)level, blockPos);
        if (blockEntity == null) {
            return ActionResultType.FAIL;
        }
        if (blockEntity.isLinked()) {
            Optional<ActionResultType> result = blockEntity.getLinkedValueFromParent((level1, pos) -> {
                BlockState state = level1.func_180495_p(pos);
                return super.useWithoutItem(state, (World)level1, (BlockPos)pos, player, blockHitResult);
            });
            return result.orElse(ActionResultType.FAIL);
        }
        if (blockEntity.isBed() && !player.func_226563_dT_() && ModPermissions.SKINNABLE_SLEEP.accept(blockEntity, player)) {
            BlockState bedState = (BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a(PART, (Comparable)BedPart.HEAD);
            return super.useWithoutItem(bedState, level, blockEntity.getBedPos(), player, blockHitResult);
        }
        if (blockEntity.isSeat() && !player.func_226563_dT_() && ModPermissions.SKINNABLE_SIT.accept(blockEntity, player)) {
            if (level.func_201670_d()) {
                return ActionResultType.CONSUME;
            }
            OpenVector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            SeatEntity seatEntity = this.getSeatEntity((ServerWorld)level, blockEntity.getParentPos(), seatPos);
            if (seatEntity == null) {
                return ActionResultType.FAIL;
            }
            player.func_184205_a((Entity)seatEntity, true);
            return ActionResultType.SUCCESS;
        }
        if (blockEntity.isInventory()) {
            ActionResultType result = ((IMenuType)ModMenuTypes.SKINNABLE.get()).openMenu(player, level.func_175625_s(blockPos));
            if (result.func_226246_a_()) {
                player.func_71029_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac));
            }
            return result;
        }
        return ActionResultType.FAIL;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        SkinBlockPlaceContext context1;
        BlockState state = super.func_196258_a(context);
        if (state != null && context instanceof SkinBlockPlaceContext && (context1 = (SkinBlockPlaceContext)context).getProperty(SkinProperty.BLOCK_GLOWING).booleanValue()) {
            state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader blockGetter, BlockPos blockPos, BlockState blockState) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((IBlockReader)blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getSkin().asItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isCustomBed(IBlockReader level, BlockPos blockPos, BlockState blockState, @Nullable Entity player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isBed();
        }
        return false;
    }

    @Override
    public boolean isCustomLadder(IBlockReader level, BlockPos blockPos, BlockState blockState, LivingEntity entity) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isLadder();
        }
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, FACE, LIT, PART, OCCUPIED});
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((IBlockReader)level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getAnalogOutputSignal();
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader level, BlockPos blockPos, Direction direction) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getSignal(direction);
        }
        return 0;
    }

    public int func_176211_b(BlockState state, IBlockReader level, BlockPos blockPos, Direction direction) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getDirectSignal(direction);
        }
        return 0;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getShape();
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getCollisionShape();
        }
        return VoxelShapes.func_197880_a();
    }

    public void forEach(World level, BlockPos pos, Consumer<BlockPos> consumer) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((IBlockReader)level, pos);
        if (blockEntity == null) {
            return;
        }
        BlockPos parentPos = blockEntity.func_174877_v();
        for (BlockPos offset : blockEntity.getRefers()) {
            BlockPos targetPos = parentPos.func_177971_a((Vector3i)offset);
            if (targetPos.equals((Object)pos)) continue;
            consumer.accept(targetPos);
        }
    }

    public void brokenByAnything(World level, BlockPos blockPos, BlockState blockState, @Nullable PlayerEntity player) {
        if (this.dropItems(level, blockPos, player)) {
            this.killSeatEntities(level, blockPos);
            this.forEach(level, blockPos, target -> level.func_180501_a(target, Blocks.field_150350_a.func_176223_P(), 35));
        }
    }

    public void killSeatEntities(World level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((IBlockReader)level, blockPos);
        if (blockEntity != null) {
            OpenVector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            this.killSeatEntity(level, blockEntity.getParentPos(), seatPos);
        }
    }

    public boolean dropItems(World level, BlockPos blockPos, @Nullable PlayerEntity player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((IBlockReader)level, blockPos);
        SkinnableBlockEntity parentBlockEntity = this.getParentBlockEntity((IBlockReader)level, blockPos);
        if (blockEntity == null || parentBlockEntity == null || parentBlockEntity.isDropped()) {
            return false;
        }
        ItemStack droppedStack = parentBlockEntity.getSkin().asItemStack();
        blockEntity.setDropped(droppedStack);
        parentBlockEntity.setDropped(droppedStack);
        if (parentBlockEntity.isInventory()) {
            DataSerializers.dropContents(level, blockPos, (IInventory)parentBlockEntity);
        }
        return true;
    }

    private SkinnableBlockEntity getBlockEntity(IBlockReader level, BlockPos pos) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            SkinnableBlockEntity blockEntity1 = (SkinnableBlockEntity)blockEntity;
            return blockEntity1;
        }
        return null;
    }

    private SkinnableBlockEntity getParentBlockEntity(IBlockReader level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getParent();
        }
        return null;
    }

    @Nullable
    private SeatEntity getSeatEntity(ServerWorld level, BlockPos blockPos, OpenVector3d pos) {
        AxisAlignedBB searchRect = new AxisAlignedBB(pos.x(), pos.y(), pos.z(), pos.x() + 1.0, pos.y() + 1.0, pos.z() + 1.0);
        for (SeatEntity entity : level.func_217357_a(SeatEntity.class, searchRect)) {
            if (!entity.func_70089_S() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            if (entity.func_184188_bt().isEmpty()) {
                return entity;
            }
            return null;
        }
        SeatEntity entity = (SeatEntity)((IEntityType)ModEntityTypes.SEAT.get()).create(level, BlockPos.field_177992_a, null, SpawnReason.SPAWN_EGG);
        entity.func_70107_b(pos.x(), pos.y(), pos.z());
        entity.setBlockPos(blockPos);
        level.func_217376_c((Entity)entity);
        return entity;
    }

    private void killSeatEntity(World level, BlockPos blockPos, OpenVector3d pos) {
        AxisAlignedBB searchRect = new AxisAlignedBB(pos.x(), pos.y(), pos.z(), pos.x() + 1.0, pos.y() + 1.0, pos.z() + 1.0);
        for (SeatEntity entity : level.func_217357_a(SeatEntity.class, searchRect)) {
            if (!entity.func_70089_S() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            entity.func_174812_G();
        }
    }
}

