/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.other.EntitySlotsHandler;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EpicFightEntityRendererPatch;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntityRenderData
extends EntitySlotsHandler<Entity> {
    private EntityRenderPatch<? super Entity> renderPatch;

    public EntityRenderData(Entity entity) {
        super(entity, new EntitySlotsHandler.EntityProvider(), new EntitySlotsHandler.WardrobeProvider());
    }

    @Nullable
    public static EntityRenderData of(@Nullable Entity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).renderData().orElse(null);
        }
        return null;
    }

    public void tick(Entity entity) {
        this.tick(entity, SkinWardrobe.of(entity));
    }

    @Override
    public boolean isLimitLimbs() {
        if (this.renderPatch instanceof EpicFightEntityRendererPatch) {
            return false;
        }
        return super.isLimitLimbs();
    }

    public void setRenderPatch(EntityRenderPatch<? super Entity> renderPatch) {
        this.renderPatch = renderPatch;
    }

    public EntityRenderPatch<? super Entity> renderPatch() {
        return this.renderPatch;
    }
}

