/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CapabilityStorage {
    private static final ArrayList<Entry<?>> ENTRIES = new ArrayList();
    private static final CapabilityStorage NONE = new CapabilityStorage(new IdentityHashMap());
    private final IdentityHashMap<IEntityCapability<?>, Pair<Entry<?>, Optional<?>>> capabilities;

    CapabilityStorage(IdentityHashMap<IEntityCapability<?>, Pair<Entry<?>, Optional<?>>> capabilities) {
        this.capabilities = capabilities;
    }

    public static <T> void registerCapability(IResourceLocation registryName, IEntityCapability<T> capabilityType, Function<Entity, Optional<T>> provider) {
        ENTRIES.add(new Entry<T>(registryName, capabilityType, provider));
    }

    public static CapabilityStorage attachCapability(Entity entity) {
        if (ENTRIES.isEmpty()) {
            return NONE;
        }
        IdentityHashMap capabilities = new IdentityHashMap();
        for (Entry<?> entry : ENTRIES) {
            Optional cap = entry.provider.apply(entity);
            if (!cap.isPresent()) continue;
            capabilities.put(entry.capabilityType, Pair.of(entry, cap));
        }
        if (capabilities.isEmpty()) {
            return NONE;
        }
        return new CapabilityStorage(capabilities);
    }

    public static <T> Optional<T> getCapability(Entity entity, IEntityCapability<T> capabilityType) {
        CapabilityStorage storage = ((Provider)entity).getCapabilityStorage();
        Pair<Entry<?>, Optional<?>> value = storage.capabilities.get(capabilityType);
        if (value != null) {
            return (Optional)Objects.unsafeCast((Optional)value.getValue());
        }
        return Optional.empty();
    }

    public void save(Entity entity, CompoundNBT tag) {
        if (this == NONE) {
            return;
        }
        String capsKey = "ForgeCaps";
        CompoundNBT caps = OptionalAPI.getOptionalCompound(tag, capsKey).orElseGet(CompoundNBT::new);
        this.capabilities.values().forEach(pair -> {
            Object patt0$temp = ((Optional)pair.getValue()).orElse(null);
            if (patt0$temp instanceof IDataSerializable.Mutable) {
                IDataSerializable.Mutable provider = patt0$temp;
                CompoundNBT tag1 = new CompoundNBT();
                provider.serialize(SkinWardrobeStorage.encoder(entity, tag1));
                caps.func_218657_a(((Entry)pair.getKey()).registryName.toString(), (INBT)tag1);
            }
        });
        if (!caps.isEmpty()) {
            tag.func_218657_a(capsKey, (INBT)caps);
        } else {
            tag.func_82580_o(capsKey);
        }
    }

    public void load(Entity entity, CompoundNBT tag) {
        if (this == NONE) {
            return;
        }
        CompoundNBT caps = this.getCapTag(tag);
        if (caps == null || caps.isEmpty()) {
            return;
        }
        this.capabilities.values().forEach(pair -> {
            Object patt0$temp = ((Optional)pair.getValue()).orElse(null);
            if (patt0$temp instanceof IDataSerializable.Mutable) {
                IDataSerializable.Mutable provider = patt0$temp;
                INBT containerTag = caps.func_74781_a(((Entry)pair.getKey()).registryName.toString());
                if (containerTag instanceof CompoundNBT) {
                    CompoundNBT compoundTag = (CompoundNBT)containerTag;
                    provider.deserialize(SkinWardrobeStorage.decoder(entity, compoundTag));
                }
            }
        });
    }

    @Nullable
    private CompoundNBT getCapTag(CompoundNBT tag) {
        Optional<CompoundNBT> newValue = OptionalAPI.getOptionalCompound(tag, "neoforge:attachments");
        CompoundNBT oldValue = OptionalAPI.getOptionalCompound(tag, "ForgeCaps").orElse(null);
        if (oldValue != null) {
            return newValue.map(newCaps -> oldValue.func_74737_b().func_197643_a(newCaps)).orElse(oldValue);
        }
        return newValue.orElse(null);
    }

    private static class Entry<T> {
        IResourceLocation registryName;
        IEntityCapability<T> capabilityType;
        Function<Entity, Optional<T>> provider;

        Entry(IResourceLocation registryName, IEntityCapability<T> capabilityType, Function<Entity, Optional<T>> provider) {
            this.registryName = registryName;
            this.capabilityType = capabilityType;
            this.provider = provider;
        }
    }

    public static interface Provider {
        public CapabilityStorage getCapabilityStorage();
    }
}

