/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class SkinCache {

    public static class LRU<K, V> {
        private final Cache<K, V> cache;

        public LRU() {
            this.cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();
        }

        public LRU(int size) {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)size).expireAfterAccess(15L, TimeUnit.SECONDS).build();
        }

        public V computeIfAbsent(K key, Function<K, V> loader) {
            try {
                return (V)this.cache.get(key, () -> loader.apply(key));
            }
            catch (ExecutionException e) {
                return null;
            }
        }

        public void clear() {
            this.cache.cleanUp();
        }
    }
}

