/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MannequinItem
extends FlavouredItem {
    public MannequinItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean isSmall(ItemStack itemStack) {
        CompoundNBT entityTag = (CompoundNBT)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.isSmall();
        }
        return false;
    }

    public static float getScale(ItemStack itemStack) {
        CompoundNBT entityTag = (CompoundNBT)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.scale();
        }
        return 1.0f;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_221531_n() != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World level = context.func_195991_k();
        Vector3d origin = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        MannequinHitResult rayTraceResult = MannequinHitResult.test(player, origin, context.func_221532_j(), context.func_195995_a());
        ItemStack itemStack = context.func_195996_i();
        if (level instanceof ServerWorld) {
            ServerWorld serverLevel = (ServerWorld)level;
            MannequinEntity entity = (MannequinEntity)((IEntityType)ModEntityTypes.MANNEQUIN.get()).create(serverLevel, rayTraceResult.func_216350_a(), itemStack, SpawnReason.SPAWN_EGG);
            if (entity == null) {
                return ActionResultType.FAIL;
            }
            Vector3d clickedLocation = rayTraceResult.func_216347_e();
            entity.func_70080_a(clickedLocation.func_82615_a(), clickedLocation.func_82617_b(), clickedLocation.func_82616_c(), 0.0f, 0.0f);
            entity.func_181013_g(rayTraceResult.rotation());
            serverLevel.func_217376_c((Entity)entity);
            serverLevel.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187710_m, SoundCategory.BLOCKS, 0.75f, 0.8f);
            itemStack.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)serverLevel.func_201670_d());
        }
        return ActionResultType.FAIL;
    }

    public String func_77667_c(ItemStack itemStack) {
        float scale = MannequinItem.getScale(itemStack);
        if (scale <= 0.5f) {
            return super.func_77667_c(itemStack) + ".small";
        }
        if (scale >= 2.0f) {
            return super.func_77667_c(itemStack) + ".big";
        }
        return super.func_77667_c(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<ITextComponent> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.of(itemStack);
        if (descriptor.name() != null) {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.user", descriptor.name()));
        }
        if (descriptor.url() != null) {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.url", descriptor.url()));
        }
    }
}

