/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry;

import java.util.Collection;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometrySet;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometry;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class SkinGeometrySet<T extends SkinGeometry>
implements ISkinGeometrySet<T> {
    protected int id = -1;

    public int id() {
        return this.id;
    }

    @Override
    public OpenVoxelShape shape() {
        OpenPoseStack poseStack = new OpenPoseStack();
        OpenVoxelShape combinedShape = new OpenVoxelShape();
        for (SkinGeometry geometry : this) {
            OpenVoxelShape shape = geometry.shape();
            OpenTransform3f transform = geometry.transform();
            if (transform.isIdentity()) {
                combinedShape.add(shape);
                continue;
            }
            poseStack.pushPose();
            OpenVoxelShape shape1 = shape.copy();
            transform.apply(poseStack);
            shape1.mul(poseStack.last().pose());
            combinedShape.add(shape1);
            poseStack.popPose();
        }
        combinedShape.optimize();
        return combinedShape;
    }

    @Override
    @Nullable
    public Collection<SkinGeometryType> supportedTypes() {
        return null;
    }

    public String toString() {
        return Objects.toString(this, "id", this.id(), "size", this.size(), "types", this.supportedTypes());
    }
}

