/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part.bow;

import com.google.common.collect.Range;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanHeld;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanUse;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;

public class BowPartType
extends SkinPartType
implements ICanHeld,
ICanUse {
    private final int frame;
    private final Range<Integer> useRange;

    public BowPartType(int frame) {
        this.frame = frame;
        this.buildingSpace = new OpenRectangle3i(-12, -42, -46, 24, 84, 64);
        this.guideSpace = new OpenRectangle3i(-2, -2, 2, 4, 4, 8);
        this.offset = BowPartType.frameOffset(frame);
        this.useRange = BowPartType.frameUseRange(frame);
    }

    public static Range<Integer> frameUseRange(int frame) {
        Range range;
        switch (frame) {
            case 0: {
                range = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
                break;
            }
            case 1: {
                range = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12));
                break;
            }
            case 2: {
                range = Range.closed((Comparable)Integer.valueOf(13), (Comparable)Integer.valueOf(17));
                break;
            }
            default: {
                range = Range.closed((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(30));
            }
        }
        return range;
    }

    public static OpenVector3i frameOffset(int frame) {
        OpenVector3i openVector3i;
        switch (frame) {
            case 0: {
                openVector3i = new OpenVector3i(-50, 0, 0);
                break;
            }
            case 1: {
                openVector3i = new OpenVector3i(-25, 0, 0);
                break;
            }
            case 2: {
                openVector3i = new OpenVector3i(0, 0, 0);
                break;
            }
            case 3: {
                openVector3i = new OpenVector3i(25, 0, 0);
                break;
            }
            default: {
                openVector3i = null;
            }
        }
        return openVector3i;
    }

    @Override
    public Range<Integer> useRange() {
        return this.useRange;
    }

    @Override
    public int minimumMarkersNeeded() {
        return 1;
    }

    @Override
    public int maximumMarkersNeeded() {
        return 1;
    }

    @Override
    public boolean isPartRequired() {
        return this.frame != 0;
    }
}

